
package org.datacontract.schemas.radixx.connectpoint.pricing;

/** 
 * 
 <summary>Fare Selection Type for Fast Fare Search</summary>
 <remarks/>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enums.FareSelectionType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="All"/>
 *     &lt;xs:enumeration value="OneWayOnly"/>
 *     &lt;xs:enumeration value="RoundTripOnly"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumsFareSelectionType {
    /** 
     * 
    <summary>Return Oneway, Rount Trip and Open Jaw Fares</summary>
    
     */
    ALL("All"), /** 
                 * 
                			<summary>Return only Oneway fares</summary>
                		
                 */
    ONE_WAY_ONLY("OneWayOnly"), /** 
                                 * 
                                <summary>Return only Round Trip fares</summary>
                                
                                 */
    ROUND_TRIP_ONLY("RoundTripOnly");
    private final String value;

    private EnumsFareSelectionType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumsFareSelectionType convert(String value) {
        for (EnumsFareSelectionType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
