
package org.datacontract.schemas.radixx.connectpoint.pricing;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewServiceQuote">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:int" name="ServiceID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrier"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MarketingCarrier"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CodeType"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Description"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyCode"/>
 *     &lt;xs:element type="xs:decimal" name="Amount"/>
 *     &lt;xs:element type="xs:boolean" name="AmountActive"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AmountType"/>
 *     &lt;xs:element type="xs:int" name="CategoryID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SSRCode"/>
 *     &lt;xs:element type="xs:boolean" name="Display"/>
 *     &lt;xs:element type="xs:int" name="MaxCountServiceLevel"/>
 *     &lt;xs:element type="xs:boolean" name="Refundable"/>
 *     &lt;xs:element type="xs:boolean" name="PNLActive"/>
 *     &lt;xs:element type="xs:int" name="CutoffHours"/>
 *     &lt;xs:element type="xs:boolean" name="Commissionable"/>
 *     &lt;xs:element type="xs:int" name="DisplayOrder"/>
 *     &lt;xs:element type="xs:int" name="RevenueCategoryID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATAStandardCodeType"/>
 *     &lt;xs:element type="xs:boolean" name="ServiceActive"/>
 *     &lt;xs:element type="xs:int" name="MaxCountFlightLevel"/>
 *     &lt;xs:element type="xs:int" name="QuantityAvailable"/>
 *     &lt;xs:element type="xs:int" name="StartSalesDays"/>
 *     &lt;xs:element type="ns:ArrayOfApplicableTax" nillable="true" name="ApplicableTaxes"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewServiceQuote
{
    private int logicalFlightID;
    private int serviceID;
    private Date departureDate;
    private String operatingCarrier;
    private String marketingCarrier;
    private String codeType;
    private String description;
    private String currencyCode;
    private BigDecimal amount;
    private boolean amountActive;
    private String amountType;
    private int categoryID;
    private String SSRCode;
    private boolean display;
    private int maxCountServiceLevel;
    private boolean refundable;
    private boolean PNLActive;
    private int cutoffHours;
    private boolean commissionable;
    private int displayOrder;
    private int revenueCategoryID;
    private String IATAStandardCodeType;
    private boolean serviceActive;
    private int maxCountFlightLevel;
    private int quantityAvailable;
    private int startSalesDays;
    private ArrayOfApplicableTax applicableTaxes;

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: Logical flight ID that matches the request. The consuming client
    					logic can use this value for gruoping response information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: Logical flight ID that matches the request. The consuming client
    					logic can use this value for gruoping response information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'ServiceID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param serviceID
     */
    public void setServiceID(int serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: Departure Date that matches the request. The consuming client
    					logic can use this value for gruoping response information.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: Departure Date that matches the request. The consuming client
    					logic can use this value for gruoping response information.
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'OperatingCarrier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(String operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'MarketingCarrier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(String marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the 'CodeType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCodeType() {
        return codeType;
    }

    /** 
     * Set the 'CodeType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param codeType
     */
    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    /** 
     * Get the 'Description' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'CurrencyCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'Amount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'AmountActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isAmountActive() {
        return amountActive;
    }

    /** 
     * Set the 'AmountActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param amountActive
     */
    public void setAmountActive(boolean amountActive) {
        this.amountActive = amountActive;
    }

    /** 
     * Get the 'AmountType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAmountType() {
        return amountType;
    }

    /** 
     * Set the 'AmountType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param amountType
     */
    public void setAmountType(String amountType) {
        this.amountType = amountType;
    }

    /** 
     * Get the 'CategoryID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getCategoryID() {
        return categoryID;
    }

    /** 
     * Set the 'CategoryID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param categoryID
     */
    public void setCategoryID(int categoryID) {
        this.categoryID = categoryID;
    }

    /** 
     * Get the 'SSRCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSSRCode() {
        return SSRCode;
    }

    /** 
     * Set the 'SSRCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param SSRCode
     */
    public void setSSRCode(String SSRCode) {
        this.SSRCode = SSRCode;
    }

    /** 
     * Get the 'Display' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isDisplay() {
        return display;
    }

    /** 
     * Set the 'Display' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param display
     */
    public void setDisplay(boolean display) {
        this.display = display;
    }

    /** 
     * Get the 'MaxCountServiceLevel' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getMaxCountServiceLevel() {
        return maxCountServiceLevel;
    }

    /** 
     * Set the 'MaxCountServiceLevel' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param maxCountServiceLevel
     */
    public void setMaxCountServiceLevel(int maxCountServiceLevel) {
        this.maxCountServiceLevel = maxCountServiceLevel;
    }

    /** 
     * Get the 'Refundable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isRefundable() {
        return refundable;
    }

    /** 
     * Set the 'Refundable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param refundable
     */
    public void setRefundable(boolean refundable) {
        this.refundable = refundable;
    }

    /** 
     * Get the 'PNLActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isPNLActive() {
        return PNLActive;
    }

    /** 
     * Set the 'PNLActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param PNLActive
     */
    public void setPNLActive(boolean PNLActive) {
        this.PNLActive = PNLActive;
    }

    /** 
     * Get the 'CutoffHours' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getCutoffHours() {
        return cutoffHours;
    }

    /** 
     * Set the 'CutoffHours' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param cutoffHours
     */
    public void setCutoffHours(int cutoffHours) {
        this.cutoffHours = cutoffHours;
    }

    /** 
     * Get the 'Commissionable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isCommissionable() {
        return commissionable;
    }

    /** 
     * Set the 'Commissionable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param commissionable
     */
    public void setCommissionable(boolean commissionable) {
        this.commissionable = commissionable;
    }

    /** 
     * Get the 'DisplayOrder' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getDisplayOrder() {
        return displayOrder;
    }

    /** 
     * Set the 'DisplayOrder' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param displayOrder
     */
    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    /** 
     * Get the 'RevenueCategoryID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getRevenueCategoryID() {
        return revenueCategoryID;
    }

    /** 
     * Set the 'RevenueCategoryID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param revenueCategoryID
     */
    public void setRevenueCategoryID(int revenueCategoryID) {
        this.revenueCategoryID = revenueCategoryID;
    }

    /** 
     * Get the 'IATAStandardCodeType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getIATAStandardCodeType() {
        return IATAStandardCodeType;
    }

    /** 
     * Set the 'IATAStandardCodeType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param IATAStandardCodeType
     */
    public void setIATAStandardCodeType(String IATAStandardCodeType) {
        this.IATAStandardCodeType = IATAStandardCodeType;
    }

    /** 
     * Get the 'ServiceActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isServiceActive() {
        return serviceActive;
    }

    /** 
     * Set the 'ServiceActive' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param serviceActive
     */
    public void setServiceActive(boolean serviceActive) {
        this.serviceActive = serviceActive;
    }

    /** 
     * Get the 'MaxCountFlightLevel' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getMaxCountFlightLevel() {
        return maxCountFlightLevel;
    }

    /** 
     * Set the 'MaxCountFlightLevel' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param maxCountFlightLevel
     */
    public void setMaxCountFlightLevel(int maxCountFlightLevel) {
        this.maxCountFlightLevel = maxCountFlightLevel;
    }

    /** 
     * Get the 'QuantityAvailable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getQuantityAvailable() {
        return quantityAvailable;
    }

    /** 
     * Set the 'QuantityAvailable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param quantityAvailable
     */
    public void setQuantityAvailable(int quantityAvailable) {
        this.quantityAvailable = quantityAvailable;
    }

    /** 
     * Get the 'StartSalesDays' element value. 
    					Description: The number of days before flight departure that the Special
    					Service is allowed to be sold.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getStartSalesDays() {
        return startSalesDays;
    }

    /** 
     * Set the 'StartSalesDays' element value. 
    					Description: The number of days before flight departure that the Special
    					Service is allowed to be sold.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param startSalesDays
     */
    public void setStartSalesDays(int startSalesDays) {
        this.startSalesDays = startSalesDays;
    }

    /** 
     * Get the 'ApplicableTaxes' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfApplicableTax getApplicableTaxes() {
        return applicableTaxes;
    }

    /** 
     * Set the 'ApplicableTaxes' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param applicableTaxes
     */
    public void setApplicableTaxes(ArrayOfApplicableTax applicableTaxes) {
        this.applicableTaxes = applicableTaxes;
    }
}
