
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsDateSearchType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareFilterGroupingsMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareGroupMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareSelectionType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsInventoryFilterMethodType;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:ns2="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.FastFareSearch" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FastFareSearchInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CurrencyOfFastFareSearch"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PromotionalCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IataNumberOfRequestor"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CabinToSearch"/>
 *     &lt;xs:element type="ns1:Enums.InventoryFilterMethodType" name="InventoryTypeToSearch"/>
 *     &lt;xs:element type="ns1:Enums.FareFilterGroupingsMethodType" name="FareFilterGrouping"/>
 *     &lt;xs:element type="ns1:Enums.FareGroupMethodType" name="FareFilterTypeToSearch"/>
 *     &lt;xs:element type="ns1:Enums.DateSearchType" name="DateSearchType"/>
 *     &lt;xs:element type="ns1:Enums.FareSelectionType" name="FareSelectionType"/>
 *     &lt;xs:element type="ns2:ArrayOfFastFareSearchTripDetail" nillable="true" name="FastFareSearchTripDetails"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FastFareSearchInfo
{
    private EnumerationsCurrencyCodeTypes currencyOfFastFareSearch;
    private String promotionalCode;
    private String iataNumberOfRequestor;
    private String cabinToSearch;
    private EnumsInventoryFilterMethodType inventoryTypeToSearch;
    private EnumsFareFilterGroupingsMethodType fareFilterGrouping;
    private EnumsFareGroupMethodType fareFilterTypeToSearch;
    private EnumsDateSearchType dateSearchType;
    private EnumsFareSelectionType fareSelectionType;
    private ArrayOfFastFareSearchTripDetail fastFareSearchTripDetails;

    /** 
     * Get the 'CurrencyOfFastFareSearch' element value. Description: The currency to be used for pricing.
    				Constraints: Required.Range: Value must be in the range 3 and 3.
    				Format: AlphaUpper.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyOfFastFareSearch() {
        return currencyOfFastFareSearch;
    }

    /** 
     * Set the 'CurrencyOfFastFareSearch' element value. Description: The currency to be used for pricing.
    				Constraints: Required.Range: Value must be in the range 3 and 3.
    				Format: AlphaUpper.
     * 
     * @param currencyOfFastFareSearch
     */
    public void setCurrencyOfFastFareSearch(
            EnumerationsCurrencyCodeTypes currencyOfFastFareSearch) {
        this.currencyOfFastFareSearch = currencyOfFastFareSearch;
    }

    /** 
     * Get the 'PromotionalCode' element value. Description: Promotional code to apply.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 20.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getPromotionalCode() {
        return promotionalCode;
    }

    /** 
     * Set the 'PromotionalCode' element value. Description: Promotional code to apply.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 20.
    				Format: AlphaNumericCode.
     * 
     * @param promotionalCode
     */
    public void setPromotionalCode(String promotionalCode) {
        this.promotionalCode = promotionalCode;
    }

    /** 
     * Get the 'IataNumberOfRequestor' element value. Description: IATA Number associated to fares.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @return value
     */
    public String getIataNumberOfRequestor() {
        return iataNumberOfRequestor;
    }

    /** 
     * Set the 'IataNumberOfRequestor' element value. Description: IATA Number associated to fares.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @param iataNumberOfRequestor
     */
    public void setIataNumberOfRequestor(String iataNumberOfRequestor) {
        this.iataNumberOfRequestor = iataNumberOfRequestor;
    }

    /** 
     * Get the 'CabinToSearch' element value. Description: Cabin to search.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCabinToSearch() {
        return cabinToSearch;
    }

    /** 
     * Set the 'CabinToSearch' element value. Description: Cabin to search.Constraints: Optional (Not Required).
    				
     * 
     * @param cabinToSearch
     */
    public void setCabinToSearch(String cabinToSearch) {
        this.cabinToSearch = cabinToSearch;
    }

    /** 
     * Get the 'InventoryTypeToSearch' element value. 
    					Description: indicator of inventory needing to be searched (Available Only or
    					All (Including non-available)).
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumsInventoryFilterMethodType getInventoryTypeToSearch() {
        return inventoryTypeToSearch;
    }

    /** 
     * Set the 'InventoryTypeToSearch' element value. 
    					Description: indicator of inventory needing to be searched (Available Only or
    					All (Including non-available)).
    				Constraints: Required.
     * 
     * @param inventoryTypeToSearch
     */
    public void setInventoryTypeToSearch(
            EnumsInventoryFilterMethodType inventoryTypeToSearch) {
        this.inventoryTypeToSearch = inventoryTypeToSearch;
    }

    /** 
     * Get the 'FareFilterGrouping' element value. 
    					Description: Fare Filter Grouping Method applies different rules to the fare
    					selection logic.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumsFareFilterGroupingsMethodType getFareFilterGrouping() {
        return fareFilterGrouping;
    }

    /** 
     * Set the 'FareFilterGrouping' element value. 
    					Description: Fare Filter Grouping Method applies different rules to the fare
    					selection logic.
    				Constraints: Required.
     * 
     * @param fareFilterGrouping
     */
    public void setFareFilterGrouping(
            EnumsFareFilterGroupingsMethodType fareFilterGrouping) {
        this.fareFilterGrouping = fareFilterGrouping;
    }

    /** 
     * Get the 'FareFilterTypeToSearch' element value. 
    					Description: Fare Filter Method applies different rules to the fare selection
    					logic.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumsFareGroupMethodType getFareFilterTypeToSearch() {
        return fareFilterTypeToSearch;
    }

    /** 
     * Set the 'FareFilterTypeToSearch' element value. 
    					Description: Fare Filter Method applies different rules to the fare selection
    					logic.
    				Constraints: Required.
     * 
     * @param fareFilterTypeToSearch
     */
    public void setFareFilterTypeToSearch(
            EnumsFareGroupMethodType fareFilterTypeToSearch) {
        this.fareFilterTypeToSearch = fareFilterTypeToSearch;
    }

    /** 
     * Get the 'DateSearchType' element value. 
    					Description: indicator of how search is being requested (Flexible or Date
    					Range).
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumsDateSearchType getDateSearchType() {
        return dateSearchType;
    }

    /** 
     * Set the 'DateSearchType' element value. 
    					Description: indicator of how search is being requested (Flexible or Date
    					Range).
    				Constraints: Required.
     * 
     * @param dateSearchType
     */
    public void setDateSearchType(EnumsDateSearchType dateSearchType) {
        this.dateSearchType = dateSearchType;
    }

    /** 
     * Get the 'FareSelectionType' element value. 
    					Description: indicator of the fares that should be searched (All - Oneway,
    					RoundTrip, and OpenJaw ~ OnewayOnly ~ RoundTripOnly).
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumsFareSelectionType getFareSelectionType() {
        return fareSelectionType;
    }

    /** 
     * Set the 'FareSelectionType' element value. 
    					Description: indicator of the fares that should be searched (All - Oneway,
    					RoundTrip, and OpenJaw ~ OnewayOnly ~ RoundTripOnly).
    				Constraints: Required.
     * 
     * @param fareSelectionType
     */
    public void setFareSelectionType(EnumsFareSelectionType fareSelectionType) {
        this.fareSelectionType = fareSelectionType;
    }

    /** 
     * Get the 'FastFareSearchTripDetails' element value. 
    					Description: The details of each trip being requested to be searched.
    				Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public ArrayOfFastFareSearchTripDetail getFastFareSearchTripDetails() {
        return fastFareSearchTripDetails;
    }

    /** 
     * Set the 'FastFareSearchTripDetails' element value. 
    					Description: The details of each trip being requested to be searched.
    				Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @param fastFareSearchTripDetails
     */
    public void setFastFareSearchTripDetails(
            ArrayOfFastFareSearchTripDetail fastFareSearchTripDetails) {
        this.fastFareSearchTripDetails = fastFareSearchTripDetails;
    }
}
