
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.FastFareSearch" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FastFareSearchTripDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="DepartureLocation"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ArrivalLocation"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:int" name="NumberOfFelxibleDaysBefore"/>
 *     &lt;xs:element type="xs:int" name="NumberOfFlexibleDaysAfter"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDateBeginRange"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDateEndRange"/>
 *     &lt;xs:element type="xs:int" name="TripOrderIndex"/>
 *     &lt;xs:element type="ns:ArrayOfFastFareSearchTravelerInfo" nillable="true" name="FastFareSearchTravelerInfos"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FastFareSearchTripDetail
{
    private String departureLocation;
    private String arrivalLocation;
    private Date departureDate;
    private int numberOfFelxibleDaysBefore;
    private int numberOfFlexibleDaysAfter;
    private Date departureDateBeginRange;
    private Date departureDateEndRange;
    private int tripOrderIndex;
    private ArrayOfFastFareSearchTravelerInfo fastFareSearchTravelerInfos;

    /** 
     * Get the 'DepartureLocation' element value. Description: Origin airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getDepartureLocation() {
        return departureLocation;
    }

    /** 
     * Set the 'DepartureLocation' element value. Description: Origin airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param departureLocation
     */
    public void setDepartureLocation(String departureLocation) {
        this.departureLocation = departureLocation;
    }

    /** 
     * Get the 'ArrivalLocation' element value. Description: Destination airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getArrivalLocation() {
        return arrivalLocation;
    }

    /** 
     * Set the 'ArrivalLocation' element value. Description: Destination airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param arrivalLocation
     */
    public void setArrivalLocation(String arrivalLocation) {
        this.arrivalLocation = arrivalLocation;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: The departure date to search for.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: The departure date to search for.
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'NumberOfFelxibleDaysBefore' element value. 
    					Description: Number of scheduled days before departure date to include in
    					search.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 364.
    				
     * 
     * @return value
     */
    public int getNumberOfFelxibleDaysBefore() {
        return numberOfFelxibleDaysBefore;
    }

    /** 
     * Set the 'NumberOfFelxibleDaysBefore' element value. 
    					Description: Number of scheduled days before departure date to include in
    					search.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 364.
    				
     * 
     * @param numberOfFelxibleDaysBefore
     */
    public void setNumberOfFelxibleDaysBefore(int numberOfFelxibleDaysBefore) {
        this.numberOfFelxibleDaysBefore = numberOfFelxibleDaysBefore;
    }

    /** 
     * Get the 'NumberOfFlexibleDaysAfter' element value. 
    					Description: Number of scheduled days after departure date to include in
    					search.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 364.
    				
     * 
     * @return value
     */
    public int getNumberOfFlexibleDaysAfter() {
        return numberOfFlexibleDaysAfter;
    }

    /** 
     * Set the 'NumberOfFlexibleDaysAfter' element value. 
    					Description: Number of scheduled days after departure date to include in
    					search.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 364.
    				
     * 
     * @param numberOfFlexibleDaysAfter
     */
    public void setNumberOfFlexibleDaysAfter(int numberOfFlexibleDaysAfter) {
        this.numberOfFlexibleDaysAfter = numberOfFlexibleDaysAfter;
    }

    /** 
     * Get the 'DepartureDateBeginRange' element value. 
    					Description: The beginning departure date range requesting to be searched.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDateBeginRange() {
        return departureDateBeginRange;
    }

    /** 
     * Set the 'DepartureDateBeginRange' element value. 
    					Description: The beginning departure date range requesting to be searched.
    				Constraints: Required.
     * 
     * @param departureDateBeginRange
     */
    public void setDepartureDateBeginRange(Date departureDateBeginRange) {
        this.departureDateBeginRange = departureDateBeginRange;
    }

    /** 
     * Get the 'DepartureDateEndRange' element value. 
    					Description: The ending departure date range requesting to be searched.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDateEndRange() {
        return departureDateEndRange;
    }

    /** 
     * Set the 'DepartureDateEndRange' element value. 
    					Description: The ending departure date range requesting to be searched.
    				Constraints: Required.
     * 
     * @param departureDateEndRange
     */
    public void setDepartureDateEndRange(Date departureDateEndRange) {
        this.departureDateEndRange = departureDateEndRange;
    }

    /** 
     * Get the 'TripOrderIndex' element value. 
    					Description: Numeric value indication the trip info order in requested travel
    					sequence.
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @return value
     */
    public int getTripOrderIndex() {
        return tripOrderIndex;
    }

    /** 
     * Set the 'TripOrderIndex' element value. 
    					Description: Numeric value indication the trip info order in requested travel
    					sequence.
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @param tripOrderIndex
     */
    public void setTripOrderIndex(int tripOrderIndex) {
        this.tripOrderIndex = tripOrderIndex;
    }

    /** 
     * Get the 'FastFareSearchTravelerInfos' element value. 
    					Description: List of passenger types to include in the search.
    				Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public ArrayOfFastFareSearchTravelerInfo getFastFareSearchTravelerInfos() {
        return fastFareSearchTravelerInfos;
    }

    /** 
     * Set the 'FastFareSearchTravelerInfos' element value. 
    					Description: List of passenger types to include in the search.
    				Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @param fastFareSearchTravelerInfos
     */
    public void setFastFareSearchTravelerInfos(
            ArrayOfFastFareSearchTravelerInfo fastFareSearchTravelerInfos) {
        this.fastFareSearchTravelerInfos = fastFareSearchTravelerInfos;
    }
}
