
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareFilterMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareGroupMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsInventoryFilterMethodType;

/** 
 * 
 <summary>Fare Pricing by Date Range</summary>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.FareQuote" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns2="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveFareQuoteByDateRange">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="CurrencyOfFareQuote"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="PromotionalCode"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IataNumberOfRequestor"/>
 *         &lt;xs:element type="xs:int" name="CorporationID"/>
 *         &lt;xs:element type="ns2:Enums.FareFilterMethodType" name="FareFilterMethod"/>
 *         &lt;xs:element type="ns2:Enums.FareGroupMethodType" name="FareGroupMethod"/>
 *         &lt;xs:element type="ns2:Enums.InventoryFilterMethodType" name="InventoryFilterMethod"/>
 *         &lt;xs:element type="ns:ArrayOfFareQuoteDetailDateRange" nillable="true" name="FareQuoteDetails"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveFareQuoteByDateRange extends TransactionInfo
{
    private String currencyOfFareQuote;
    private String promotionalCode;
    private String iataNumberOfRequestor;
    private int corporationID;
    private EnumsFareFilterMethodType fareFilterMethod;
    private EnumsFareGroupMethodType fareGroupMethod;
    private EnumsInventoryFilterMethodType inventoryFilterMethod;
    private ArrayOfFareQuoteDetailDateRange fareQuoteDetails;

    /** 
     * Get the 'CurrencyOfFareQuote' element value. Description: The currency to be used for
    							pricing.Constraints: Required.Range: Length must be in the range 3 and 3.
    						Format: AlphaUpper.
     * 
     * @return value
     */
    public String getCurrencyOfFareQuote() {
        return currencyOfFareQuote;
    }

    /** 
     * Set the 'CurrencyOfFareQuote' element value. Description: The currency to be used for
    							pricing.Constraints: Required.Range: Length must be in the range 3 and 3.
    						Format: AlphaUpper.
     * 
     * @param currencyOfFareQuote
     */
    public void setCurrencyOfFareQuote(String currencyOfFareQuote) {
        this.currencyOfFareQuote = currencyOfFareQuote;
    }

    /** 
     * Get the 'PromotionalCode' element value. Description: Promotional code to apply.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 20.
    						Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getPromotionalCode() {
        return promotionalCode;
    }

    /** 
     * Set the 'PromotionalCode' element value. Description: Promotional code to apply.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 20.
    						Format: AlphaNumericCode.
     * 
     * @param promotionalCode
     */
    public void setPromotionalCode(String promotionalCode) {
        this.promotionalCode = promotionalCode;
    }

    /** 
     * Get the 'IataNumberOfRequestor' element value. Description: IATA Number associated to fares.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 8.
    						
     * 
     * @return value
     */
    public String getIataNumberOfRequestor() {
        return iataNumberOfRequestor;
    }

    /** 
     * Set the 'IataNumberOfRequestor' element value. Description: IATA Number associated to fares.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 8.
    						
     * 
     * @param iataNumberOfRequestor
     */
    public void setIataNumberOfRequestor(String iataNumberOfRequestor) {
        this.iataNumberOfRequestor = iataNumberOfRequestor;
    }

    /** 
     * Get the 'CorporationID' element value. Description: Corporation ID associated to
    							fares.Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public int getCorporationID() {
        return corporationID;
    }

    /** 
     * Set the 'CorporationID' element value. Description: Corporation ID associated to
    							fares.Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param corporationID
     */
    public void setCorporationID(int corporationID) {
        this.corporationID = corporationID;
    }

    /** 
     * Get the 'FareFilterMethod' element value. 
    							Description: Fare Filter Method applies different rules to the fare
    							selection logic.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumsFareFilterMethodType getFareFilterMethod() {
        return fareFilterMethod;
    }

    /** 
     * Set the 'FareFilterMethod' element value. 
    							Description: Fare Filter Method applies different rules to the fare
    							selection logic.
    						Constraints: Required.
     * 
     * @param fareFilterMethod
     */
    public void setFareFilterMethod(EnumsFareFilterMethodType fareFilterMethod) {
        this.fareFilterMethod = fareFilterMethod;
    }

    /** 
     * Get the 'FareGroupMethod' element value. 
    							Description: Fare Group Method applies different rules to the fare grouping
    							logic.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumsFareGroupMethodType getFareGroupMethod() {
        return fareGroupMethod;
    }

    /** 
     * Set the 'FareGroupMethod' element value. 
    							Description: Fare Group Method applies different rules to the fare grouping
    							logic.
    						Constraints: Required.
     * 
     * @param fareGroupMethod
     */
    public void setFareGroupMethod(EnumsFareGroupMethodType fareGroupMethod) {
        this.fareGroupMethod = fareGroupMethod;
    }

    /** 
     * Get the 'InventoryFilterMethod' element value. 
    							Description: Inventory Filter Method applies different rules regarding
    							number of available seats.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumsInventoryFilterMethodType getInventoryFilterMethod() {
        return inventoryFilterMethod;
    }

    /** 
     * Set the 'InventoryFilterMethod' element value. 
    							Description: Inventory Filter Method applies different rules regarding
    							number of available seats.
    						Constraints: Required.
     * 
     * @param inventoryFilterMethod
     */
    public void setInventoryFilterMethod(
            EnumsInventoryFilterMethodType inventoryFilterMethod) {
        this.inventoryFilterMethod = inventoryFilterMethod;
    }

    /** 
     * Get the 'FareQuoteDetails' element value. Description: The legs to search.
    						Constraints: Required.Range: Value must be in the range 1 and 20.
    						
     * 
     * @return value
     */
    public ArrayOfFareQuoteDetailDateRange getFareQuoteDetails() {
        return fareQuoteDetails;
    }

    /** 
     * Set the 'FareQuoteDetails' element value. Description: The legs to search.
    						Constraints: Required.Range: Value must be in the range 1 and 20.
    						
     * 
     * @param fareQuoteDetails
     */
    public void setFareQuoteDetails(
            ArrayOfFareQuoteDetailDateRange fareQuoteDetails) {
        this.fareQuoteDetails = fareQuoteDetails;
    }
}
