
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsReservationChannelTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.Service" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceQuote">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AirportCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ServiceCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Cabin"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Category"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="Currency"/>
 *     &lt;xs:element type="xs:long" name="UTCOffset"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrierCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MarketingCarrierCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareClass"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareBasisCode"/>
 *     &lt;xs:element type="ns:Enumerations.ReservationChannelTypes" name="ReservationChannel"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationAirportCode"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceQuote
{
    private int logicalFlightID;
    private Date departureDate;
    private String airportCode;
    private String serviceCode;
    private String cabin;
    private String category;
    private EnumerationsCurrencyCodeTypes currency;
    private long UTCOffset;
    private String operatingCarrierCode;
    private String marketingCarrierCode;
    private String fareClass;
    private String fareBasisCode;
    private EnumerationsReservationChannelTypes reservationChannel;
    private String destinationAirportCode;

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: Retrieve services for this logical flight ID..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: Retrieve services for this logical flight ID..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: Retrieve services for this departrue date.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: Retrieve services for this departrue date.
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'AirportCode' element value. Description: Airport code.Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'AirportCode' element value. Description: Airport code.Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'ServiceCode' element value. 
    					Description: Limit the search results to this service code..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getServiceCode() {
        return serviceCode;
    }

    /** 
     * Set the 'ServiceCode' element value. 
    					Description: Limit the search results to this service code..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param serviceCode
     */
    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    /** 
     * Get the 'Cabin' element value. 
    					Description: Limit the search results to this cabin..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 13.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value. 
    					Description: Limit the search results to this cabin..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 13.
    				Format: AlphaNumericCode.
     * 
     * @param cabin
     */
    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'Category' element value. 
    					Description: Limit the results to this service category..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCategory() {
        return category;
    }

    /** 
     * Set the 'Category' element value. 
    					Description: Limit the results to this service category..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param category
     */
    public void setCategory(String category) {
        this.category = category;
    }

    /** 
     * Get the 'Currency' element value. Description: The currency to be used for pricing.
    				Constraints: Required.Range: Value must be in the range 3 and 3.
    				Format: AlphaUpper.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value. Description: The currency to be used for pricing.
    				Constraints: Required.Range: Value must be in the range 3 and 3.
    				Format: AlphaUpper.
     * 
     * @param currency
     */
    public void setCurrency(EnumerationsCurrencyCodeTypes currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'UTCOffset' element value. Description: Universal Time (UTC) offset.
    				Constraints: Required.
     * 
     * @return value
     */
    public long getUTCOffset() {
        return UTCOffset;
    }

    /** 
     * Set the 'UTCOffset' element value. Description: Universal Time (UTC) offset.
    				Constraints: Required.
     * 
     * @param UTCOffset
     */
    public void setUTCOffset(long UTCOffset) {
        this.UTCOffset = UTCOffset;
    }

    /** 
     * Get the 'OperatingCarrierCode' element value. 
    					Description: Limit the search results to this operating carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getOperatingCarrierCode() {
        return operatingCarrierCode;
    }

    /** 
     * Set the 'OperatingCarrierCode' element value. 
    					Description: Limit the search results to this operating carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @param operatingCarrierCode
     */
    public void setOperatingCarrierCode(String operatingCarrierCode) {
        this.operatingCarrierCode = operatingCarrierCode;
    }

    /** 
     * Get the 'MarketingCarrierCode' element value. 
    					Description: Limit the search results to this marketing carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getMarketingCarrierCode() {
        return marketingCarrierCode;
    }

    /** 
     * Set the 'MarketingCarrierCode' element value. 
    					Description: Limit the search results to this marketing carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @param marketingCarrierCode
     */
    public void setMarketingCarrierCode(String marketingCarrierCode) {
        this.marketingCarrierCode = marketingCarrierCode;
    }

    /** 
     * Get the 'FareClass' element value. 
    					Description: Limit the search results to this fare class..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 2.
    				Format: AlphaUpper.
     * 
     * @return value
     */
    public String getFareClass() {
        return fareClass;
    }

    /** 
     * Set the 'FareClass' element value. 
    					Description: Limit the search results to this fare class..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 2.
    				Format: AlphaUpper.
     * 
     * @param fareClass
     */
    public void setFareClass(String fareClass) {
        this.fareClass = fareClass;
    }

    /** 
     * Get the 'FareBasisCode' element value. 
    					Description: Limit the search results to this fare basis code..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. 
    					Description: Limit the search results to this fare basis code..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumericCode.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'ReservationChannel' element value. 
    					Description: Find services for this reservation channel..
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsReservationChannelTypes getReservationChannel() {
        return reservationChannel;
    }

    /** 
     * Set the 'ReservationChannel' element value. 
    					Description: Find services for this reservation channel..
    				Constraints: Required.
     * 
     * @param reservationChannel
     */
    public void setReservationChannel(
            EnumerationsReservationChannelTypes reservationChannel) {
        this.reservationChannel = reservationChannel;
    }

    /** 
     * Get the 'DestinationAirportCode' element value. Description: Destination Airport code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getDestinationAirportCode() {
        return destinationAirportCode;
    }

    /** 
     * Set the 'DestinationAirportCode' element value. Description: Destination Airport code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param destinationAirportCode
     */
    public void setDestinationAirportCode(String destinationAirportCode) {
        this.destinationAirportCode = destinationAirportCode;
    }
}
