
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address1"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address2"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="City"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="State"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Postal"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Country"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CountryCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AreaCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhoneNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Display"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Address
{
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String postal;
    private String country;
    private String countryCode;
    private String areaCode;
    private String phoneNumber;
    private String display;

    /** 
     * Get the 'Address1' element value. Description: The first address line of the
    					person.Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getAddress1() {
        return address1;
    }

    /** 
     * Set the 'Address1' element value. Description: The first address line of the
    					person.Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param address1
     */
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    /** 
     * Get the 'Address2' element value. 
    					Description: The second address line of the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 100.
    				
     * 
     * @return value
     */
    public String getAddress2() {
        return address2;
    }

    /** 
     * Set the 'Address2' element value. 
    					Description: The second address line of the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 100.
    				
     * 
     * @param address2
     */
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    /** 
     * Get the 'City' element value. Description: The city for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. Description: The city for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'State' element value. Description: The state for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getState() {
        return state;
    }

    /** 
     * Set the 'State' element value. Description: The state for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param state
     */
    public void setState(String state) {
        this.state = state;
    }

    /** 
     * Get the 'Postal' element value. Description: The postal code for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				
     * 
     * @return value
     */
    public String getPostal() {
        return postal;
    }

    /** 
     * Set the 'Postal' element value. Description: The postal code for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				
     * 
     * @param postal
     */
    public void setPostal(String postal) {
        this.postal = postal;
    }

    /** 
     * Get the 'Country' element value. Description: The Country for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Description: The Country for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'CountryCode' element value. 
    					Description: The code that represents the country where the contact resides..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. 
    					Description: The code that represents the country where the contact resides..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'AreaCode' element value. 
    					Description: The three-digit code that identifies the telephone area for the
    					contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getAreaCode() {
        return areaCode;
    }

    /** 
     * Set the 'AreaCode' element value. 
    					Description: The three-digit code that identifies the telephone area for the
    					contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param areaCode
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /** 
     * Get the 'PhoneNumber' element value. Description: The contact's phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 12.
    				
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Description: The contact's phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 12.
    				
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'Display' element value. 
    					Description: Logical value indicating that this contact information is to be
    					displayed to the user.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getDisplay() {
        return display;
    }

    /** 
     * Set the 'Display' element value. 
    					Description: Logical value indicating that this contact information is to be
    					displayed to the user.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param display
     */
    public void setDisplay(String display) {
        this.display = display;
    }
}
