
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlinePerson">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:Person">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:decimal" name="Weight" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FFNum" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="PaxActive" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="RecordLocator" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="OriginalRecordNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ContactInfo" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="DropoffID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="PickupID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="LapChildID" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FareClassCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FareBasisCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="WebFareType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FareBasisSched" minOccurs="0"/>
 *         &lt;xs:element type="xs:decimal" name="FareAmount" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="ResSegStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="SegSubStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="SelecteeStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="CheckinStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="Cabin" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="TicketNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="HasTickets" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="UIDisplayValue" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="InterlinedSegment" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="InterlinedCarrierCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="ManualFare" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="InventoryOverbooked" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="TicketCouponNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="TicketControl" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="TicketControlOwner" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="TicketControlModifiedDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="MarketingCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="MarketingOptIn" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="EmergencyContactID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="DisclosedEmergencyContact" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="CappsStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="ToRecordNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="FromRecordNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="StoreFrontID" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="InsuranceConfNum" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="InsuranceTransID" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="RedressNum" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="KnownTravNum" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="PrimaryPassenger" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="NameChangeCount" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="CrsCode" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfSeatAssignment" nillable="true" name="SeatAssignments" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfCharge" nillable="true" name="Charges" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfBaggage" nillable="true" name="Bags" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlinePerson extends Person1
{
    private BigDecimal weight;
    private String FFNum;
    private Boolean paxActive;
    private Integer recordNumber;
    private String recordLocator;
    private Integer originalRecordNumber;
    private String contactInfo;
    private Integer dropoffID;
    private Integer pickupID;
    private Integer lapChildID;
    private String fareClassCode;
    private String fareBasisCode;
    private String webFareType;
    private String fareBasisSched;
    private BigDecimal fareAmount;
    private Integer resSegStatus;
    private Integer segSubStatus;
    private Integer selecteeStatus;
    private Boolean checkinStatus;
    private String cabin;
    private String ticketNumber;
    private Boolean hasTickets;
    private Integer UIDisplayValue;
    private Integer interlinedSegment;
    private String interlinedCarrierCode;
    private Integer manualFare;
    private Integer inventoryOverbooked;
    private String ticketCouponNumber;
    private Integer ticketControl;
    private String ticketControlOwner;
    private Date ticketControlModifiedDate;
    private String marketingCode;
    private Boolean marketingOptIn;
    private Integer emergencyContactID;
    private Integer disclosedEmergencyContact;
    private Integer cappsStatus;
    private Integer toRecordNumber;
    private Integer fromRecordNumber;
    private String storeFrontID;
    private String insuranceConfNum;
    private String insuranceTransID;
    private String redressNum;
    private String knownTravNum;
    private Boolean primaryPassenger;
    private Integer nameChangeCount;
    private String crsCode;
    private ArrayOfSeatAssignment seatAssignments;
    private ArrayOfCharge charges;
    private ArrayOfBaggage bags;

    /** 
     * Get the 'Weight' element value. Description: The weight of the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public BigDecimal getWeight() {
        return weight;
    }

    /** 
     * Set the 'Weight' element value. Description: The weight of the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param weight
     */
    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    /** 
     * Get the 'FFNum' element value. 
    							Description: The frequent flyer number for the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFFNum() {
        return FFNum;
    }

    /** 
     * Set the 'FFNum' element value. 
    							Description: The frequent flyer number for the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param FFNum
     */
    public void setFFNum(String FFNum) {
        this.FFNum = FFNum;
    }

    /** 
     * Get the 'PaxActive' element value. 
    							Description: Indicates if the passenger is active..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getPaxActive() {
        return paxActive;
    }

    /** 
     * Set the 'PaxActive' element value. 
    							Description: Indicates if the passenger is active..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param paxActive
     */
    public void setPaxActive(Boolean paxActive) {
        this.paxActive = paxActive;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    							Description: The unique account number for the passenger that is generated
    							from an external system..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    							Description: The unique account number for the passenger that is generated
    							from an external system..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'RecordLocator' element value. 
    							Description: The Record Locator from an excternal system that identifies
    							this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. 
    							Description: The Record Locator from an excternal system that identifies
    							this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'OriginalRecordNumber' element value. 
    							Description: The numeric order for this passenger segment within a
    							reservation.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getOriginalRecordNumber() {
        return originalRecordNumber;
    }

    /** 
     * Set the 'OriginalRecordNumber' element value. 
    							Description: The numeric order for this passenger segment within a
    							reservation.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param originalRecordNumber
     */
    public void setOriginalRecordNumber(Integer originalRecordNumber) {
        this.originalRecordNumber = originalRecordNumber;
    }

    /** 
     * Get the 'ContactInfo' element value. 
    							Description: The information an airline can use to contact the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getContactInfo() {
        return contactInfo;
    }

    /** 
     * Set the 'ContactInfo' element value. 
    							Description: The information an airline can use to contact the passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param contactInfo
     */
    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    /** 
     * Get the 'DropoffID' element value. 
    							Description: The Person Org ID of the individual that is authorized to drop
    							off an unaccompanied minor.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getDropoffID() {
        return dropoffID;
    }

    /** 
     * Set the 'DropoffID' element value. 
    							Description: The Person Org ID of the individual that is authorized to drop
    							off an unaccompanied minor.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param dropoffID
     */
    public void setDropoffID(Integer dropoffID) {
        this.dropoffID = dropoffID;
    }

    /** 
     * Get the 'PickupID' element value. 
    							Description: The Person Org ID of the individual that is authorized to pick
    							up an unaccompanied minor.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getPickupID() {
        return pickupID;
    }

    /** 
     * Set the 'PickupID' element value. 
    							Description: The Person Org ID of the individual that is authorized to pick
    							up an unaccompanied minor.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param pickupID
     */
    public void setPickupID(Integer pickupID) {
        this.pickupID = pickupID;
    }

    /** 
     * Get the 'LapChildID' element value. 
    							Description: The Person Org ID of the passenger who is going to be carrying
    							an Infant on his/her lap.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getLapChildID() {
        return lapChildID;
    }

    /** 
     * Set the 'LapChildID' element value. 
    							Description: The Person Org ID of the passenger who is going to be carrying
    							an Infant on his/her lap.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param lapChildID
     */
    public void setLapChildID(Integer lapChildID) {
        this.lapChildID = lapChildID;
    }

    /** 
     * Get the 'FareClassCode' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFareClassCode() {
        return fareClassCode;
    }

    /** 
     * Set the 'FareClassCode' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @param fareClassCode
     */
    public void setFareClassCode(String fareClassCode) {
        this.fareClassCode = fareClassCode;
    }

    /** 
     * Get the 'FareBasisCode' element value. 
    							Description: The code identifying the Fare Basis code whose rules govern the
    							booking of the passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. 
    							Description: The code identifying the Fare Basis code whose rules govern the
    							booking of the passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'WebFareType' element value. 
    							Description: The code identifying the web fare type (if booking was
    							performed via an online channel).
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getWebFareType() {
        return webFareType;
    }

    /** 
     * Set the 'WebFareType' element value. 
    							Description: The code identifying the web fare type (if booking was
    							performed via an online channel).
    						Constraints: Optional (Not Required).
    						
     * 
     * @param webFareType
     */
    public void setWebFareType(String webFareType) {
        this.webFareType = webFareType;
    }

    /** 
     * Get the 'FareBasisSched' element value. 
    							Description: The ID of the Fare Basis Schedule record that identifies the
    							fare restrictions for this passenger segment..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFareBasisSched() {
        return fareBasisSched;
    }

    /** 
     * Set the 'FareBasisSched' element value. 
    							Description: The ID of the Fare Basis Schedule record that identifies the
    							fare restrictions for this passenger segment..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param fareBasisSched
     */
    public void setFareBasisSched(String fareBasisSched) {
        this.fareBasisSched = fareBasisSched;
    }

    /** 
     * Get the 'FareAmount' element value. 
    							Description: The amount of the fare for the passenger..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public BigDecimal getFareAmount() {
        return fareAmount;
    }

    /** 
     * Set the 'FareAmount' element value. 
    							Description: The amount of the fare for the passenger..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param fareAmount
     */
    public void setFareAmount(BigDecimal fareAmount) {
        this.fareAmount = fareAmount;
    }

    /** 
     * Get the 'ResSegStatus' element value. 
    							Description: The reservation segment status code for the passenger..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getResSegStatus() {
        return resSegStatus;
    }

    /** 
     * Set the 'ResSegStatus' element value. 
    							Description: The reservation segment status code for the passenger..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param resSegStatus
     */
    public void setResSegStatus(Integer resSegStatus) {
        this.resSegStatus = resSegStatus;
    }

    /** 
     * Get the 'SegSubStatus' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getSegSubStatus() {
        return segSubStatus;
    }

    /** 
     * Set the 'SegSubStatus' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @param segSubStatus
     */
    public void setSegSubStatus(Integer segSubStatus) {
        this.segSubStatus = segSubStatus;
    }

    /** 
     * Get the 'SelecteeStatus' element value. 
    							Description: A range of values that describes the passengers identification
    							under various governmental security regimes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getSelecteeStatus() {
        return selecteeStatus;
    }

    /** 
     * Set the 'SelecteeStatus' element value. 
    							Description: A range of values that describes the passengers identification
    							under various governmental security regimes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param selecteeStatus
     */
    public void setSelecteeStatus(Integer selecteeStatus) {
        this.selecteeStatus = selecteeStatus;
    }

    /** 
     * Get the 'CheckinStatus' element value. 
    							Description: Indicates whether the passenger has been checked in..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getCheckinStatus() {
        return checkinStatus;
    }

    /** 
     * Set the 'CheckinStatus' element value. 
    							Description: Indicates whether the passenger has been checked in..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param checkinStatus
     */
    public void setCheckinStatus(Boolean checkinStatus) {
        this.checkinStatus = checkinStatus;
    }

    /** 
     * Get the 'Cabin' element value. 
    							Description: The cabin the passenger is assigned to..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value. 
    							Description: The cabin the passenger is assigned to..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param cabin
     */
    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'TicketNumber' element value. Description: The passenger's ticket number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. Description: The passenger's ticket number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    /** 
     * Get the 'HasTickets' element value. 
    							Description: Indicates whether or not this passenger segment has been issued
    							an IATA standard electronic ticket.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getHasTickets() {
        return hasTickets;
    }

    /** 
     * Set the 'HasTickets' element value. 
    							Description: Indicates whether or not this passenger segment has been issued
    							an IATA standard electronic ticket.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param hasTickets
     */
    public void setHasTickets(Boolean hasTickets) {
        this.hasTickets = hasTickets;
    }

    /** 
     * Get the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getUIDisplayValue() {
        return UIDisplayValue;
    }

    /** 
     * Set the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @param UIDisplayValue
     */
    public void setUIDisplayValue(Integer UIDisplayValue) {
        this.UIDisplayValue = UIDisplayValue;
    }

    /** 
     * Get the 'InterlinedSegment' element value. 
    							Description: This field indicates whether or not this segment is being
    							serviced by an interline carrier. .
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getInterlinedSegment() {
        return interlinedSegment;
    }

    /** 
     * Set the 'InterlinedSegment' element value. 
    							Description: This field indicates whether or not this segment is being
    							serviced by an interline carrier. .
    						Constraints: Optional (Not Required).
    						
     * 
     * @param interlinedSegment
     */
    public void setInterlinedSegment(Integer interlinedSegment) {
        this.interlinedSegment = interlinedSegment;
    }

    /** 
     * Get the 'InterlinedCarrierCode' element value. 
    							Description: The two letter IATA code of the interlined carrier for this
    							segment..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getInterlinedCarrierCode() {
        return interlinedCarrierCode;
    }

    /** 
     * Set the 'InterlinedCarrierCode' element value. 
    							Description: The two letter IATA code of the interlined carrier for this
    							segment..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param interlinedCarrierCode
     */
    public void setInterlinedCarrierCode(String interlinedCarrierCode) {
        this.interlinedCarrierCode = interlinedCarrierCode;
    }

    /** 
     * Get the 'ManualFare' element value. 
    							Description: This field indicates whether or not the fare for the passenger
    							segment has been manually overridden..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getManualFare() {
        return manualFare;
    }

    /** 
     * Set the 'ManualFare' element value. 
    							Description: This field indicates whether or not the fare for the passenger
    							segment has been manually overridden..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param manualFare
     */
    public void setManualFare(Integer manualFare) {
        this.manualFare = manualFare;
    }

    /** 
     * Get the 'InventoryOverbooked' element value. 
    							Description: This field indicates whether or not this booking caused the
    							fare class to be overbooked..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getInventoryOverbooked() {
        return inventoryOverbooked;
    }

    /** 
     * Set the 'InventoryOverbooked' element value. 
    							Description: This field indicates whether or not this booking caused the
    							fare class to be overbooked..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param inventoryOverbooked
     */
    public void setInventoryOverbooked(Integer inventoryOverbooked) {
        this.inventoryOverbooked = inventoryOverbooked;
    }

    /** 
     * Get the 'TicketCouponNumber' element value. 
    							Description: The passenger's assigned ticket coupon number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getTicketCouponNumber() {
        return ticketCouponNumber;
    }

    /** 
     * Set the 'TicketCouponNumber' element value. 
    							Description: The passenger's assigned ticket coupon number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param ticketCouponNumber
     */
    public void setTicketCouponNumber(String ticketCouponNumber) {
        this.ticketCouponNumber = ticketCouponNumber;
    }

    /** 
     * Get the 'TicketControl' element value. Description: The ticket control number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getTicketControl() {
        return ticketControl;
    }

    /** 
     * Set the 'TicketControl' element value. Description: The ticket control number..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param ticketControl
     */
    public void setTicketControl(Integer ticketControl) {
        this.ticketControl = ticketControl;
    }

    /** 
     * Get the 'TicketControlOwner' element value. Description: The ticket control number owner..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getTicketControlOwner() {
        return ticketControlOwner;
    }

    /** 
     * Set the 'TicketControlOwner' element value. Description: The ticket control number owner..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param ticketControlOwner
     */
    public void setTicketControlOwner(String ticketControlOwner) {
        this.ticketControlOwner = ticketControlOwner;
    }

    /** 
     * Get the 'TicketControlModifiedDate' element value. 
    							Description: The date ticket control was last modified..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getTicketControlModifiedDate() {
        return ticketControlModifiedDate;
    }

    /** 
     * Set the 'TicketControlModifiedDate' element value. 
    							Description: The date ticket control was last modified..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param ticketControlModifiedDate
     */
    public void setTicketControlModifiedDate(Date ticketControlModifiedDate) {
        this.ticketControlModifiedDate = ticketControlModifiedDate;
    }

    /** 
     * Get the 'MarketingCode' element value. 
    							Description: This field contains the special marketing code that was used to
    							book this passenger segment. .
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getMarketingCode() {
        return marketingCode;
    }

    /** 
     * Set the 'MarketingCode' element value. 
    							Description: This field contains the special marketing code that was used to
    							book this passenger segment. .
    						Constraints: Optional (Not Required).
    						
     * 
     * @param marketingCode
     */
    public void setMarketingCode(String marketingCode) {
        this.marketingCode = marketingCode;
    }

    /** 
     * Get the 'MarketingOptIn' element value. 
    							Description: This field indicates whether or not the passenger on this
    							segment has chosen to Opt in or out of extended marketing
    							information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getMarketingOptIn() {
        return marketingOptIn;
    }

    /** 
     * Set the 'MarketingOptIn' element value. 
    							Description: This field indicates whether or not the passenger on this
    							segment has chosen to Opt in or out of extended marketing
    							information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param marketingOptIn
     */
    public void setMarketingOptIn(Boolean marketingOptIn) {
        this.marketingOptIn = marketingOptIn;
    }

    /** 
     * Get the 'EmergencyContactID' element value. 
    							Description: The Person Org ID of the emergency contact.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getEmergencyContactID() {
        return emergencyContactID;
    }

    /** 
     * Set the 'EmergencyContactID' element value. 
    							Description: The Person Org ID of the emergency contact.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param emergencyContactID
     */
    public void setEmergencyContactID(Integer emergencyContactID) {
        this.emergencyContactID = emergencyContactID;
    }

    /** 
     * Get the 'DisclosedEmergencyContact' element value. 
    							Description: To indicate whether or not this person has chosen to disclose
    							their emergency contact information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getDisclosedEmergencyContact() {
        return disclosedEmergencyContact;
    }

    /** 
     * Set the 'DisclosedEmergencyContact' element value. 
    							Description: To indicate whether or not this person has chosen to disclose
    							their emergency contact information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param disclosedEmergencyContact
     */
    public void setDisclosedEmergencyContact(Integer disclosedEmergencyContact) {
        this.disclosedEmergencyContact = disclosedEmergencyContact;
    }

    /** 
     * Get the 'CappsStatus' element value. 
    							Description: The Computer Assisted Passenger Prescreening System (CAPPS)
    							status of the passenger on this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getCappsStatus() {
        return cappsStatus;
    }

    /** 
     * Set the 'CappsStatus' element value. 
    							Description: The Computer Assisted Passenger Prescreening System (CAPPS)
    							status of the passenger on this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param cappsStatus
     */
    public void setCappsStatus(Integer cappsStatus) {
        this.cappsStatus = cappsStatus;
    }

    /** 
     * Get the 'ToRecordNumber' element value. 
    							Description: The Record number that this passenger segment was modified TO
    							in the event of a change to the booking. If this field is
    							populated the current passenger segment should be 'Cancelled'.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getToRecordNumber() {
        return toRecordNumber;
    }

    /** 
     * Set the 'ToRecordNumber' element value. 
    							Description: The Record number that this passenger segment was modified TO
    							in the event of a change to the booking. If this field is
    							populated the current passenger segment should be 'Cancelled'.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param toRecordNumber
     */
    public void setToRecordNumber(Integer toRecordNumber) {
        this.toRecordNumber = toRecordNumber;
    }

    /** 
     * Get the 'FromRecordNumber' element value. 
    							Description: The Record number that this passenger segment was modified FROM
    							in the event of a change to the booking.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getFromRecordNumber() {
        return fromRecordNumber;
    }

    /** 
     * Set the 'FromRecordNumber' element value. 
    							Description: The Record number that this passenger segment was modified FROM
    							in the event of a change to the booking.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param fromRecordNumber
     */
    public void setFromRecordNumber(Integer fromRecordNumber) {
        this.fromRecordNumber = fromRecordNumber;
    }

    /** 
     * Get the 'StoreFrontID' element value. 
    							Description: In the event that an airline has multiple storefronts, this
    							field indicates the StoreFrontID that this booking was made
    							under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getStoreFrontID() {
        return storeFrontID;
    }

    /** 
     * Set the 'StoreFrontID' element value. 
    							Description: In the event that an airline has multiple storefronts, this
    							field indicates the StoreFrontID that this booking was made
    							under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param storeFrontID
     */
    public void setStoreFrontID(String storeFrontID) {
        this.storeFrontID = storeFrontID;
    }

    /** 
     * Get the 'InsuranceConfNum' element value. 
    							Description: The confirmation number for the insurance the passenger
    							purchased..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getInsuranceConfNum() {
        return insuranceConfNum;
    }

    /** 
     * Set the 'InsuranceConfNum' element value. 
    							Description: The confirmation number for the insurance the passenger
    							purchased..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param insuranceConfNum
     */
    public void setInsuranceConfNum(String insuranceConfNum) {
        this.insuranceConfNum = insuranceConfNum;
    }

    /** 
     * Get the 'InsuranceTransID' element value. 
    							Description: The unique identifier for the insurance purchase transaction..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getInsuranceTransID() {
        return insuranceTransID;
    }

    /** 
     * Set the 'InsuranceTransID' element value. 
    							Description: The unique identifier for the insurance purchase transaction..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param insuranceTransID
     */
    public void setInsuranceTransID(String insuranceTransID) {
        this.insuranceTransID = insuranceTransID;
    }

    /** 
     * Get the 'RedressNum' element value. 
    							Description: The 'Redress Number' for this passenger segment for US TSA
    							purposes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getRedressNum() {
        return redressNum;
    }

    /** 
     * Set the 'RedressNum' element value. 
    							Description: The 'Redress Number' for this passenger segment for US TSA
    							purposes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param redressNum
     */
    public void setRedressNum(String redressNum) {
        this.redressNum = redressNum;
    }

    /** 
     * Get the 'KnownTravNum' element value. 
    							Description: The 'Known Traveller Number' for this passenger segment for
    							compliance with governmental security regimes..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getKnownTravNum() {
        return knownTravNum;
    }

    /** 
     * Set the 'KnownTravNum' element value. 
    							Description: The 'Known Traveller Number' for this passenger segment for
    							compliance with governmental security regimes..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param knownTravNum
     */
    public void setKnownTravNum(String knownTravNum) {
        this.knownTravNum = knownTravNum;
    }

    /** 
     * Get the 'PrimaryPassenger' element value. 
    							Description: This is an indicator as to whether the passenger was identified
    							as the primary traveler.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getPrimaryPassenger() {
        return primaryPassenger;
    }

    /** 
     * Set the 'PrimaryPassenger' element value. 
    							Description: This is an indicator as to whether the passenger was identified
    							as the primary traveler.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param primaryPassenger
     */
    public void setPrimaryPassenger(Boolean primaryPassenger) {
        this.primaryPassenger = primaryPassenger;
    }

    /** 
     * Get the 'NameChangeCount' element value. 
    							Description: This value represents the number of times a Name Change has
    							occurred for the given passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getNameChangeCount() {
        return nameChangeCount;
    }

    /** 
     * Set the 'NameChangeCount' element value. 
    							Description: This value represents the number of times a Name Change has
    							occurred for the given passenger.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param nameChangeCount
     */
    public void setNameChangeCount(Integer nameChangeCount) {
        this.nameChangeCount = nameChangeCount;
    }

    /** 
     * Get the 'CrsCode' element value. 
    							Description: The CRS Code from an excternal system that identifies this
    							passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getCrsCode() {
        return crsCode;
    }

    /** 
     * Set the 'CrsCode' element value. 
    							Description: The CRS Code from an excternal system that identifies this
    							passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param crsCode
     */
    public void setCrsCode(String crsCode) {
        this.crsCode = crsCode;
    }

    /** 
     * Get the 'SeatAssignments' element value. 
    							Description: The seats that the passenger is assigned..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public ArrayOfSeatAssignment getSeatAssignments() {
        return seatAssignments;
    }

    /** 
     * Set the 'SeatAssignments' element value. 
    							Description: The seats that the passenger is assigned..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param seatAssignments
     */
    public void setSeatAssignments(ArrayOfSeatAssignment seatAssignments) {
        this.seatAssignments = seatAssignments;
    }

    /** 
     * Get the 'Charges' element value. 
    							Description: The collection of the charges for this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public ArrayOfCharge getCharges() {
        return charges;
    }

    /** 
     * Set the 'Charges' element value. 
    							Description: The collection of the charges for this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param charges
     */
    public void setCharges(ArrayOfCharge charges) {
        this.charges = charges;
    }

    /** 
     * Get the 'Bags' element value. 
    							Description: The collection of bags for this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public ArrayOfBaggage getBags() {
        return bags;
    }

    /** 
     * Set the 'Bags' element value. 
    							Description: The collection of bags for this passenger segment.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param bags
     */
    public void setBags(ArrayOfBaggage bags) {
        this.bags = bags;
    }
}
