
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="BagId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BagNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="BagWeight" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BagCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BagChecked" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="Pet" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BagActive" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BagTagPrinted" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Baggage
{
    private Integer bagId;
    private String key;
    private Integer bagNumber;
    private BigDecimal bagWeight;
    private String bagCode;
    private Integer bagChecked;
    private Integer pet;
    private Integer bagActive;
    private Integer bagTagPrinted;
    private Integer recordNumber;

    /** 
     * Get the 'BagId' element value. 
    					Description: The ID number of the baggage checked..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBagId() {
        return bagId;
    }

    /** 
     * Set the 'BagId' element value. 
    					Description: The ID number of the baggage checked..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagId
     */
    public void setBagId(Integer bagId) {
        this.bagId = bagId;
    }

    /** 
     * Get the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'BagNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBagNumber() {
        return bagNumber;
    }

    /** 
     * Set the 'BagNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param bagNumber
     */
    public void setBagNumber(Integer bagNumber) {
        this.bagNumber = bagNumber;
    }

    /** 
     * Get the 'BagWeight' element value. Description: The weight of the baggage..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getBagWeight() {
        return bagWeight;
    }

    /** 
     * Set the 'BagWeight' element value. Description: The weight of the baggage..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagWeight
     */
    public void setBagWeight(BigDecimal bagWeight) {
        this.bagWeight = bagWeight;
    }

    /** 
     * Get the 'BagCode' element value. 
    					Description: The Baggage Identifier Tag for an individual passenger bag.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getBagCode() {
        return bagCode;
    }

    /** 
     * Set the 'BagCode' element value. 
    					Description: The Baggage Identifier Tag for an individual passenger bag.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagCode
     */
    public void setBagCode(String bagCode) {
        this.bagCode = bagCode;
    }

    /** 
     * Get the 'BagChecked' element value. 
    					Description: Indicates whether the baggage is checked..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBagChecked() {
        return bagChecked;
    }

    /** 
     * Set the 'BagChecked' element value. 
    					Description: Indicates whether the baggage is checked..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagChecked
     */
    public void setBagChecked(Integer bagChecked) {
        this.bagChecked = bagChecked;
    }

    /** 
     * Get the 'Pet' element value. 
    					Description: Indicates whether the baggage contains a pet..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPet() {
        return pet;
    }

    /** 
     * Set the 'Pet' element value. 
    					Description: Indicates whether the baggage contains a pet..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param pet
     */
    public void setPet(Integer pet) {
        this.pet = pet;
    }

    /** 
     * Get the 'BagActive' element value. 
    					Description: Indicates that the baggage record is active..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBagActive() {
        return bagActive;
    }

    /** 
     * Set the 'BagActive' element value. 
    					Description: Indicates that the baggage record is active..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagActive
     */
    public void setBagActive(Integer bagActive) {
        this.bagActive = bagActive;
    }

    /** 
     * Get the 'BagTagPrinted' element value. 
    					Description: Indicates that the baggage tag has been printed..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBagTagPrinted() {
        return bagTagPrinted;
    }

    /** 
     * Set the 'BagTagPrinted' element value. 
    					Description: Indicates that the baggage tag has been printed..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bagTagPrinted
     */
    public void setBagTagPrinted(Integer bagTagPrinted) {
        this.bagTagPrinted = bagTagPrinted;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    					Description: Internal record number indicating the sequential number for the
    					piece of baggage on this record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    					Description: Internal record number indicating the sequential number for the
    					piece of baggage on this record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }
}
