
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Charge">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationChargeID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="OriginalChargeID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CodeType" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RefundPersonOrgID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RefundType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginalCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="VoucherNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BillDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RPM" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TaxID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ChargeComment" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ChargeStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IsRefundable" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="ExchangeRate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExchangeRateDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="OriginalAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="StatusReasonID" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="IsSSR" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PaymentNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="IncludeInPenalty" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TaxChargeID" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="TaxIncludedInFare" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ResChannelId" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="CommissionDueRptCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="CommissionDueResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NonRefundableResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NonRefundableRptCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RefundableResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RefundableRptCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="PenaltyResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="PenaltyRptCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Commissionable" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NonDiscountedResAmt" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NonDiscountedRptAmt" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Bundled" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="TaxIsRefundable" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="TaxIsCommissionable" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ServiceIsRefundable" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ServiceIsCommissionable" minOccurs="0"/>
 *     &lt;xs:element type="ns:ArrayOfReservationPaymentMap" nillable="true" name="ReservationPaymentMaps" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PenaltyChargeID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PenaltyTypeID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Charge
{
    private String key;
    private Integer reservationChargeID;
    private Integer originalChargeID;
    private String codeType;
    private Integer refundPersonOrgID;
    private String refundType;
    private String currencyCode;
    private String originalCurrency;
    private Integer recordNumber;
    private Integer voucherNumber;
    private Date billDate;
    private Integer RPM;
    private Integer taxID;
    private String chargeComment;
    private BigDecimal amount;
    private Integer chargeStatus;
    private Integer isRefundable;
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;
    private BigDecimal originalAmount;
    private String description;
    private Integer statusReasonID;
    private Boolean isSSR;
    private Integer paymentNumber;
    private Integer logicalFlightID;
    private Boolean includeInPenalty;
    private Integer taxChargeID;
    private Boolean taxIncludedInFare;
    private BigDecimal commission;
    private Integer resChannelId;
    private BigDecimal commissionDueRptCurrency;
    private BigDecimal commissionDueResCurrency;
    private BigDecimal nonRefundableResCurrency;
    private BigDecimal nonRefundableRptCurrency;
    private BigDecimal refundableResCurrency;
    private BigDecimal refundableRptCurrency;
    private BigDecimal penaltyResCurrency;
    private BigDecimal penaltyRptCurrency;
    private Boolean commissionable;
    private BigDecimal nonDiscountedResAmt;
    private BigDecimal nonDiscountedRptAmt;
    private Boolean bundled;
    private Boolean taxIsRefundable;
    private Boolean taxIsCommissionable;
    private Boolean serviceIsRefundable;
    private Boolean serviceIsCommissionable;
    private ArrayOfReservationPaymentMap reservationPaymentMaps;
    private Integer penaltyChargeID;
    private Integer penaltyTypeID;

    /** 
     * Get the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'ReservationChargeID' element value. 
    					Description: A sequence that uniquely identifies this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationChargeID() {
        return reservationChargeID;
    }

    /** 
     * Set the 'ReservationChargeID' element value. 
    					Description: A sequence that uniquely identifies this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationChargeID
     */
    public void setReservationChargeID(Integer reservationChargeID) {
        this.reservationChargeID = reservationChargeID;
    }

    /** 
     * Get the 'OriginalChargeID' element value. 
    					Description: In the event that this charge was as the result or a
    					modification, the value in this field represents the original
    					change that this charge is offsetting.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getOriginalChargeID() {
        return originalChargeID;
    }

    /** 
     * Set the 'OriginalChargeID' element value. 
    					Description: In the event that this charge was as the result or a
    					modification, the value in this field represents the original
    					change that this charge is offsetting.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalChargeID
     */
    public void setOriginalChargeID(Integer originalChargeID) {
        this.originalChargeID = originalChargeID;
    }

    /** 
     * Get the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCodeType() {
        return codeType;
    }

    /** 
     * Set the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param codeType
     */
    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    /** 
     * Get the 'RefundPersonOrgID' element value. 
    					Description: In this event that this charge is negative and it being refunded,
    					this is the value of the personOrgID that the refund is applied
    					to..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRefundPersonOrgID() {
        return refundPersonOrgID;
    }

    /** 
     * Set the 'RefundPersonOrgID' element value. 
    					Description: In this event that this charge is negative and it being refunded,
    					this is the value of the personOrgID that the refund is applied
    					to..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param refundPersonOrgID
     */
    public void setRefundPersonOrgID(Integer refundPersonOrgID) {
        this.refundPersonOrgID = refundPersonOrgID;
    }

    /** 
     * Get the 'RefundType' element value. Description: The type of refund applied..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getRefundType() {
        return refundType;
    }

    /** 
     * Set the 'RefundType' element value. Description: The type of refund applied..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param refundType
     */
    public void setRefundType(String refundType) {
        this.refundType = refundType;
    }

    /** 
     * Get the 'CurrencyCode' element value. 
    					Description: The currency code for the currency that the charge is being
    					applied in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. 
    					Description: The currency code for the currency that the charge is being
    					applied in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'OriginalCurrency' element value. 
    					Description: The type of currency original used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginalCurrency() {
        return originalCurrency;
    }

    /** 
     * Set the 'OriginalCurrency' element value. 
    					Description: The type of currency original used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalCurrency
     */
    public void setOriginalCurrency(String originalCurrency) {
        this.originalCurrency = originalCurrency;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    					Description: This is the Record Number for the Passenger Segment for which
    					this charge is applicable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    					Description: This is the Record Number for the Passenger Segment for which
    					this charge is applicable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'VoucherNumber' element value. 
    					Description: In the event that this charge is being refunded to voucher, this
    					is the voucher that was generated.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getVoucherNumber() {
        return voucherNumber;
    }

    /** 
     * Set the 'VoucherNumber' element value. 
    					Description: In the event that this charge is being refunded to voucher, this
    					is the voucher that was generated.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherNumber
     */
    public void setVoucherNumber(Integer voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    /** 
     * Get the 'BillDate' element value. Description: The accounting date for this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getBillDate() {
        return billDate;
    }

    /** 
     * Set the 'BillDate' element value. Description: The accounting date for this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param billDate
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /** 
     * Get the 'RPM' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRPM() {
        return RPM;
    }

    /** 
     * Set the 'RPM' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param RPM
     */
    public void setRPM(Integer RPM) {
        this.RPM = RPM;
    }

    /** 
     * Get the 'TaxID' element value. 
    					Description: The tax ID of the charge if it is a tax..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTaxID() {
        return taxID;
    }

    /** 
     * Set the 'TaxID' element value. 
    					Description: The tax ID of the charge if it is a tax..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param taxID
     */
    public void setTaxID(Integer taxID) {
        this.taxID = taxID;
    }

    /** 
     * Get the 'ChargeComment' element value. Description: A comment for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getChargeComment() {
        return chargeComment;
    }

    /** 
     * Set the 'ChargeComment' element value. Description: A comment for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param chargeComment
     */
    public void setChargeComment(String chargeComment) {
        this.chargeComment = chargeComment;
    }

    /** 
     * Get the 'Amount' element value. 
    					Description: The amount for this charge in the currency as specified by the
    					Currency Code.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. 
    					Description: The amount for this charge in the currency as specified by the
    					Currency Code.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ChargeStatus' element value. 
    					Description: Indicates the current status of the charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getChargeStatus() {
        return chargeStatus;
    }

    /** 
     * Set the 'ChargeStatus' element value. 
    					Description: Indicates the current status of the charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param chargeStatus
     */
    public void setChargeStatus(Integer chargeStatus) {
        this.chargeStatus = chargeStatus;
    }

    /** 
     * Get the 'IsRefundable' element value. 
    					Description: Indicates whether the charge IS refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIsRefundable() {
        return isRefundable;
    }

    /** 
     * Set the 'IsRefundable' element value. 
    					Description: Indicates whether the charge IS refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param isRefundable
     */
    public void setIsRefundable(Integer isRefundable) {
        this.isRefundable = isRefundable;
    }

    /** 
     * Get the 'ExchangeRate' element value. 
    					Description: The exchange rate used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. 
    					Description: The exchange rate used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'ExchangeRateDate' element value. 
    					Description: The date of the exchange rate used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getExchangeRateDate() {
        return exchangeRateDate;
    }

    /** 
     * Set the 'ExchangeRateDate' element value. 
    					Description: The date of the exchange rate used for the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param exchangeRateDate
     */
    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }

    /** 
     * Get the 'OriginalAmount' element value. Description: The original amount of the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. Description: The original amount of the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'Description' element value. Description: The description of the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description: The description of the charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'StatusReasonID' element value. 
    					Description: The reason code associated with the status..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getStatusReasonID() {
        return statusReasonID;
    }

    /** 
     * Set the 'StatusReasonID' element value. 
    					Description: The reason code associated with the status..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param statusReasonID
     */
    public void setStatusReasonID(Integer statusReasonID) {
        this.statusReasonID = statusReasonID;
    }

    /** 
     * Get the 'IsSSR' element value. 
    					Description: Indicates whether the charge is for an SSR..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getIsSSR() {
        return isSSR;
    }

    /** 
     * Set the 'IsSSR' element value. 
    					Description: Indicates whether the charge is for an SSR..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param isSSR
     */
    public void setIsSSR(Boolean isSSR) {
        this.isSSR = isSSR;
    }

    /** 
     * Get the 'PaymentNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPaymentNumber() {
        return paymentNumber;
    }

    /** 
     * Set the 'PaymentNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param paymentNumber
     */
    public void setPaymentNumber(Integer paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: The ID for the logical flight associated with this charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: The ID for the logical flight associated with this charge..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(Integer logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'IncludeInPenalty' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getIncludeInPenalty() {
        return includeInPenalty;
    }

    /** 
     * Set the 'IncludeInPenalty' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param includeInPenalty
     */
    public void setIncludeInPenalty(Boolean includeInPenalty) {
        this.includeInPenalty = includeInPenalty;
    }

    /** 
     * Get the 'TaxChargeID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTaxChargeID() {
        return taxChargeID;
    }

    /** 
     * Set the 'TaxChargeID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param taxChargeID
     */
    public void setTaxChargeID(Integer taxChargeID) {
        this.taxChargeID = taxChargeID;
    }

    /** 
     * Get the 'TaxIncludedInFare' element value. 
    					Description: Indicates whether the tax is included with the fare..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getTaxIncludedInFare() {
        return taxIncludedInFare;
    }

    /** 
     * Set the 'TaxIncludedInFare' element value. 
    					Description: Indicates whether the tax is included with the fare..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param taxIncludedInFare
     */
    public void setTaxIncludedInFare(Boolean taxIncludedInFare) {
        this.taxIncludedInFare = taxIncludedInFare;
    }

    /** 
     * Get the 'Commission' element value. 
    					Description: The commission amount associated with this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. 
    					Description: The commission amount associated with this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commission
     */
    public void setCommission(BigDecimal commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'ResChannelId' element value. 
    					Description: An enumeration specifying the reservation channel that generated
    					this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getResChannelId() {
        return resChannelId;
    }

    /** 
     * Set the 'ResChannelId' element value. 
    					Description: An enumeration specifying the reservation channel that generated
    					this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param resChannelId
     */
    public void setResChannelId(Integer resChannelId) {
        this.resChannelId = resChannelId;
    }

    /** 
     * Get the 'CommissionDueRptCurrency' element value. 
    					Description: The commission amount due for this charge expressed in the
    					system's reporting currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCommissionDueRptCurrency() {
        return commissionDueRptCurrency;
    }

    /** 
     * Set the 'CommissionDueRptCurrency' element value. 
    					Description: The commission amount due for this charge expressed in the
    					system's reporting currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionDueRptCurrency
     */
    public void setCommissionDueRptCurrency(BigDecimal commissionDueRptCurrency) {
        this.commissionDueRptCurrency = commissionDueRptCurrency;
    }

    /** 
     * Get the 'CommissionDueResCurrency' element value. 
    					Description: The commission amount due for this charge expressed in the
    					reservation's reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCommissionDueResCurrency() {
        return commissionDueResCurrency;
    }

    /** 
     * Set the 'CommissionDueResCurrency' element value. 
    					Description: The commission amount due for this charge expressed in the
    					reservation's reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionDueResCurrency
     */
    public void setCommissionDueResCurrency(BigDecimal commissionDueResCurrency) {
        this.commissionDueResCurrency = commissionDueResCurrency;
    }

    /** 
     * Get the 'NonRefundableResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is not refundable in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getNonRefundableResCurrency() {
        return nonRefundableResCurrency;
    }

    /** 
     * Set the 'NonRefundableResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is not refundable in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nonRefundableResCurrency
     */
    public void setNonRefundableResCurrency(BigDecimal nonRefundableResCurrency) {
        this.nonRefundableResCurrency = nonRefundableResCurrency;
    }

    /** 
     * Get the 'NonRefundableRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is not refundable in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getNonRefundableRptCurrency() {
        return nonRefundableRptCurrency;
    }

    /** 
     * Set the 'NonRefundableRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is not refundable in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nonRefundableRptCurrency
     */
    public void setNonRefundableRptCurrency(BigDecimal nonRefundableRptCurrency) {
        this.nonRefundableRptCurrency = nonRefundableRptCurrency;
    }

    /** 
     * Get the 'RefundableResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is refundable in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRefundableResCurrency() {
        return refundableResCurrency;
    }

    /** 
     * Set the 'RefundableResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is refundable in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param refundableResCurrency
     */
    public void setRefundableResCurrency(BigDecimal refundableResCurrency) {
        this.refundableResCurrency = refundableResCurrency;
    }

    /** 
     * Get the 'RefundableRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is refundable in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRefundableRptCurrency() {
        return refundableRptCurrency;
    }

    /** 
     * Set the 'RefundableRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is refundable in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param refundableRptCurrency
     */
    public void setRefundableRptCurrency(BigDecimal refundableRptCurrency) {
        this.refundableRptCurrency = refundableRptCurrency;
    }

    /** 
     * Get the 'PenaltyResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is a penalty in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getPenaltyResCurrency() {
        return penaltyResCurrency;
    }

    /** 
     * Set the 'PenaltyResCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is a penalty in the
    					Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param penaltyResCurrency
     */
    public void setPenaltyResCurrency(BigDecimal penaltyResCurrency) {
        this.penaltyResCurrency = penaltyResCurrency;
    }

    /** 
     * Get the 'PenaltyRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is a penalty in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getPenaltyRptCurrency() {
        return penaltyRptCurrency;
    }

    /** 
     * Set the 'PenaltyRptCurrency' element value. 
    					Description: If this charge is a reversal of an original charge, this amount
    					represents the amount of the charge that is a penalty in the
    					Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param penaltyRptCurrency
     */
    public void setPenaltyRptCurrency(BigDecimal penaltyRptCurrency) {
        this.penaltyRptCurrency = penaltyRptCurrency;
    }

    /** 
     * Get the 'Commissionable' element value. 
    					Description: Indicates whether the charge is able to associate commissions
    					with a booking..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getCommissionable() {
        return commissionable;
    }

    /** 
     * Set the 'Commissionable' element value. 
    					Description: Indicates whether the charge is able to associate commissions
    					with a booking..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionable
     */
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    /** 
     * Get the 'NonDiscountedResAmt' element value. 
    					Description: If there was a discount applied to this passenger segment, this
    					amount indicates the amount of the charge that was not discounted
    					in the Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getNonDiscountedResAmt() {
        return nonDiscountedResAmt;
    }

    /** 
     * Set the 'NonDiscountedResAmt' element value. 
    					Description: If there was a discount applied to this passenger segment, this
    					amount indicates the amount of the charge that was not discounted
    					in the Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nonDiscountedResAmt
     */
    public void setNonDiscountedResAmt(BigDecimal nonDiscountedResAmt) {
        this.nonDiscountedResAmt = nonDiscountedResAmt;
    }

    /** 
     * Get the 'NonDiscountedRptAmt' element value. 
    					Description: If there was a discount applied to this passenger segment, this
    					amount indicates the amount of the charge that was not discounted
    					in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getNonDiscountedRptAmt() {
        return nonDiscountedRptAmt;
    }

    /** 
     * Set the 'NonDiscountedRptAmt' element value. 
    					Description: If there was a discount applied to this passenger segment, this
    					amount indicates the amount of the charge that was not discounted
    					in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nonDiscountedRptAmt
     */
    public void setNonDiscountedRptAmt(BigDecimal nonDiscountedRptAmt) {
        this.nonDiscountedRptAmt = nonDiscountedRptAmt;
    }

    /** 
     * Get the 'Bundled' element value. 
    					Description: Indicates whether the tax is marked as bundled..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getBundled() {
        return bundled;
    }

    /** 
     * Set the 'Bundled' element value. 
    					Description: Indicates whether the tax is marked as bundled..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bundled
     */
    public void setBundled(Boolean bundled) {
        this.bundled = bundled;
    }

    /** 
     * Get the 'TaxIsRefundable' element value. 
    					Description: Indicates whether the tax is marked as refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getTaxIsRefundable() {
        return taxIsRefundable;
    }

    /** 
     * Set the 'TaxIsRefundable' element value. 
    					Description: Indicates whether the tax is marked as refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param taxIsRefundable
     */
    public void setTaxIsRefundable(Boolean taxIsRefundable) {
        this.taxIsRefundable = taxIsRefundable;
    }

    /** 
     * Get the 'TaxIsCommissionable' element value. 
    					Description: Indicates whether the tax is marked as commissionable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getTaxIsCommissionable() {
        return taxIsCommissionable;
    }

    /** 
     * Set the 'TaxIsCommissionable' element value. 
    					Description: Indicates whether the tax is marked as commissionable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param taxIsCommissionable
     */
    public void setTaxIsCommissionable(Boolean taxIsCommissionable) {
        this.taxIsCommissionable = taxIsCommissionable;
    }

    /** 
     * Get the 'ServiceIsRefundable' element value. 
    					Description: Indicates whether the service is marked as refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getServiceIsRefundable() {
        return serviceIsRefundable;
    }

    /** 
     * Set the 'ServiceIsRefundable' element value. 
    					Description: Indicates whether the service is marked as refundable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param serviceIsRefundable
     */
    public void setServiceIsRefundable(Boolean serviceIsRefundable) {
        this.serviceIsRefundable = serviceIsRefundable;
    }

    /** 
     * Get the 'ServiceIsCommissionable' element value. 
    					Description: Indicates whether the service is marked as commissionable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getServiceIsCommissionable() {
        return serviceIsCommissionable;
    }

    /** 
     * Set the 'ServiceIsCommissionable' element value. 
    					Description: Indicates whether the service is marked as commissionable..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param serviceIsCommissionable
     */
    public void setServiceIsCommissionable(Boolean serviceIsCommissionable) {
        this.serviceIsCommissionable = serviceIsCommissionable;
    }

    /** 
     * Get the 'ReservationPaymentMaps' element value. 
    					Description: The collection of items that maps to the payments for this
    					charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfReservationPaymentMap getReservationPaymentMaps() {
        return reservationPaymentMaps;
    }

    /** 
     * Set the 'ReservationPaymentMaps' element value. 
    					Description: The collection of items that maps to the payments for this
    					charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationPaymentMaps
     */
    public void setReservationPaymentMaps(
            ArrayOfReservationPaymentMap reservationPaymentMaps) {
        this.reservationPaymentMaps = reservationPaymentMaps;
    }

    /** 
     * Get the 'PenaltyChargeID' element value. 
    					Description: &gt;If charge is a penalty, the original charge that generated the
    					penalty..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPenaltyChargeID() {
        return penaltyChargeID;
    }

    /** 
     * Set the 'PenaltyChargeID' element value. 
    					Description: &gt;If charge is a penalty, the original charge that generated the
    					penalty..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param penaltyChargeID
     */
    public void setPenaltyChargeID(Integer penaltyChargeID) {
        this.penaltyChargeID = penaltyChargeID;
    }

    /** 
     * Get the 'PenaltyTypeID' element value. 
    					Description: &gt;If charge is a penalty, the penalty type..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPenaltyTypeID() {
        return penaltyTypeID;
    }

    /** 
     * Set the 'PenaltyTypeID' element value. 
    					Description: &gt;If charge is a penalty, the penalty type..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param penaltyTypeID
     */
    public void setPenaltyTypeID(Integer penaltyTypeID) {
        this.penaltyTypeID = penaltyTypeID;
    }
}
