
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreatePNR.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="SaveReservation"/>
 *     &lt;xs:enumeration value="CommitSummary"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CreatePNRActionTypes {
    /** 
     * 
    <summary>Action to save changes which have been performed on a
    reservation</summary>
    
     */
    SAVE_RESERVATION("SaveReservation"), /** 
                                          * 
                                         <summary>Action to perform final commit to the database of data
                                         that was submitted during GetSummary call</summary>
                                         
                                          */
    COMMIT_SUMMARY("CommitSummary");
    private final String value;

    private CreatePNRActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CreatePNRActionTypes convert(String value) {
        for (CreatePNRActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
