
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GDSHistory">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="GDSMessageID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MessageType" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="MessageDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CRSCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GDSMessage" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GDSHistory
{
    private Integer GDSMessageID;
    private String key;
    private String recordLocator;
    private String messageType;
    private Date messageDate;
    private String CRSCode;
    private String GDSMessage;

    /** 
     * Get the 'GDSMessageID' element value. 
    					Description: A Unique Identifier representing this GDS transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getGDSMessageID() {
        return GDSMessageID;
    }

    /** 
     * Set the 'GDSMessageID' element value. 
    					Description: A Unique Identifier representing this GDS transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param GDSMessageID
     */
    public void setGDSMessageID(Integer GDSMessageID) {
        this.GDSMessageID = GDSMessageID;
    }

    /** 
     * Get the 'Key' element value. 
    					Description: Internal Object Key identifying this GDS transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: Internal Object Key identifying this GDS transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'RecordLocator' element value. 
    					Description: The Record Locator for the system initiating this GDS
    					Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. 
    					Description: The Record Locator for the system initiating this GDS
    					Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'MessageType' element value. Description: The type of GDS Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getMessageType() {
        return messageType;
    }

    /** 
     * Set the 'MessageType' element value. Description: The type of GDS Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param messageType
     */
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    /** 
     * Get the 'MessageDate' element value. 
    					Description: The date and time that the GDS transaction occurred in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getMessageDate() {
        return messageDate;
    }

    /** 
     * Set the 'MessageDate' element value. 
    					Description: The date and time that the GDS transaction occurred in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param messageDate
     */
    public void setMessageDate(Date messageDate) {
        this.messageDate = messageDate;
    }

    /** 
     * Get the 'CRSCode' element value. 
    					Description: The IATA code for the CRS that generated this transaction. It is
    					also the IATA code that generated the record locator.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCRSCode() {
        return CRSCode;
    }

    /** 
     * Set the 'CRSCode' element value. 
    					Description: The IATA code for the CRS that generated this transaction. It is
    					also the IATA code that generated the record locator.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param CRSCode
     */
    public void setCRSCode(String CRSCode) {
        this.CRSCode = CRSCode;
    }

    /** 
     * Get the 'GDSMessage' element value. 
    					Description: The actual ARIMP message received by or sent by the GDS Message
    					Processor.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGDSMessage() {
        return GDSMessage;
    }

    /** 
     * Set the 'GDSMessage' element value. 
    					Description: The actual ARIMP message received by or sent by the GDS Message
    					Processor.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param GDSMessage
     */
    public void setGDSMessage(String GDSMessage) {
        this.GDSMessage = GDSMessage;
    }
}
