
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:HistoryPNR.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="ns1:ArrayOfReservationToInsertHistory" nillable="true" name="ReservationsToInsertHistory" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryPNR extends TransactionInfo
{
    private HistoryPNRActionTypes actionType;
    private ReservationInfo reservationInfo;
    private ArrayOfReservationToInsertHistory reservationsToInsertHistory;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Action type indicating the Type of history being created.
    						Constraints: Required.
     * 
     * @return value
     */
    public HistoryPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Action type indicating the Type of history being created.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(HistoryPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'ReservationsToInsertHistory' element value. 
    							Description: Reservations Needing history insertion.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfReservationToInsertHistory getReservationsToInsertHistory() {
        return reservationsToInsertHistory;
    }

    /** 
     * Set the 'ReservationsToInsertHistory' element value. 
    							Description: Reservations Needing history insertion.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param reservationsToInsertHistory
     */
    public void setReservationsToInsertHistory(
            ArrayOfReservationToInsertHistory reservationsToInsertHistory) {
        this.reservationsToInsertHistory = reservationsToInsertHistory;
    }
}
