
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImportPNR.Reservation.Segment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="CarrierCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FlightNumber"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Origin"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Destination"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationName"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureTime"/>
 *     &lt;xs:element type="xs:dateTime" name="ArrivalTime"/>
 *     &lt;xs:element type="ns:ArrayOfImportPNR.Reservation.Segment.AirlinePerson" nillable="true" name="AirlinePersons"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ImportPNRReservationSegment
{
    private String carrierCode;
    private String flightNumber;
    private Date departureDate;
    private String origin;
    private String originName;
    private String destination;
    private String destinationName;
    private Date departureTime;
    private Date arrivalTime;
    private ArrayOfImportPNRReservationSegmentAirlinePerson airlinePersons;

    /** 
     * Get the 'CarrierCode' element value. 
    					Description: The IATA carrier code operating this physical flight.
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' element value. 
    					Description: The IATA carrier code operating this physical flight.
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Required.Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Required.Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Origin' element value. 
    					Description: The origin airport code the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. 
    					Description: The origin airport code the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'OriginName' element value. 
    					Description: The origin airport name the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getOriginName() {
        return originName;
    }

    /** 
     * Set the 'OriginName' element value. 
    					Description: The origin airport name the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param originName
     */
    public void setOriginName(String originName) {
        this.originName = originName;
    }

    /** 
     * Get the 'Destination' element value. 
    					Description: The destination airport code the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. 
    					Description: The destination airport code the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'DestinationName' element value. 
    					Description: The destination airport name the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getDestinationName() {
        return destinationName;
    }

    /** 
     * Set the 'DestinationName' element value. 
    					Description: The destination airport name the final landing place..
    				Constraints: Required.Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param destinationName
     */
    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    /** 
     * Get the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Required.
     * 
     * @param departureTime
     */
    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'ArrivalTime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getArrivalTime() {
        return arrivalTime;
    }

    /** 
     * Set the 'ArrivalTime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Required.
     * 
     * @param arrivalTime
     */
    public void setArrivalTime(Date arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    /** 
     * Get the 'AirlinePersons' element value. Description: The collection of AirlinePersons.
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfImportPNRReservationSegmentAirlinePerson getAirlinePersons() {
        return airlinePersons;
    }

    /** 
     * Set the 'AirlinePersons' element value. Description: The collection of AirlinePersons.
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				
     * 
     * @param airlinePersons
     */
    public void setAirlinePersons(
            ArrayOfImportPNRReservationSegmentAirlinePerson airlinePersons) {
        this.airlinePersons = airlinePersons;
    }
}
