
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LogicalFlight">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Origin" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginDefaultTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Destination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationDefaultTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginMetroGroup" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationMetroGroup" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SellingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Arrivaltime" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PackageItemID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PackageItemName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PackageItemDescription" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="PackageItemBookDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="PackageItemStartDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="PackageItemEndDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="VendorId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="VendorName" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Active" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="VendorDescription" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="UIDisplayValue" minOccurs="0"/>
 *     &lt;xs:element type="ns:ArrayOfPhysicalFlight" nillable="true" name="PhysicalFlights" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LogicalFlight
{
    private String key;
    private Integer recordNumber;
    private Integer logicalFlightID;
    private Date departureDate;
    private String origin;
    private String originDefaultTerminal;
    private String originName;
    private String destination;
    private String destinationDefaultTerminal;
    private String destinationName;
    private String originMetroGroup;
    private String destinationMetroGroup;
    private String sellingCarrier;
    private String operatingCarrier;
    private String operatingFlightNumber;
    private Date departureTime;
    private Date arrivaltime;
    private Integer packageItemID;
    private String packageItemName;
    private String packageItemDescription;
    private Date packageItemBookDate;
    private Date packageItemStartDate;
    private Date packageItemEndDate;
    private Integer vendorId;
    private String vendorName;
    private Boolean active;
    private String vendorDescription;
    private Integer UIDisplayValue;
    private ArrayOfPhysicalFlight physicalFlights;

    /** 
     * Get the 'Key' element value. 
    					Description: The internal unique identifier for the logical flight. The Key
    					consists of the LogicalFlightID, a ':', and the departure date and
    					time. Example: If the departure date and time is 3/16/2011 4:00:00
    					PM and the LogicalFlightID is 1422781, then the Key is
    					1422781:3/16/2011 4:00:00 PM..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: The internal unique identifier for the logical flight. The Key
    					consists of the LogicalFlightID, a ':', and the departure date and
    					time. Example: If the departure date and time is 3/16/2011 4:00:00
    					PM and the LogicalFlightID is 1422781, then the Key is
    					1422781:3/16/2011 4:00:00 PM..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'RecordNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(Integer logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'OriginDefaultTerminal' element value. 
    					Description: The default terminal name for the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginDefaultTerminal() {
        return originDefaultTerminal;
    }

    /** 
     * Set the 'OriginDefaultTerminal' element value. 
    					Description: The default terminal name for the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originDefaultTerminal
     */
    public void setOriginDefaultTerminal(String originDefaultTerminal) {
        this.originDefaultTerminal = originDefaultTerminal;
    }

    /** 
     * Get the 'OriginName' element value. Description: The name for the point of
    					departure..Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginName() {
        return originName;
    }

    /** 
     * Set the 'OriginName' element value. Description: The name for the point of
    					departure..Constraints: Optional (Not Required).
    				
     * 
     * @param originName
     */
    public void setOriginName(String originName) {
        this.originName = originName;
    }

    /** 
     * Get the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'DestinationDefaultTerminal' element value. 
    					Description: The default terminal name for the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationDefaultTerminal() {
        return destinationDefaultTerminal;
    }

    /** 
     * Set the 'DestinationDefaultTerminal' element value. 
    					Description: The default terminal name for the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destinationDefaultTerminal
     */
    public void setDestinationDefaultTerminal(String destinationDefaultTerminal) {
        this.destinationDefaultTerminal = destinationDefaultTerminal;
    }

    /** 
     * Get the 'DestinationName' element value. Description: The name of the final landing
    					place..Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationName() {
        return destinationName;
    }

    /** 
     * Set the 'DestinationName' element value. Description: The name of the final landing
    					place..Constraints: Optional (Not Required).
    				
     * 
     * @param destinationName
     */
    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    /** 
     * Get the 'OriginMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					OriginMetroGroup is the Metro Group from which your flight is
    					departing of from which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginMetroGroup() {
        return originMetroGroup;
    }

    /** 
     * Set the 'OriginMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					OriginMetroGroup is the Metro Group from which your flight is
    					departing of from which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originMetroGroup
     */
    public void setOriginMetroGroup(String originMetroGroup) {
        this.originMetroGroup = originMetroGroup;
    }

    /** 
     * Get the 'DestinationMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					DestinationMetroGroup is the Metro Group to which your flight is
    					arriving or to which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationMetroGroup() {
        return destinationMetroGroup;
    }

    /** 
     * Set the 'DestinationMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					DestinationMetroGroup is the Metro Group to which your flight is
    					arriving or to which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destinationMetroGroup
     */
    public void setDestinationMetroGroup(String destinationMetroGroup) {
        this.destinationMetroGroup = destinationMetroGroup;
    }

    /** 
     * Get the 'SellingCarrier' element value. 
    					Description: The IATA Carrier code for the airline making the sale..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSellingCarrier() {
        return sellingCarrier;
    }

    /** 
     * Set the 'SellingCarrier' element value. 
    					Description: The IATA Carrier code for the airline making the sale..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param sellingCarrier
     */
    public void setSellingCarrier(String sellingCarrier) {
        this.sellingCarrier = sellingCarrier;
    }

    /** 
     * Get the 'OperatingCarrier' element value. 
    					Description: The two letter IATA code for the carrier operating the
    					flight/leg..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. 
    					Description: The two letter IATA code for the carrier operating the
    					flight/leg..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(String operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'OperatingFlightNumber' element value. 
    					Description: The flight number for the operating flight for the leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingFlightNumber() {
        return operatingFlightNumber;
    }

    /** 
     * Set the 'OperatingFlightNumber' element value. 
    					Description: The flight number for the operating flight for the leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingFlightNumber
     */
    public void setOperatingFlightNumber(String operatingFlightNumber) {
        this.operatingFlightNumber = operatingFlightNumber;
    }

    /** 
     * Get the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureTime
     */
    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'Arrivaltime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getArrivaltime() {
        return arrivaltime;
    }

    /** 
     * Set the 'Arrivaltime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param arrivaltime
     */
    public void setArrivaltime(Date arrivaltime) {
        this.arrivaltime = arrivaltime;
    }

    /** 
     * Get the 'PackageItemID' element value. 
    					Description: The unique identifier for an item included in a vacation/travel
    					package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPackageItemID() {
        return packageItemID;
    }

    /** 
     * Set the 'PackageItemID' element value. 
    					Description: The unique identifier for an item included in a vacation/travel
    					package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemID
     */
    public void setPackageItemID(Integer packageItemID) {
        this.packageItemID = packageItemID;
    }

    /** 
     * Get the 'PackageItemName' element value. 
    					Description: The name of the item included in a vacation/travel package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPackageItemName() {
        return packageItemName;
    }

    /** 
     * Set the 'PackageItemName' element value. 
    					Description: The name of the item included in a vacation/travel package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemName
     */
    public void setPackageItemName(String packageItemName) {
        this.packageItemName = packageItemName;
    }

    /** 
     * Get the 'PackageItemDescription' element value. 
    					Description: The description of the item included in a vacation/travel
    					package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPackageItemDescription() {
        return packageItemDescription;
    }

    /** 
     * Set the 'PackageItemDescription' element value. 
    					Description: The description of the item included in a vacation/travel
    					package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemDescription
     */
    public void setPackageItemDescription(String packageItemDescription) {
        this.packageItemDescription = packageItemDescription;
    }

    /** 
     * Get the 'PackageItemBookDate' element value. 
    					Description: The date on which this vacation/travel package item was reserved.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getPackageItemBookDate() {
        return packageItemBookDate;
    }

    /** 
     * Set the 'PackageItemBookDate' element value. 
    					Description: The date on which this vacation/travel package item was reserved.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemBookDate
     */
    public void setPackageItemBookDate(Date packageItemBookDate) {
        this.packageItemBookDate = packageItemBookDate;
    }

    /** 
     * Get the 'PackageItemStartDate' element value. 
    					Description: The date from which this vacation/travel package item can be
    					booked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getPackageItemStartDate() {
        return packageItemStartDate;
    }

    /** 
     * Set the 'PackageItemStartDate' element value. 
    					Description: The date from which this vacation/travel package item can be
    					booked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemStartDate
     */
    public void setPackageItemStartDate(Date packageItemStartDate) {
        this.packageItemStartDate = packageItemStartDate;
    }

    /** 
     * Get the 'PackageItemEndDate' element value. 
    					Description: The date until which this vacation/travel package item can be
    					booked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getPackageItemEndDate() {
        return packageItemEndDate;
    }

    /** 
     * Set the 'PackageItemEndDate' element value. 
    					Description: The date until which this vacation/travel package item can be
    					booked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packageItemEndDate
     */
    public void setPackageItemEndDate(Date packageItemEndDate) {
        this.packageItemEndDate = packageItemEndDate;
    }

    /** 
     * Get the 'VendorId' element value. 
    					Description: The unique identifier for the vendor fulfilling the
    					vacation/travel package item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getVendorId() {
        return vendorId;
    }

    /** 
     * Set the 'VendorId' element value. 
    					Description: The unique identifier for the vendor fulfilling the
    					vacation/travel package item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param vendorId
     */
    public void setVendorId(Integer vendorId) {
        this.vendorId = vendorId;
    }

    /** 
     * Get the 'VendorName' element value. 
    					Description: The name of the vendor fulfilling the vacation/travel package
    					item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getVendorName() {
        return vendorName;
    }

    /** 
     * Set the 'VendorName' element value. 
    					Description: The name of the vendor fulfilling the vacation/travel package
    					item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param vendorName
     */
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    /** 
     * Get the 'Active' element value. 
    					Description: Indicates whether the flight is active. True or False.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getActive() {
        return active;
    }

    /** 
     * Set the 'Active' element value. 
    					Description: Indicates whether the flight is active. True or False.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param active
     */
    public void setActive(Boolean active) {
        this.active = active;
    }

    /** 
     * Get the 'VendorDescription' element value. 
    					Description: The description of the vendor fulfilling the vacation/travel
    					package item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getVendorDescription() {
        return vendorDescription;
    }

    /** 
     * Set the 'VendorDescription' element value. 
    					Description: The description of the vendor fulfilling the vacation/travel
    					package item..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param vendorDescription
     */
    public void setVendorDescription(String vendorDescription) {
        this.vendorDescription = vendorDescription;
    }

    /** 
     * Get the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getUIDisplayValue() {
        return UIDisplayValue;
    }

    /** 
     * Set the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param UIDisplayValue
     */
    public void setUIDisplayValue(Integer UIDisplayValue) {
        this.UIDisplayValue = UIDisplayValue;
    }

    /** 
     * Get the 'PhysicalFlights' element value. 
    					Description: A physical flight represents the actual departure and arrival of
    					an aircraft from an origin airport to the destination airport. A
    					physical flight is commonly referred to as a 'Leg'.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfPhysicalFlight getPhysicalFlights() {
        return physicalFlights;
    }

    /** 
     * Set the 'PhysicalFlights' element value. 
    					Description: A physical flight represents the actual departure and arrival of
    					an aircraft from an origin airport to the destination airport. A
    					physical flight is commonly referred to as a 'Leg'.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param physicalFlights
     */
    public void setPhysicalFlights(ArrayOfPhysicalFlight physicalFlights) {
        this.physicalFlights = physicalFlights;
    }
}
