
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AddFlightToReservation"/>
 *     &lt;xs:enumeration value="RemoveFlightFromReservation"/>
 *     &lt;xs:enumeration value="ReplaceFlightOnReservation"/>
 *     &lt;xs:enumeration value="AddPassengerToReservation"/>
 *     &lt;xs:enumeration value="RemovePassengerFromReservation"/>
 *     &lt;xs:enumeration value="UpdatePassengerInformationNoFee"/>
 *     &lt;xs:enumeration value="UpdatePassengerInformationAssessFee"/>
 *     &lt;xs:enumeration value="AddSpecialServiceToReservation"/>
 *     &lt;xs:enumeration value="RemoveSpecialServiceFromReservation"/>
 *     &lt;xs:enumeration value="AddContactInformation"/>
 *     &lt;xs:enumeration value="UpdateContactInformation"/>
 *     &lt;xs:enumeration value="AddCommentToReservation"/>
 *     &lt;xs:enumeration value="AddEmergencyContact"/>
 *     &lt;xs:enumeration value="UpdatePassengerSegmentRecordLocator"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ModifyPNRActionTypes {
    /** 
     * 
    <summary>Action to add a flight to a reservation</summary>
    
     */
    ADD_FLIGHT_TO_RESERVATION("AddFlightToReservation"), /** 
                                                          * 
                                                         <summary>Action to remove a flight and all passengers within from
                                                         a reservation</summary>
                                                         
                                                          */
    REMOVE_FLIGHT_FROM_RESERVATION("RemoveFlightFromReservation"), /** 
                                                                    * 
                                                                   <summary>Action to replace a flight on a reservation</summary>
                                                                   
                                                                    */
    REPLACE_FLIGHT_ON_RESERVATION("ReplaceFlightOnReservation"), /** 
                                                                  * 
                                                                 <summary>Action to add a passenger to a reservation</summary>
                                                                 
                                                                  */
    ADD_PASSENGER_TO_RESERVATION("AddPassengerToReservation"), /** 
                                                                * 
                                                               <summary>Action to remove a passenger from a reservation</summary>
                                                               
                                                                */
    REMOVE_PASSENGER_FROM_RESERVATION("RemovePassengerFromReservation"), /** 
                                                                          * 
                                                                         <summary>Action to update passenger name information without a
                                                                         system defined fee being assessed</summary>
                                                                         
                                                                          */
    UPDATE_PASSENGER_INFORMATION_NO_FEE("UpdatePassengerInformationNoFee"), /** 
                                                                             * 
                                                                            <summary>Action to update passenger name information with a system
                                                                            defined fee being assessed</summary>
                                                                            
                                                                             */
    UPDATE_PASSENGER_INFORMATION_ASSESS_FEE(
            "UpdatePassengerInformationAssessFee"), /** 
                                                     * 
                                                    <summary>Action to add a special service to a reservation</summary>
                                                    
                                                     */
    ADD_SPECIAL_SERVICE_TO_RESERVATION("AddSpecialServiceToReservation"), /** 
                                                                           * 
                                                                          <summary>Action to add a special service to a reservation</summary>
                                                                          
                                                                           */
    REMOVE_SPECIAL_SERVICE_FROM_RESERVATION(
            "RemoveSpecialServiceFromReservation"), /** 
                                                     * 
                                                    <summary>Action to add contact Information</summary>
                                                    
                                                     */
    ADD_CONTACT_INFORMATION("AddContactInformation"), /** 
                                                       * 
                                                      <summary>Action to update contact Information</summary>
                                                      
                                                       */
    UPDATE_CONTACT_INFORMATION("UpdateContactInformation"), /** 
                                                             * 
                                                            <summary>Action to add comment to a reservation</summary>
                                                            
                                                             */
    ADD_COMMENT_TO_RESERVATION("AddCommentToReservation"), /** 
                                                            * 
                                                           <summary>Action to add an emergency contact to a passenger segment</summary>
                                                           
                                                            */
    ADD_EMERGENCY_CONTACT("AddEmergencyContact"), /** 
                                                   * 
                                                  <summary>Action to update the record loactor of a passenger
                                                  segment</summary>
                                                  
                                                   */
    UPDATE_PASSENGER_SEGMENT_RECORD_LOCATOR(
            "UpdatePassengerSegmentRecordLocator");
    private final String value;

    private ModifyPNRActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ModifyPNRActionTypes convert(String value) {
        for (ModifyPNRActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
