
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsContactTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsGenderTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsRelationshipTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.EmergencyContact">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MiddleName"/>
 *     &lt;xs:element type="xs:int" name="Age"/>
 *     &lt;xs:element type="xs:dateTime" name="DOB"/>
 *     &lt;xs:element type="ns:Enumerations.GenderTypes" name="Gender"/>
 *     &lt;xs:element type="ns:Enumerations.RelationshipTypes" name="RelationType"/>
 *     &lt;xs:element type="ns1:Address" nillable="true" name="Address"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Company"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Comments"/>
 *     &lt;xs:element type="ns:Enumerations.ContactTypes" name="ContactType"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ContactInformation"/>
 *     &lt;xs:element type="xs:boolean" name="DisclosedEmergencyContact"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ReservationKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhysicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CustomerKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AirlinePersonKey"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNREmergencyContact
{
    private String title;
    private String firstName;
    private String lastName;
    private String middleName;
    private int age;
    private Date DOB;
    private EnumerationsGenderTypes gender;
    private EnumerationsRelationshipTypes relationType;
    private Address address;
    private String company;
    private String comments;
    private EnumerationsContactTypes contactType;
    private String contactInformation;
    private boolean disclosedEmergencyContact;
    private String reservationKey;
    private String logicalFlightKey;
    private String physicalFlightKey;
    private String customerKey;
    private String airlinePersonKey;

    /** 
     * Get the 'Title' element value. Description: The person's title.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. Description: The person's title.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'FirstName' element value. Description: The person's first name.
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: The person's first name.
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. Description: The person's last name.
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: The person's last name.
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'MiddleName' element value. Description: The person's middle name.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. Description: The person's middle name.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'Age' element value. Description: The person's age.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value. Description: The person's age.Constraints: Optional (Not Required).
    				
     * 
     * @param age
     */
    public void setAge(int age) {
        this.age = age;
    }

    /** 
     * Get the 'DOB' element value. Description: The person's data of birth.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDOB() {
        return DOB;
    }

    /** 
     * Set the 'DOB' element value. Description: The person's data of birth.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param DOB
     */
    public void setDOB(Date DOB) {
        this.DOB = DOB;
    }

    /** 
     * Get the 'Gender' element value. Description: The person's Gender.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsGenderTypes getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. Description: The person's Gender.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gender
     */
    public void setGender(EnumerationsGenderTypes gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'RelationType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsRelationshipTypes getRelationType() {
        return relationType;
    }

    /** 
     * Set the 'RelationType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param relationType
     */
    public void setRelationType(EnumerationsRelationshipTypes relationType) {
        this.relationType = relationType;
    }

    /** 
     * Get the 'Address' element value. Description: Address Object.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. Description: Address Object.Constraints: Optional (Not Required).
    				
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'Company' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'Comments' element value. 
    					Description: Any comments that are associated to this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. 
    					Description: Any comments that are associated to this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsContactTypes getContactType() {
        return contactType;
    }

    /** 
     * Set the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @param contactType
     */
    public void setContactType(EnumerationsContactTypes contactType) {
        this.contactType = contactType;
    }

    /** 
     * Get the 'ContactInformation' element value. 
    					Description: Contact information phone number, email address etc.....
    				Constraints: Required.
     * 
     * @return value
     */
    public String getContactInformation() {
        return contactInformation;
    }

    /** 
     * Set the 'ContactInformation' element value. 
    					Description: Contact information phone number, email address etc.....
    				Constraints: Required.
     * 
     * @param contactInformation
     */
    public void setContactInformation(String contactInformation) {
        this.contactInformation = contactInformation;
    }

    /** 
     * Get the 'DisclosedEmergencyContact' element value. 
    					Description: If the traveler choses to disclose and emergency contact then
    					this value wil be set to True and the indicator in the data base
    					will reflect that they disclosed the information otherwise a False
    					value will indicate that the Traveler chose NOT to disclose
    					information..
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isDisclosedEmergencyContact() {
        return disclosedEmergencyContact;
    }

    /** 
     * Set the 'DisclosedEmergencyContact' element value. 
    					Description: If the traveler choses to disclose and emergency contact then
    					this value wil be set to True and the indicator in the data base
    					will reflect that they disclosed the information otherwise a False
    					value will indicate that the Traveler chose NOT to disclose
    					information..
    				Constraints: Required.
     * 
     * @param disclosedEmergencyContact
     */
    public void setDisclosedEmergencyContact(boolean disclosedEmergencyContact) {
        this.disclosedEmergencyContact = disclosedEmergencyContact;
    }

    /** 
     * Get the 'ReservationKey' element value. 
    					Description: The Reservation Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getReservationKey() {
        return reservationKey;
    }

    /** 
     * Set the 'ReservationKey' element value. 
    					Description: The Reservation Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param reservationKey
     */
    public void setReservationKey(String reservationKey) {
        this.reservationKey = reservationKey;
    }

    /** 
     * Get the 'LogicalFlightKey' element value. 
    					Description: The Logical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLogicalFlightKey() {
        return logicalFlightKey;
    }

    /** 
     * Set the 'LogicalFlightKey' element value. 
    					Description: The Logical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param logicalFlightKey
     */
    public void setLogicalFlightKey(String logicalFlightKey) {
        this.logicalFlightKey = logicalFlightKey;
    }

    /** 
     * Get the 'PhysicalFlightKey' element value. 
    					Description: The Physical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPhysicalFlightKey() {
        return physicalFlightKey;
    }

    /** 
     * Set the 'PhysicalFlightKey' element value. 
    					Description: The Physical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param physicalFlightKey
     */
    public void setPhysicalFlightKey(String physicalFlightKey) {
        this.physicalFlightKey = physicalFlightKey;
    }

    /** 
     * Get the 'CustomerKey' element value. 
    					Description: The Customer Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCustomerKey() {
        return customerKey;
    }

    /** 
     * Set the 'CustomerKey' element value. 
    					Description: The Customer Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param customerKey
     */
    public void setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
    }

    /** 
     * Get the 'AirlinePersonKey' element value. 
    					Description: The Airline Person Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAirlinePersonKey() {
        return airlinePersonKey;
    }

    /** 
     * Set the 'AirlinePersonKey' element value. 
    					Description: The Airline Person Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param airlinePersonKey
     */
    public void setAirlinePersonKey(String airlinePersonKey) {
        this.airlinePersonKey = airlinePersonKey;
    }
}
