
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentMethodTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="ReservationPaymentID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CompanyName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardType"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardHolder"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="PaymentCurrency"/>
 *     &lt;xs:element type="xs:int" name="ISOCurrency"/>
 *     &lt;xs:element type="xs:decimal" name="PaymentAmount"/>
 *     &lt;xs:element type="ns:Enumerations.PaymentMethodTypes" name="PaymentMethod"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardNum"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CVCode"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpirationDate"/>
 *     &lt;xs:element type="xs:boolean" name="IsTACreditCard"/>
 *     &lt;xs:element type="xs:long" name="VoucherNum"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxOpt"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginalCurrency"/>
 *     &lt;xs:element type="xs:decimal" name="OriginalAmount"/>
 *     &lt;xs:element type="xs:decimal" name="ExchangeRate"/>
 *     &lt;xs:element type="xs:dateTime" name="ExchangeRateDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentComment"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BillingCountry"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Payment
{
    private int reservationPaymentID;
    private String companyName;
    private String firstName;
    private String lastName;
    private String cardType;
    private String cardHolder;
    private EnumerationsCurrencyCodeTypes paymentCurrency;
    private int ISOCurrency;
    private BigDecimal paymentAmount;
    private EnumerationsPaymentMethodTypes paymentMethod;
    private String cardNum;
    private String CVCode;
    private Date expirationDate;
    private boolean isTACreditCard;
    private long voucherNum;
    private String gcxID;
    private String gcxOpt;
    private String originalCurrency;
    private BigDecimal originalAmount;
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;
    private String paymentComment;
    private String billingCountry;

    /** 
     * Get the 'ReservationPaymentID' element value. 
    					Description: The database level unique identifier for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getReservationPaymentID() {
        return reservationPaymentID;
    }

    /** 
     * Set the 'ReservationPaymentID' element value. 
    					Description: The database level unique identifier for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationPaymentID
     */
    public void setReservationPaymentID(int reservationPaymentID) {
        this.reservationPaymentID = reservationPaymentID;
    }

    /** 
     * Get the 'CompanyName' element value. 
    					Description: The Company name for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. 
    					Description: The Company name for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The First Name of the person responsible for the payment.
    				Constraints: Required.Range: Length must be in the range 1 and 500.
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The First Name of the person responsible for the payment.
    				Constraints: Required.Range: Length must be in the range 1 and 500.
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The Last Name of the person responsible for the payment.
    				Constraints: Required.Range: Length must be in the range 1 and 500.
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The Last Name of the person responsible for the payment.
    				Constraints: Required.Range: Length must be in the range 1 and 500.
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'CardType' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public String getCardType() {
        return cardType;
    }

    /** 
     * Set the 'CardType' element value. Description: .Constraints: Required.
     * 
     * @param cardType
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /** 
     * Get the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardHolder() {
        return cardHolder;
    }

    /** 
     * Set the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardHolder
     */
    public void setCardHolder(String cardHolder) {
        this.cardHolder = cardHolder;
    }

    /** 
     * Get the 'PaymentCurrency' element value. Description: The currency for this payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getPaymentCurrency() {
        return paymentCurrency;
    }

    /** 
     * Set the 'PaymentCurrency' element value. Description: The currency for this payment.
    				Constraints: Required.
     * 
     * @param paymentCurrency
     */
    public void setPaymentCurrency(EnumerationsCurrencyCodeTypes paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    /** 
     * Get the 'ISOCurrency' element value. Description: The currency for this payment.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getISOCurrency() {
        return ISOCurrency;
    }

    /** 
     * Set the 'ISOCurrency' element value. Description: The currency for this payment.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param ISOCurrency
     */
    public void setISOCurrency(int ISOCurrency) {
        this.ISOCurrency = ISOCurrency;
    }

    /** 
     * Get the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    /** 
     * Set the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Required.
     * 
     * @param paymentAmount
     */
    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    /** 
     * Get the 'PaymentMethod' element value. 
    					Description: The original payment method that was used in the event that this
    					payment is a refund.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsPaymentMethodTypes getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. 
    					Description: The original payment method that was used in the event that this
    					payment is a refund.
    				Constraints: Required.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(EnumerationsPaymentMethodTypes paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'CardNum' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardNum() {
        return cardNum;
    }

    /** 
     * Set the 'CardNum' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardNum
     */
    public void setCardNum(String cardNum) {
        this.cardNum = cardNum;
    }

    /** 
     * Get the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 5.
    				
     * 
     * @return value
     */
    public String getCVCode() {
        return CVCode;
    }

    /** 
     * Set the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 5.
    				
     * 
     * @param CVCode
     */
    public void setCVCode(String CVCode) {
        this.CVCode = CVCode;
    }

    /** 
     * Get the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Required.
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'IsTACreditCard' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isIsTACreditCard() {
        return isTACreditCard;
    }

    /** 
     * Set the 'IsTACreditCard' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param isTACreditCard
     */
    public void setIsTACreditCard(boolean isTACreditCard) {
        this.isTACreditCard = isTACreditCard;
    }

    /** 
     * Get the 'VoucherNum' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public long getVoucherNum() {
        return voucherNum;
    }

    /** 
     * Set the 'VoucherNum' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Required.
     * 
     * @param voucherNum
     */
    public void setVoucherNum(long voucherNum) {
        this.voucherNum = voucherNum;
    }

    /** 
     * Get the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGcxID() {
        return gcxID;
    }

    /** 
     * Set the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxID
     */
    public void setGcxID(String gcxID) {
        this.gcxID = gcxID;
    }

    /** 
     * Get the 'GcxOpt' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Required.Range: Length must be in the range 1 and 1.
    				
     * 
     * @return value
     */
    public String getGcxOpt() {
        return gcxOpt;
    }

    /** 
     * Set the 'GcxOpt' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Required.Range: Length must be in the range 1 and 1.
    				
     * 
     * @param gcxOpt
     */
    public void setGcxOpt(String gcxOpt) {
        this.gcxOpt = gcxOpt;
    }

    /** 
     * Get the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginalCurrency() {
        return originalCurrency;
    }

    /** 
     * Set the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalCurrency
     */
    public void setOriginalCurrency(String originalCurrency) {
        this.originalCurrency = originalCurrency;
    }

    /** 
     * Get the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Required.
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getExchangeRateDate() {
        return exchangeRateDate;
    }

    /** 
     * Set the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @param exchangeRateDate
     */
    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }

    /** 
     * Get the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPaymentComment() {
        return paymentComment;
    }

    /** 
     * Set the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Required.
     * 
     * @param paymentComment
     */
    public void setPaymentComment(String paymentComment) {
        this.paymentComment = paymentComment;
    }

    /** 
     * Get the 'BillingCountry' element value. 
    					Description: This value is routinely required by payment gateways to perform
    					fraud management. Normal value is the country 2 Letter
    					abbreviation but can be the 3 letter country code or the ISO
    					Country code. This varies by payment gateway.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getBillingCountry() {
        return billingCountry;
    }

    /** 
     * Set the 'BillingCountry' element value. 
    					Description: This value is routinely required by payment gateways to perform
    					fraud management. Normal value is the country 2 Letter
    					abbreviation but can be the 3 letter country code or the ISO
    					Country code. This varies by payment gateway.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumeric.
     * 
     * @param billingCountry
     */
    public void setBillingCountry(String billingCountry) {
        this.billingCountry = billingCountry;
    }
}
