
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhysicalFlight">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationDefaultTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PhysicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CarrierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CarrierName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="FlightOrder" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Origin" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginDefaultTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Destination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginMetroGroup" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationMetroGroup" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SellingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Arrivaltime" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="FlightDuration" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="Trip" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Gate" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="TotalWeight" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="UIDisplayValue" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Active" minOccurs="0"/>
 *     &lt;xs:element type="ns:ArrayOfCustomer" nillable="true" name="Customers" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FromTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ToTerminal" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PhysicalFlight
{
    private String key;
    private Integer recordNumber;
    private String destinationDefaultTerminal;
    private Integer physicalFlightID;
    private Integer logicalFlightID;
    private String carrierCode;
    private String carrierName;
    private String flightNumber;
    private Integer flightOrder;
    private Date departureDate;
    private String origin;
    private String originDefaultTerminal;
    private String originName;
    private String destination;
    private String destinationName;
    private String originMetroGroup;
    private String destinationMetroGroup;
    private String sellingCarrier;
    private String operatingCarrier;
    private String operatingFlightNumber;
    private Date departureTime;
    private Date arrivaltime;
    private BigDecimal flightDuration;
    private Integer trip;
    private String gate;
    private BigDecimal totalWeight;
    private Integer UIDisplayValue;
    private Boolean active;
    private ArrayOfCustomer customers;
    private String fromTerminal;
    private String toTerminal;

    /** 
     * Get the 'Key' element value. Description: The object key for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: The object key for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    					Description: The record number for the segment associated with the physical
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    					Description: The record number for the segment associated with the physical
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'DestinationDefaultTerminal' element value. 
    					Description: The default terminal name for the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationDefaultTerminal() {
        return destinationDefaultTerminal;
    }

    /** 
     * Set the 'DestinationDefaultTerminal' element value. 
    					Description: The default terminal name for the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destinationDefaultTerminal
     */
    public void setDestinationDefaultTerminal(String destinationDefaultTerminal) {
        this.destinationDefaultTerminal = destinationDefaultTerminal;
    }

    /** 
     * Get the 'PhysicalFlightID' element value. 
    					Description: The unique identifier representing this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPhysicalFlightID() {
        return physicalFlightID;
    }

    /** 
     * Set the 'PhysicalFlightID' element value. 
    					Description: The unique identifier representing this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param physicalFlightID
     */
    public void setPhysicalFlightID(Integer physicalFlightID) {
        this.physicalFlightID = physicalFlightID;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: The logical flight ID that this physical flight is immediately
    					associated with.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: The logical flight ID that this physical flight is immediately
    					associated with.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(Integer logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'CarrierCode' element value. 
    					Description: The IATA carrier code operating this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' element value. 
    					Description: The IATA carrier code operating this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'CarrierName' element value. 
    					Description: The name of the carrier operating this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCarrierName() {
        return carrierName;
    }

    /** 
     * Set the 'CarrierName' element value. 
    					Description: The name of the carrier operating this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param carrierName
     */
    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    /** 
     * Get the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'FlightOrder' element value. 
    					Description: The order of this flight in a multi-segment (connection or
    					through ) flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getFlightOrder() {
        return flightOrder;
    }

    /** 
     * Set the 'FlightOrder' element value. 
    					Description: The order of this flight in a multi-segment (connection or
    					through ) flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param flightOrder
     */
    public void setFlightOrder(Integer flightOrder) {
        this.flightOrder = flightOrder;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: The date which this flight departs of the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: The date which this flight departs of the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'OriginDefaultTerminal' element value. 
    					Description: The default terminal name for the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginDefaultTerminal() {
        return originDefaultTerminal;
    }

    /** 
     * Set the 'OriginDefaultTerminal' element value. 
    					Description: The default terminal name for the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originDefaultTerminal
     */
    public void setOriginDefaultTerminal(String originDefaultTerminal) {
        this.originDefaultTerminal = originDefaultTerminal;
    }

    /** 
     * Get the 'OriginName' element value. Description: The name for the point of
    					departure..Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginName() {
        return originName;
    }

    /** 
     * Set the 'OriginName' element value. Description: The name for the point of
    					departure..Constraints: Optional (Not Required).
    				
     * 
     * @param originName
     */
    public void setOriginName(String originName) {
        this.originName = originName;
    }

    /** 
     * Get the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'DestinationName' element value. Description: The name of the final landing
    					place..Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationName() {
        return destinationName;
    }

    /** 
     * Set the 'DestinationName' element value. Description: The name of the final landing
    					place..Constraints: Optional (Not Required).
    				
     * 
     * @param destinationName
     */
    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    /** 
     * Get the 'OriginMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					OriginMetroGroup is the Metro Group from which your flight is
    					departing of from which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginMetroGroup() {
        return originMetroGroup;
    }

    /** 
     * Set the 'OriginMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					OriginMetroGroup is the Metro Group from which your flight is
    					departing of from which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originMetroGroup
     */
    public void setOriginMetroGroup(String originMetroGroup) {
        this.originMetroGroup = originMetroGroup;
    }

    /** 
     * Get the 'DestinationMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					DestinationMetroGroup is the Metro Group to which your flight is
    					arriving or to which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationMetroGroup() {
        return destinationMetroGroup;
    }

    /** 
     * Set the 'DestinationMetroGroup' element value. 
    					Description: A Metro Group is used in order to organize airports in a
    					geographic location. I.e., You can setup a metro group called
    					'NYC' that contains the airports JFK, EWR, LGA. The
    					DestinationMetroGroup is the Metro Group to which your flight is
    					arriving or to which you requested availability.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destinationMetroGroup
     */
    public void setDestinationMetroGroup(String destinationMetroGroup) {
        this.destinationMetroGroup = destinationMetroGroup;
    }

    /** 
     * Get the 'SellingCarrier' element value. 
    					Description: The IATA Carrier code for the airline making or marketing the
    					sale..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSellingCarrier() {
        return sellingCarrier;
    }

    /** 
     * Set the 'SellingCarrier' element value. 
    					Description: The IATA Carrier code for the airline making or marketing the
    					sale..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param sellingCarrier
     */
    public void setSellingCarrier(String sellingCarrier) {
        this.sellingCarrier = sellingCarrier;
    }

    /** 
     * Get the 'OperatingCarrier' element value. 
    					Description: Operating carrier is the two letter IATA carrier code of the
    					carrier that is operating this flight/leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. 
    					Description: Operating carrier is the two letter IATA carrier code of the
    					carrier that is operating this flight/leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(String operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'OperatingFlightNumber' element value. 
    					Description: Is the flight number for the operating flight for this leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingFlightNumber() {
        return operatingFlightNumber;
    }

    /** 
     * Set the 'OperatingFlightNumber' element value. 
    					Description: Is the flight number for the operating flight for this leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingFlightNumber
     */
    public void setOperatingFlightNumber(String operatingFlightNumber) {
        this.operatingFlightNumber = operatingFlightNumber;
    }

    /** 
     * Get the 'DepartureTime' element value. 
    					Description: The specified time the logical flight takes leave in the time
    					zone of the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value. 
    					Description: The specified time the logical flight takes leave in the time
    					zone of the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureTime
     */
    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'Arrivaltime' element value. 
    					Description: The specified time the logical flight arrives in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getArrivaltime() {
        return arrivaltime;
    }

    /** 
     * Set the 'Arrivaltime' element value. 
    					Description: The specified time the logical flight arrives in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param arrivaltime
     */
    public void setArrivaltime(Date arrivaltime) {
        this.arrivaltime = arrivaltime;
    }

    /** 
     * Get the 'FlightDuration' element value. 
    					Description: The calculated duration of the flight (seconds) based on the
    					departure and arrival time.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getFlightDuration() {
        return flightDuration;
    }

    /** 
     * Set the 'FlightDuration' element value. 
    					Description: The calculated duration of the flight (seconds) based on the
    					departure and arrival time.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param flightDuration
     */
    public void setFlightDuration(BigDecimal flightDuration) {
        this.flightDuration = flightDuration;
    }

    /** 
     * Get the 'Trip' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTrip() {
        return trip;
    }

    /** 
     * Set the 'Trip' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param trip
     */
    public void setTrip(Integer trip) {
        this.trip = trip;
    }

    /** 
     * Get the 'Gate' element value. Description: The departure gate for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGate() {
        return gate;
    }

    /** 
     * Set the 'Gate' element value. Description: The departure gate for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gate
     */
    public void setGate(String gate) {
        this.gate = gate;
    }

    /** 
     * Get the 'TotalWeight' element value. 
    					Description: The total offload weight for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    /** 
     * Set the 'TotalWeight' element value. 
    					Description: The total offload weight for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param totalWeight
     */
    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    /** 
     * Get the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getUIDisplayValue() {
        return UIDisplayValue;
    }

    /** 
     * Set the 'UIDisplayValue' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param UIDisplayValue
     */
    public void setUIDisplayValue(Integer UIDisplayValue) {
        this.UIDisplayValue = UIDisplayValue;
    }

    /** 
     * Get the 'Active' element value. Description: The active status of this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getActive() {
        return active;
    }

    /** 
     * Set the 'Active' element value. Description: The active status of this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param active
     */
    public void setActive(Boolean active) {
        this.active = active;
    }

    /** 
     * Get the 'Customers' element value. 
    					Description: The passengers on this physical flight for this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfCustomer getCustomers() {
        return customers;
    }

    /** 
     * Set the 'Customers' element value. 
    					Description: The passengers on this physical flight for this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param customers
     */
    public void setCustomers(ArrayOfCustomer customers) {
        this.customers = customers;
    }

    /** 
     * Get the 'FromTerminal' element value. 
    					Description: The departure terminal for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFromTerminal() {
        return fromTerminal;
    }

    /** 
     * Set the 'FromTerminal' element value. 
    					Description: The departure terminal for this flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param fromTerminal
     */
    public void setFromTerminal(String fromTerminal) {
        this.fromTerminal = fromTerminal;
    }

    /** 
     * Get the 'ToTerminal' element value. Description: The arrival terminal for this
    					flight.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getToTerminal() {
        return toTerminal;
    }

    /** 
     * Set the 'ToTerminal' element value. Description: The arrival terminal for this
    					flight.Constraints: Optional (Not Required).
    				
     * 
     * @param toTerminal
     */
    public void setToTerminal(String toTerminal) {
        this.toTerminal = toTerminal;
    }
}
