
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsReservationChannelTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationToInsertHistory">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Action"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="HistoryEventText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Passenger" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Segment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Description"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="User"/>
 *     &lt;xs:element type="ns:Enumerations.ReservationChannelTypes" name="ResChannel"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationToInsertHistory
{
    private String action;
    private String historyEventText;
    private String passenger;
    private String segment;
    private String description;
    private String user;
    private EnumerationsReservationChannelTypes resChannel;

    /** 
     * Get the 'Action' element value. Description: History Event.Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getAction() {
        return action;
    }

    /** 
     * Set the 'Action' element value. Description: History Event.Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @param action
     */
    public void setAction(String action) {
        this.action = action;
    }

    /** 
     * Get the 'HistoryEventText' element value. Description: History Event Text.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getHistoryEventText() {
        return historyEventText;
    }

    /** 
     * Set the 'HistoryEventText' element value. Description: History Event Text.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @param historyEventText
     */
    public void setHistoryEventText(String historyEventText) {
        this.historyEventText = historyEventText;
    }

    /** 
     * Get the 'Passenger' element value. 
    					Description: Passenger for which history event is being performed against Name
    					submitted i.e.. FIRSTNAME LASTNAME.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 129.
    				
     * 
     * @return value
     */
    public String getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'Passenger' element value. 
    					Description: Passenger for which history event is being performed against Name
    					submitted i.e.. FIRSTNAME LASTNAME.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 129.
    				
     * 
     * @param passenger
     */
    public void setPassenger(String passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'Segment' element value. 
    					Description: Segment Information, If provided format example RX 1942 ORD- MCO
    					01-Jan 01 Mon 18:00 00:00 Fri 27-Jun 14 ADT.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 512.
    				
     * 
     * @return value
     */
    public String getSegment() {
        return segment;
    }

    /** 
     * Set the 'Segment' element value. 
    					Description: Segment Information, If provided format example RX 1942 ORD- MCO
    					01-Jan 01 Mon 18:00 00:00 Fri 27-Jun 14 ADT.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 512.
    				
     * 
     * @param segment
     */
    public void setSegment(String segment) {
        this.segment = segment;
    }

    /** 
     * Get the 'Description' element value. Description: Description.Constraints: Required.Range: Length must be in the range 1 and 2000.
    				
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description: Description.Constraints: Required.Range: Length must be in the range 1 and 2000.
    				
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'User' element value. 
    					Description: This will be the Radixx System user ID of person performing the
    					history event..
    				Constraints: Required.Range: Length must be in the range 1 and 32.
    				
     * 
     * @return value
     */
    public String getUser() {
        return user;
    }

    /** 
     * Set the 'User' element value. 
    					Description: This will be the Radixx System user ID of person performing the
    					history event..
    				Constraints: Required.Range: Length must be in the range 1 and 32.
    				
     * 
     * @param user
     */
    public void setUser(String user) {
        this.user = user;
    }

    /** 
     * Get the 'ResChannel' element value. 
    					Description: The value submitted here will override the Reservation channel
    					that is associated with the CP/API user account..
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsReservationChannelTypes getResChannel() {
        return resChannel;
    }

    /** 
     * Set the 'ResChannel' element value. 
    					Description: The value submitted here will override the Reservation channel
    					that is associated with the CP/API user account..
    				Constraints: Required.
     * 
     * @param resChannel
     */
    public void setResChannel(EnumerationsReservationChannelTypes resChannel) {
        this.resChannel = resChannel;
    }
}
