
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsReservationChannelTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationToInsertHistory">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Action"/>
 *     &lt;xs:element type="xs:boolean" name="UpdatedPNRHistory"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="HistoryEventText" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="UpdateDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Passenger"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Segment"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Description"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="User"/>
 *     &lt;xs:element type="ns:Enumerations.ReservationChannelTypes" name="ResChannel"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IPAddress"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationToInsertHistory1
{
    private String action;
    private boolean updatedPNRHistory;
    private String historyEventText;
    private Date updateDate;
    private String passenger;
    private String segment;
    private String description;
    private String user;
    private EnumerationsReservationChannelTypes resChannel;
    private String IPAddress;

    /** 
     * Get the 'Action' element value. Description: History Event.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getAction() {
        return action;
    }

    /** 
     * Set the 'Action' element value. Description: History Event.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param action
     */
    public void setAction(String action) {
        this.action = action;
    }

    /** 
     * Get the 'UpdatedPNRHistory' element value. Description: UpdatedPNRHistory.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isUpdatedPNRHistory() {
        return updatedPNRHistory;
    }

    /** 
     * Set the 'UpdatedPNRHistory' element value. Description: UpdatedPNRHistory.
    				Constraints: Required.
     * 
     * @param updatedPNRHistory
     */
    public void setUpdatedPNRHistory(boolean updatedPNRHistory) {
        this.updatedPNRHistory = updatedPNRHistory;
    }

    /** 
     * Get the 'HistoryEventText' element value. Description: History Event Text.
    				Constraints: Optional (Not Required).
    				
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getHistoryEventText() {
        return historyEventText;
    }

    /** 
     * Set the 'HistoryEventText' element value. Description: History Event Text.
    				Constraints: Optional (Not Required).
    				
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param historyEventText
     */
    public void setHistoryEventText(String historyEventText) {
        this.historyEventText = historyEventText;
    }

    /** 
     * Get the 'UpdateDate' element value. 
    					Description: This should be the update date in GMT of when the update request
    					was sent.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /** 
     * Set the 'UpdateDate' element value. 
    					Description: This should be the update date in GMT of when the update request
    					was sent.
    				Constraints: Required.
     * 
     * @param updateDate
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /** 
     * Get the 'Passenger' element value. Description: Passenger.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'Passenger' element value. Description: Passenger.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param passenger
     */
    public void setPassenger(String passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'Segment' element value. Description: Segment.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getSegment() {
        return segment;
    }

    /** 
     * Set the 'Segment' element value. Description: Segment.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param segment
     */
    public void setSegment(String segment) {
        this.segment = segment;
    }

    /** 
     * Get the 'Description' element value. Description: Description.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description: Description.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'User' element value. Description: User.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public String getUser() {
        return user;
    }

    /** 
     * Set the 'User' element value. Description: User.Constraints: Required.
    					Range: Length must be in the range 1 and 2147483647.
    				
     * 
     * @param user
     */
    public void setUser(String user) {
        this.user = user;
    }

    /** 
     * Get the 'ResChannel' element value. Description: ResChannel.Constraints: Required.
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public EnumerationsReservationChannelTypes getResChannel() {
        return resChannel;
    }

    /** 
     * Set the 'ResChannel' element value. Description: ResChannel.Constraints: Required.
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @param resChannel
     */
    public void setResChannel(EnumerationsReservationChannelTypes resChannel) {
        this.resChannel = resChannel;
    }

    /** 
     * Get the 'IPAddress' element value. 
    					Description: The value supplied in this property represent the Consumers IP
    					address. The connect point integrator will need to capture this
    					information from the browser object.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getIPAddress() {
        return IPAddress;
    }

    /** 
     * Set the 'IPAddress' element value. 
    					Description: The value supplied in this property represent the Consumers IP
    					address. The connect point integrator will need to capture this
    					information from the browser object.
    				Constraints: Required.
     * 
     * @param IPAddress
     */
    public void setIPAddress(String IPAddress) {
        this.IPAddress = IPAddress;
    }
}
