
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:int" name="PhysicalFlightID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeatSelected"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RowNumber"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Seat
{
    private int personOrgID;
    private int logicalFlightID;
    private int physicalFlightID;
    private Date departureDate;
    private String seatSelected;
    private String rowNumber;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The person org id created by the system that will be associated
    					with the SSR.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The person org id created by the system that will be associated
    					with the SSR.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: Logical Flight ID of the segment that the Seat will be tied too..
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: Logical Flight ID of the segment that the Seat will be tied too..
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'PhysicalFlightID' element value. 
    					Description: This is the physical flight id as identified in the fare quote
    					response for the flight.
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPhysicalFlightID() {
        return physicalFlightID;
    }

    /** 
     * Set the 'PhysicalFlightID' element value. 
    					Description: This is the physical flight id as identified in the fare quote
    					response for the flight.
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @param physicalFlightID
     */
    public void setPhysicalFlightID(int physicalFlightID) {
        this.physicalFlightID = physicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: Departure date (time should be specified as 00:00:00) of the
    					physical flight that the Seat will be tied to..
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: Departure date (time should be specified as 00:00:00) of the
    					physical flight that the Seat will be tied to..
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'SeatSelected' element value. 
    					Description: This represents the seat that is to be assigned.
    				Constraints: Required.Range: Length must be in the range 0 and 2.
    				
     * 
     * @return value
     */
    public String getSeatSelected() {
        return seatSelected;
    }

    /** 
     * Set the 'SeatSelected' element value. 
    					Description: This represents the seat that is to be assigned.
    				Constraints: Required.Range: Length must be in the range 0 and 2.
    				
     * 
     * @param seatSelected
     */
    public void setSeatSelected(String seatSelected) {
        this.seatSelected = seatSelected;
    }

    /** 
     * Get the 'RowNumber' element value. 
    					Description: This represents the row number that the seat is in.
    				Constraints: Required.Range: Length must be in the range 0 and 2.
    				
     * 
     * @return value
     */
    public String getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. 
    					Description: This represents the row number that the seat is in.
    				Constraints: Required.Range: Length must be in the range 0 and 2.
    				
     * 
     * @param rowNumber
     */
    public void setRowNumber(String rowNumber) {
        this.rowNumber = rowNumber;
    }
}
