
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:int" name="FareInformationID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MarketingCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="StoreFrontID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="ns:ArrayOfSpecialService" nillable="true" name="SpecialServices"/>
 *     &lt;xs:element type="ns:ArrayOfSeat" nillable="true" name="Seats"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Segment
{
    private int personOrgID;
    private int fareInformationID;
    private String marketingCode;
    private String storeFrontID;
    private String recordLocator;
    private ArrayOfSpecialService specialServices;
    private ArrayOfSeat seats;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'FareInformationID' element value. Description: .Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getFareInformationID() {
        return fareInformationID;
    }

    /** 
     * Set the 'FareInformationID' element value. Description: .Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param fareInformationID
     */
    public void setFareInformationID(int fareInformationID) {
        this.fareInformationID = fareInformationID;
    }

    /** 
     * Get the 'MarketingCode' element value. 
    					Description: This field contains the special marketing code that was used to
    					book this passenger segment..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getMarketingCode() {
        return marketingCode;
    }

    /** 
     * Set the 'MarketingCode' element value. 
    					Description: This field contains the special marketing code that was used to
    					book this passenger segment..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param marketingCode
     */
    public void setMarketingCode(String marketingCode) {
        this.marketingCode = marketingCode;
    }

    /** 
     * Get the 'StoreFrontID' element value. 
    					Description: In the event that an airline has multiple storefronts, this field
    					indicates the StoreFrontID that this booking was made under.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getStoreFrontID() {
        return storeFrontID;
    }

    /** 
     * Set the 'StoreFrontID' element value. 
    					Description: In the event that an airline has multiple storefronts, this field
    					indicates the StoreFrontID that this booking was made under.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param storeFrontID
     */
    public void setStoreFrontID(String storeFrontID) {
        this.storeFrontID = storeFrontID;
    }

    /** 
     * Get the 'RecordLocator' element value. 
    					Description: If this field is populated then the recordlocator passed in will
    					be populated in the reservation segment of the person that it is
    					passed under.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. 
    					Description: If this field is populated then the recordlocator passed in will
    					be populated in the reservation segment of the person that it is
    					passed under.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'SpecialServices' element value. Description: Collection of special services.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @return value
     */
    public ArrayOfSpecialService getSpecialServices() {
        return specialServices;
    }

    /** 
     * Set the 'SpecialServices' element value. Description: Collection of special services.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @param specialServices
     */
    public void setSpecialServices(ArrayOfSpecialService specialServices) {
        this.specialServices = specialServices;
    }

    /** 
     * Get the 'Seats' element value. Description: Collection of seats.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @return value
     */
    public ArrayOfSeat getSeats() {
        return seats;
    }

    /** 
     * Set the 'Seats' element value. Description: Collection of seats.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @param seats
     */
    public void setSeats(ArrayOfSeat seats) {
        this.seats = seats;
    }
}
