
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceToCancel">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="AirlineKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhysicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CustomerKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AirlinePersonKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ChargeKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Comment"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SpecialServiceToCancel
{
    private String airlineKey;
    private String logicalFlightKey;
    private String physicalFlightKey;
    private String customerKey;
    private String airlinePersonKey;
    private String chargeKey;
    private String comment;

    /** 
     * Get the 'AirlineKey' element value. 
    					Description: The value of the Key property on the Airline object that relates
    					to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAirlineKey() {
        return airlineKey;
    }

    /** 
     * Set the 'AirlineKey' element value. 
    					Description: The value of the Key property on the Airline object that relates
    					to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @param airlineKey
     */
    public void setAirlineKey(String airlineKey) {
        this.airlineKey = airlineKey;
    }

    /** 
     * Get the 'LogicalFlightKey' element value. 
    					Description: The value of the Key property on the Logical Flight object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLogicalFlightKey() {
        return logicalFlightKey;
    }

    /** 
     * Set the 'LogicalFlightKey' element value. 
    					Description: The value of the Key property on the Logical Flight object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @param logicalFlightKey
     */
    public void setLogicalFlightKey(String logicalFlightKey) {
        this.logicalFlightKey = logicalFlightKey;
    }

    /** 
     * Get the 'PhysicalFlightKey' element value. 
    					Description: The value of the Key property on the Physical Flight object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPhysicalFlightKey() {
        return physicalFlightKey;
    }

    /** 
     * Set the 'PhysicalFlightKey' element value. 
    					Description: The value of the Key property on the Physical Flight object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @param physicalFlightKey
     */
    public void setPhysicalFlightKey(String physicalFlightKey) {
        this.physicalFlightKey = physicalFlightKey;
    }

    /** 
     * Get the 'CustomerKey' element value. 
    					Description: The value of the Key property on the Customer object that relates
    					to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCustomerKey() {
        return customerKey;
    }

    /** 
     * Set the 'CustomerKey' element value. 
    					Description: The value of the Key property on the Customer object that relates
    					to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @param customerKey
     */
    public void setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
    }

    /** 
     * Get the 'AirlinePersonKey' element value. 
    					Description: The value of the Key property on the Airline Person object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAirlinePersonKey() {
        return airlinePersonKey;
    }

    /** 
     * Set the 'AirlinePersonKey' element value. 
    					Description: The value of the Key property on the Airline Person object that
    					relates to the charge object that needs to be cancelled.
    				Constraints: Required.
     * 
     * @param airlinePersonKey
     */
    public void setAirlinePersonKey(String airlinePersonKey) {
        this.airlinePersonKey = airlinePersonKey;
    }

    /** 
     * Get the 'ChargeKey' element value. 
    					Description: The value of the Key property on the charge object of the SSR
    					that is in need of cancellation.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getChargeKey() {
        return chargeKey;
    }

    /** 
     * Set the 'ChargeKey' element value. 
    					Description: The value of the Key property on the charge object of the SSR
    					that is in need of cancellation.
    				Constraints: Required.
     * 
     * @param chargeKey
     */
    public void setChargeKey(String chargeKey) {
        this.chargeKey = chargeKey;
    }

    /** 
     * Get the 'Comment' element value. 
    					Description: A comment pertaining to the reason that the consumer is wishing
    					to cancel the charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value. 
    					Description: A comment pertaining to the reason that the consumer is wishing
    					to cancel the charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }
}
