
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SummaryPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:SummaryPNR.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="SecurityToken"/>
 *         &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CarrierCurrency"/>
 *         &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="DisplayCurrency"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANum"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="User"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ReceiptLanguageID"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="PromoCode"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ExternalBookingID"/>
 *         &lt;xs:element type="ns1:Address" nillable="true" name="Address"/>
 *         &lt;xs:element type="ns1:ArrayOfContactInfo" nillable="true" name="ContactInfos"/>
 *         &lt;xs:element type="ns1:ArrayOfPerson" nillable="true" name="Passengers"/>
 *         &lt;xs:element type="ns1:ArrayOfSegment" nillable="true" name="Segments"/>
 *         &lt;xs:element type="ns1:ArrayOfPayment" nillable="true" name="Payments"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SummaryPNR extends TransactionInfo
{
    private SummaryPNRActionTypes actionType;
    private ReservationInfo reservationInfo;
    private String securityToken;
    private EnumerationsCurrencyCodeTypes carrierCurrency;
    private EnumerationsCurrencyCodeTypes displayCurrency;
    private String IATANum;
    private String user;
    private String receiptLanguageID;
    private String promoCode;
    private String externalBookingID;
    private Address address;
    private ArrayOfContactInfo contactInfos;
    private ArrayOfPerson passengers;
    private ArrayOfSegment segments;
    private ArrayOfPayment payments;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @return value
     */
    public SummaryPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(SummaryPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'SecurityToken' element value. 
    							Description: The security token that was returned in the
    							RetrieveSecurityToken call which initiates the session.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getSecurityToken() {
        return securityToken;
    }

    /** 
     * Set the 'SecurityToken' element value. 
    							Description: The security token that was returned in the
    							RetrieveSecurityToken call which initiates the session.
    						Constraints: Required.
     * 
     * @param securityToken
     */
    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    /** 
     * Get the 'CarrierCurrency' element value. 
    							Description: Primary Currency Code of the Marketing Carrier.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCarrierCurrency() {
        return carrierCurrency;
    }

    /** 
     * Set the 'CarrierCurrency' element value. 
    							Description: Primary Currency Code of the Marketing Carrier.
    						Constraints: Required.
     * 
     * @param carrierCurrency
     */
    public void setCarrierCurrency(EnumerationsCurrencyCodeTypes carrierCurrency) {
        this.carrierCurrency = carrierCurrency;
    }

    /** 
     * Get the 'DisplayCurrency' element value. 
    							Description: Currency Code of the that will be displayed on the user
    							interface.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getDisplayCurrency() {
        return displayCurrency;
    }

    /** 
     * Set the 'DisplayCurrency' element value. 
    							Description: Currency Code of the that will be displayed on the user
    							interface.
    						Constraints: Required.
     * 
     * @param displayCurrency
     */
    public void setDisplayCurrency(EnumerationsCurrencyCodeTypes displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    /** 
     * Get the 'IATANum' element value. 
    							Description: IATA Number of the requesting Travel Agency.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANum() {
        return IATANum;
    }

    /** 
     * Set the 'IATANum' element value. 
    							Description: IATA Number of the requesting Travel Agency.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 0 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANum
     */
    public void setIATANum(String IATANum) {
        this.IATANum = IATANum;
    }

    /** 
     * Get the 'User' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getUser() {
        return user;
    }

    /** 
     * Set the 'User' element value. Description: .Constraints: Optional (Not Required).
    						
     * 
     * @param user
     */
    public void setUser(String user) {
        this.user = user;
    }

    /** 
     * Get the 'ReceiptLanguageID' element value. 
    							Description: This value will be supplied by the client IT lead a the value
    							can be dynamic and change from carrier to carrier.
    						Constraints: Required.Range: Length must be in the range 1 and 1.
    						
     * 
     * @return value
     */
    public String getReceiptLanguageID() {
        return receiptLanguageID;
    }

    /** 
     * Set the 'ReceiptLanguageID' element value. 
    							Description: This value will be supplied by the client IT lead a the value
    							can be dynamic and change from carrier to carrier.
    						Constraints: Required.Range: Length must be in the range 1 and 1.
    						
     * 
     * @param receiptLanguageID
     */
    public void setReceiptLanguageID(String receiptLanguageID) {
        this.receiptLanguageID = receiptLanguageID;
    }

    /** 
     * Get the 'PromoCode' element value. 
    							Description: If carrier supports promotional codes then the value submitted
    							in this attribute will be used to verfify the promotion against
    							what was submitted in FareQuote request..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getPromoCode() {
        return promoCode;
    }

    /** 
     * Set the 'PromoCode' element value. 
    							Description: If carrier supports promotional codes then the value submitted
    							in this attribute will be used to verfify the promotion against
    							what was submitted in FareQuote request..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param promoCode
     */
    public void setPromoCode(String promoCode) {
        this.promoCode = promoCode;
    }

    /** 
     * Get the 'ExternalBookingID' element value. 
    							Description: If the PNR was originally imported from another system then
    							this value will contain the reference number from the
    							originating system.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getExternalBookingID() {
        return externalBookingID;
    }

    /** 
     * Set the 'ExternalBookingID' element value. 
    							Description: If the PNR was originally imported from another system then
    							this value will contain the reference number from the
    							originating system.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param externalBookingID
     */
    public void setExternalBookingID(String externalBookingID) {
        this.externalBookingID = externalBookingID;
    }

    /** 
     * Get the 'Address' element value. 
    							Description: Primary Address information used for the reservation contacts.
    						Constraints: Required.Range: Value must be in the range 1 and 1.
    						
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. 
    							Description: Primary Address information used for the reservation contacts.
    						Constraints: Required.Range: Value must be in the range 1 and 1.
    						
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'ContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfContactInfo getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfContactInfo contactInfos) {
        this.contactInfos = contactInfos;
    }

    /** 
     * Get the 'Passengers' element value. Description: Collection of Passengers.
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfPerson getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value. Description: Collection of Passengers.
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param passengers
     */
    public void setPassengers(ArrayOfPerson passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'Segments' element value. Description: Collection of Segments.
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfSegment getSegments() {
        return segments;
    }

    /** 
     * Set the 'Segments' element value. Description: Collection of Segments.
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param segments
     */
    public void setSegments(ArrayOfSegment segments) {
        this.segments = segments;
    }

    /** 
     * Get the 'Payments' element value. Description: Collection of Payments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfPayment getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Description: Collection of Payments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param payments
     */
    public void setPayments(ArrayOfPayment payments) {
        this.payments = payments;
    }
}
