
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:ns2="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewPNR">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BookingAgent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CRSCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TravelGroupID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATANumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ExternalAppID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="WebBookingID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PromotionalID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PromotionalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecieptLanguageID" minOccurs="0"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="ReservationCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:long" name="ProfileID" minOccurs="0"/>
 *     &lt;xs:element type="xs:long" name="PNRPin" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BookDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ReservationType" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TodaysDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LastModified" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ReservationExpirationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CorporationID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SecurityGuid" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="HasTickets" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ValuePackageData" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserIPAddress" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ManageBookingAgent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="HistoricConfirmationNum" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Cabin" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="ReservationBalance" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="ChangeFee" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightCount" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ActivePassengerCount" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="BalancedReservation" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ReservationFulfillmentRequiredByGMT" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ReservationFulfillmentRequiredByODT" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfAirline" nillable="true" name="Airlines" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfPayment" nillable="true" name="Payments" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfHistory" nillable="true" name="History" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfComment" nillable="true" name="Comments" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfGDSHistory" nillable="true" name="GDSHistory" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfReservationContact" nillable="true" name="ReservationContacts" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfContactInfo" nillable="true" name="ContactInfos" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfVoucher" nillable="true" name="Vouchers" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfCar" nillable="true" name="Cars" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfHotel" nillable="true" name="Hotels" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrayOfPackage" nillable="true" name="Packages" minOccurs="0"/>
 *     &lt;xs:element type="ns2:ExceptionInformation.Exceptions" nillable="true" name="Exceptions"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewPNR
{
    private String key;
    private String seriesNumber;
    private String confirmationNumber;
    private String bookingAgent;
    private String CRSCode;
    private Integer travelGroupID;
    private String IATANumber;
    private String externalAppID;
    private String webBookingID;
    private Integer promotionalID;
    private String promotionalCode;
    private Integer recieptLanguageID;
    private EnumerationsCurrencyCodeTypes reservationCurrency;
    private Long profileID;
    private Long PNRPin;
    private Date bookDate;
    private String reservationType;
    private Date todaysDate;
    private Date lastModified;
    private Date reservationExpirationDate;
    private String corporationID;
    private String securityGuid;
    private Boolean hasTickets;
    private String valuePackageData;
    private String userIPAddress;
    private String manageBookingAgent;
    private String historicConfirmationNum;
    private String cabin;
    private BigDecimal reservationBalance;
    private BigDecimal changeFee;
    private Integer logicalFlightCount;
    private Integer activePassengerCount;
    private Boolean balancedReservation;
    private Date reservationFulfillmentRequiredByGMT;
    private Date reservationFulfillmentRequiredByODT;
    private ArrayOfAirline airlines;
    private ArrayOfPayment1 payments;
    private ArrayOfHistory history;
    private ArrayOfComment comments;
    private ArrayOfGDSHistory GDSHistory;
    private ArrayOfReservationContact reservationContacts;
    private ArrayOfContactInfo1 contactInfos;
    private ArrayOfVoucher vouchers;
    private ArrayOfCar cars;
    private ArrayOfHotel hotels;
    private ArrayOfPackage packages;
    private ExceptionInformationExceptions exceptions;

    /** 
     * Get the 'Key' element value. Description: The object key for this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: The object key for this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'BookingAgent' element value. 
    					Description: The user ID of the person or the program that initially created
    					the reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getBookingAgent() {
        return bookingAgent;
    }

    /** 
     * Set the 'BookingAgent' element value. 
    					Description: The user ID of the person or the program that initially created
    					the reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bookingAgent
     */
    public void setBookingAgent(String bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    /** 
     * Get the 'CRSCode' element value. 
    					Description: The IATA Carrier code of the system that originated this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCRSCode() {
        return CRSCode;
    }

    /** 
     * Set the 'CRSCode' element value. 
    					Description: The IATA Carrier code of the system that originated this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param CRSCode
     */
    public void setCRSCode(String CRSCode) {
        this.CRSCode = CRSCode;
    }

    /** 
     * Get the 'TravelGroupID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTravelGroupID() {
        return travelGroupID;
    }

    /** 
     * Set the 'TravelGroupID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param travelGroupID
     */
    public void setTravelGroupID(Integer travelGroupID) {
        this.travelGroupID = travelGroupID;
    }

    /** 
     * Get the 'IATANumber' element value. 
    					Description: The IATA Number for the travel agency that originally created the
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    					Description: The IATA Number for the travel agency that originally created the
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'ExternalAppID' element value. 
    					Description: The External application ID for the travel agency that originally
    					created the booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getExternalAppID() {
        return externalAppID;
    }

    /** 
     * Set the 'ExternalAppID' element value. 
    					Description: The External application ID for the travel agency that originally
    					created the booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param externalAppID
     */
    public void setExternalAppID(String externalAppID) {
        this.externalAppID = externalAppID;
    }

    /** 
     * Get the 'WebBookingID' element value. 
    					Description: The ID for the session context used to create this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getWebBookingID() {
        return webBookingID;
    }

    /** 
     * Set the 'WebBookingID' element value. 
    					Description: The ID for the session context used to create this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param webBookingID
     */
    public void setWebBookingID(String webBookingID) {
        this.webBookingID = webBookingID;
    }

    /** 
     * Get the 'PromotionalID' element value. 
    					Description: The promotional ID code that was used, if any, to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPromotionalID() {
        return promotionalID;
    }

    /** 
     * Set the 'PromotionalID' element value. 
    					Description: The promotional ID code that was used, if any, to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param promotionalID
     */
    public void setPromotionalID(Integer promotionalID) {
        this.promotionalID = promotionalID;
    }

    /** 
     * Get the 'PromotionalCode' element value. 
    					Description: The promotional code that was used, if any, to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPromotionalCode() {
        return promotionalCode;
    }

    /** 
     * Set the 'PromotionalCode' element value. 
    					Description: The promotional code that was used, if any, to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param promotionalCode
     */
    public void setPromotionalCode(String promotionalCode) {
        this.promotionalCode = promotionalCode;
    }

    /** 
     * Get the 'RecieptLanguageID' element value. 
    					Description: The default language for the receipt on this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecieptLanguageID() {
        return recieptLanguageID;
    }

    /** 
     * Set the 'RecieptLanguageID' element value. 
    					Description: The default language for the receipt on this booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recieptLanguageID
     */
    public void setRecieptLanguageID(Integer recieptLanguageID) {
        this.recieptLanguageID = recieptLanguageID;
    }

    /** 
     * Get the 'ReservationCurrency' element value. 
    					Description: The Reservation Currency for this booking. The reservation
    					currency will dictate the currency for all fares on this
    					reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getReservationCurrency() {
        return reservationCurrency;
    }

    /** 
     * Set the 'ReservationCurrency' element value. 
    					Description: The Reservation Currency for this booking. The reservation
    					currency will dictate the currency for all fares on this
    					reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationCurrency
     */
    public void setReservationCurrency(
            EnumerationsCurrencyCodeTypes reservationCurrency) {
        this.reservationCurrency = reservationCurrency;
    }

    /** 
     * Get the 'ProfileID' element value. 
    					Description: The Radixx profile ID that is associated with this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Long getProfileID() {
        return profileID;
    }

    /** 
     * Set the 'ProfileID' element value. 
    					Description: The Radixx profile ID that is associated with this reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param profileID
     */
    public void setProfileID(Long profileID) {
        this.profileID = profileID;
    }

    /** 
     * Get the 'PNRPin' element value. 
    					Description: This identifyier is used on pay later bookings. It is given tothe
    					consumer so that they can use this number at a ATM.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Long getPNRPin() {
        return PNRPin;
    }

    /** 
     * Set the 'PNRPin' element value. 
    					Description: This identifyier is used on pay later bookings. It is given tothe
    					consumer so that they can use this number at a ATM.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param PNRPin
     */
    public void setPNRPin(Long PNRPin) {
        this.PNRPin = PNRPin;
    }

    /** 
     * Get the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getBookDate() {
        return bookDate;
    }

    /** 
     * Set the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bookDate
     */
    public void setBookDate(Date bookDate) {
        this.bookDate = bookDate;
    }

    /** 
     * Get the 'ReservationType' element value. Description: The type of reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getReservationType() {
        return reservationType;
    }

    /** 
     * Set the 'ReservationType' element value. Description: The type of reservation.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationType
     */
    public void setReservationType(String reservationType) {
        this.reservationType = reservationType;
    }

    /** 
     * Get the 'TodaysDate' element value. Description: The current system date.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getTodaysDate() {
        return todaysDate;
    }

    /** 
     * Set the 'TodaysDate' element value. Description: The current system date.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param todaysDate
     */
    public void setTodaysDate(Date todaysDate) {
        this.todaysDate = todaysDate;
    }

    /** 
     * Get the 'LastModified' element value. 
    					Description: The date which key information for this reservation was last
    					modified in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getLastModified() {
        return lastModified;
    }

    /** 
     * Set the 'LastModified' element value. 
    					Description: The date which key information for this reservation was last
    					modified in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param lastModified
     */
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /** 
     * Get the 'ReservationExpirationDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getReservationExpirationDate() {
        return reservationExpirationDate;
    }

    /** 
     * Set the 'ReservationExpirationDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param reservationExpirationDate
     */
    public void setReservationExpirationDate(Date reservationExpirationDate) {
        this.reservationExpirationDate = reservationExpirationDate;
    }

    /** 
     * Get the 'CorporationID' element value. 
    					Description: The unique identifier of the corporation associated with this
    					booking .
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCorporationID() {
        return corporationID;
    }

    /** 
     * Set the 'CorporationID' element value. 
    					Description: The unique identifier of the corporation associated with this
    					booking .
    				Constraints: Optional (Not Required).
    				
     * 
     * @param corporationID
     */
    public void setCorporationID(String corporationID) {
        this.corporationID = corporationID;
    }

    /** 
     * Get the 'SecurityGuid' element value. 
    					Description: The security GUID that was used to create this booking via the
    					Radixx.ConnectPoint.API.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSecurityGuid() {
        return securityGuid;
    }

    /** 
     * Set the 'SecurityGuid' element value. 
    					Description: The security GUID that was used to create this booking via the
    					Radixx.ConnectPoint.API.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param securityGuid
     */
    public void setSecurityGuid(String securityGuid) {
        this.securityGuid = securityGuid;
    }

    /** 
     * Get the 'HasTickets' element value. 
    					Description: Indicator showing whether or not this reservation has electronic
    					tickets.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getHasTickets() {
        return hasTickets;
    }

    /** 
     * Set the 'HasTickets' element value. 
    					Description: Indicator showing whether or not this reservation has electronic
    					tickets.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param hasTickets
     */
    public void setHasTickets(Boolean hasTickets) {
        this.hasTickets = hasTickets;
    }

    /** 
     * Get the 'ValuePackageData' element value. 
    					Description: Comments generated by booking a reservation via a value package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getValuePackageData() {
        return valuePackageData;
    }

    /** 
     * Set the 'ValuePackageData' element value. 
    					Description: Comments generated by booking a reservation via a value package.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param valuePackageData
     */
    public void setValuePackageData(String valuePackageData) {
        this.valuePackageData = valuePackageData;
    }

    /** 
     * Get the 'UserIPAddress' element value. 
    					Description: The Internet Protocol (IP) address that was used to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserIPAddress() {
        return userIPAddress;
    }

    /** 
     * Set the 'UserIPAddress' element value. 
    					Description: The Internet Protocol (IP) address that was used to create this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userIPAddress
     */
    public void setUserIPAddress(String userIPAddress) {
        this.userIPAddress = userIPAddress;
    }

    /** 
     * Get the 'ManageBookingAgent' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getManageBookingAgent() {
        return manageBookingAgent;
    }

    /** 
     * Set the 'ManageBookingAgent' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param manageBookingAgent
     */
    public void setManageBookingAgent(String manageBookingAgent) {
        this.manageBookingAgent = manageBookingAgent;
    }

    /** 
     * Get the 'HistoricConfirmationNum' element value. 
    					Description: If this booking was migrated from another system, this field is
    					the other system's confirmation number.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getHistoricConfirmationNum() {
        return historicConfirmationNum;
    }

    /** 
     * Set the 'HistoricConfirmationNum' element value. 
    					Description: If this booking was migrated from another system, this field is
    					the other system's confirmation number.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param historicConfirmationNum
     */
    public void setHistoricConfirmationNum(String historicConfirmationNum) {
        this.historicConfirmationNum = historicConfirmationNum;
    }

    /** 
     * Get the 'Cabin' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param cabin
     */
    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'ReservationBalance' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getReservationBalance() {
        return reservationBalance;
    }

    /** 
     * Set the 'ReservationBalance' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param reservationBalance
     */
    public void setReservationBalance(BigDecimal reservationBalance) {
        this.reservationBalance = reservationBalance;
    }

    /** 
     * Get the 'ChangeFee' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getChangeFee() {
        return changeFee;
    }

    /** 
     * Set the 'ChangeFee' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param changeFee
     */
    public void setChangeFee(BigDecimal changeFee) {
        this.changeFee = changeFee;
    }

    /** 
     * Get the 'LogicalFlightCount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getLogicalFlightCount() {
        return logicalFlightCount;
    }

    /** 
     * Set the 'LogicalFlightCount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightCount
     */
    public void setLogicalFlightCount(Integer logicalFlightCount) {
        this.logicalFlightCount = logicalFlightCount;
    }

    /** 
     * Get the 'ActivePassengerCount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getActivePassengerCount() {
        return activePassengerCount;
    }

    /** 
     * Set the 'ActivePassengerCount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param activePassengerCount
     */
    public void setActivePassengerCount(Integer activePassengerCount) {
        this.activePassengerCount = activePassengerCount;
    }

    /** 
     * Get the 'BalancedReservation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getBalancedReservation() {
        return balancedReservation;
    }

    /** 
     * Set the 'BalancedReservation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param balancedReservation
     */
    public void setBalancedReservation(Boolean balancedReservation) {
        this.balancedReservation = balancedReservation;
    }

    /** 
     * Get the 'ReservationFulfillmentRequiredByGMT' element value. 
    					Description: The value of this field indicates the date time that the
    					reservation must be fulfilled by in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getReservationFulfillmentRequiredByGMT() {
        return reservationFulfillmentRequiredByGMT;
    }

    /** 
     * Set the 'ReservationFulfillmentRequiredByGMT' element value. 
    					Description: The value of this field indicates the date time that the
    					reservation must be fulfilled by in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationFulfillmentRequiredByGMT
     */
    public void setReservationFulfillmentRequiredByGMT(
            Date reservationFulfillmentRequiredByGMT) {
        this.reservationFulfillmentRequiredByGMT = reservationFulfillmentRequiredByGMT;
    }

    /** 
     * Get the 'ReservationFulfillmentRequiredByODT' element value. 
    					Description: The value of this field indicates the date time that the
    					reservation must be fulfilled by in Originating Departure Airport
    					Time Zone.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getReservationFulfillmentRequiredByODT() {
        return reservationFulfillmentRequiredByODT;
    }

    /** 
     * Set the 'ReservationFulfillmentRequiredByODT' element value. 
    					Description: The value of this field indicates the date time that the
    					reservation must be fulfilled by in Originating Departure Airport
    					Time Zone.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationFulfillmentRequiredByODT
     */
    public void setReservationFulfillmentRequiredByODT(
            Date reservationFulfillmentRequiredByODT) {
        this.reservationFulfillmentRequiredByODT = reservationFulfillmentRequiredByODT;
    }

    /** 
     * Get the 'Airlines' element value. Description: Collection of Airlines.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfAirline getAirlines() {
        return airlines;
    }

    /** 
     * Set the 'Airlines' element value. Description: Collection of Airlines.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param airlines
     */
    public void setAirlines(ArrayOfAirline airlines) {
        this.airlines = airlines;
    }

    /** 
     * Get the 'Payments' element value. Description: Collection of Payments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfPayment1 getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Description: Collection of Payments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param payments
     */
    public void setPayments(ArrayOfPayment1 payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'History' element value. Description: Collection of History.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfHistory getHistory() {
        return history;
    }

    /** 
     * Set the 'History' element value. Description: Collection of History.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param history
     */
    public void setHistory(ArrayOfHistory history) {
        this.history = history;
    }

    /** 
     * Get the 'Comments' element value. Description: Collection of Comments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfComment getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. Description: Collection of Comments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param comments
     */
    public void setComments(ArrayOfComment comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'GDSHistory' element value. Description: Collection of GDS History.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfGDSHistory getGDSHistory() {
        return GDSHistory;
    }

    /** 
     * Set the 'GDSHistory' element value. Description: Collection of GDS History.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param GDSHistory
     */
    public void setGDSHistory(ArrayOfGDSHistory GDSHistory) {
        this.GDSHistory = GDSHistory;
    }

    /** 
     * Get the 'ReservationContacts' element value. Description: Collection of Reservation Contacts.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfReservationContact getReservationContacts() {
        return reservationContacts;
    }

    /** 
     * Set the 'ReservationContacts' element value. Description: Collection of Reservation Contacts.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationContacts
     */
    public void setReservationContacts(
            ArrayOfReservationContact reservationContacts) {
        this.reservationContacts = reservationContacts;
    }

    /** 
     * Get the 'ContactInfos' element value. Description: Collection of ContactInfo.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfContactInfo1 getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. Description: Collection of ContactInfo.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfContactInfo1 contactInfos) {
        this.contactInfos = contactInfos;
    }

    /** 
     * Get the 'Vouchers' element value. Description: Collection of Vouchers.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfVoucher getVouchers() {
        return vouchers;
    }

    /** 
     * Set the 'Vouchers' element value. Description: Collection of Vouchers.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param vouchers
     */
    public void setVouchers(ArrayOfVoucher vouchers) {
        this.vouchers = vouchers;
    }

    /** 
     * Get the 'Cars' element value. Description: Collection of Cars.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfCar getCars() {
        return cars;
    }

    /** 
     * Set the 'Cars' element value. Description: Collection of Cars.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cars
     */
    public void setCars(ArrayOfCar cars) {
        this.cars = cars;
    }

    /** 
     * Get the 'Hotels' element value. Description: Collection of Hotels.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfHotel getHotels() {
        return hotels;
    }

    /** 
     * Set the 'Hotels' element value. Description: Collection of Hotels.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param hotels
     */
    public void setHotels(ArrayOfHotel hotels) {
        this.hotels = hotels;
    }

    /** 
     * Get the 'Packages' element value. Description: Collection of Packages.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfPackage getPackages() {
        return packages;
    }

    /** 
     * Set the 'Packages' element value. Description: Collection of Packages.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param packages
     */
    public void setPackages(ArrayOfPackage packages) {
        this.packages = packages;
    }

    /** 
     * Get the 'Exceptions' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ExceptionInformationExceptions getExceptions() {
        return exceptions;
    }

    /** 
     * Set the 'Exceptions' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param exceptions
     */
    public void setExceptions(ExceptionInformationExceptions exceptions) {
        this.exceptions = exceptions;
    }
}
