
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="VoucherNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ReasonCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PersonOrgID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNum" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ChargeNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Sponsor" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="CreateDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="EffectiveDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpirationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="OriginalAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="BalanceAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserId" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="NonTransferable" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BatchProcessStart" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BatchProcessExtracted" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="VoucherType" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TripType" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IncludeTaxes" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IncludePenalty" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IncludeSSR" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IncludeAuto" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="IncludeHotel" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="STimeRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ETimeRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="SundayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="MondayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TuesdayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="WednesdayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ThursdayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="FridayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="SaturdayRestrict" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="VoucherNumFull" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="VoucherPW" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TravelEffectiveDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TravelExpirationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightsKey" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Voucher
{
    private String key;
    private Integer voucherNumber;
    private String currencyCode;
    private String reasonCode;
    private Integer personOrgID;
    private String seriesNum;
    private String confirmationNumber;
    private Integer recordNumber;
    private Integer chargeNumber;
    private String sponsor;
    private Date createDate;
    private Date effectiveDate;
    private Date expirationDate;
    private BigDecimal originalAmount;
    private BigDecimal balanceAmount;
    private String userId;
    private Integer nonTransferable;
    private Date batchProcessStart;
    private Integer batchProcessExtracted;
    private Integer voucherType;
    private Integer tripType;
    private Integer includeTaxes;
    private Integer includePenalty;
    private Integer includeSSR;
    private Integer includeAuto;
    private Integer includeHotel;
    private Date STimeRestrict;
    private Date ETimeRestrict;
    private Integer sundayRestrict;
    private Integer mondayRestrict;
    private Integer tuesdayRestrict;
    private Integer wednesdayRestrict;
    private Integer thursdayRestrict;
    private Integer fridayRestrict;
    private Integer saturdayRestrict;
    private String voucherNumFull;
    private String voucherPW;
    private String firstName;
    private String lastName;
    private Date travelEffectiveDate;
    private Date travelExpirationDate;
    private String logicalFlightsKey;

    /** 
     * Get the 'Key' element value. Description: Internal Object Key.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: Internal Object Key.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'VoucherNumber' element value. Description: The number for the voucher .
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getVoucherNumber() {
        return voucherNumber;
    }

    /** 
     * Set the 'VoucherNumber' element value. Description: The number for the voucher .
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherNumber
     */
    public void setVoucherNumber(Integer voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    /** 
     * Get the 'CurrencyCode' element value. 
    					Description: The currency code for the voucher amount.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. 
    					Description: The currency code for the voucher amount.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'ReasonCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getReasonCode() {
        return reasonCode;
    }

    /** 
     * Set the 'ReasonCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param reasonCode
     */
    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The PersonOrgID to whom the voucher was issued.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The PersonOrgID to whom the voucher was issued.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(Integer personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'SeriesNum' element value. 
    					Description: The Series Number for the reservation that was used to generate
    					the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSeriesNum() {
        return seriesNum;
    }

    /** 
     * Set the 'SeriesNum' element value. 
    					Description: The Series Number for the reservation that was used to generate
    					the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param seriesNum
     */
    public void setSeriesNum(String seriesNum) {
        this.seriesNum = seriesNum;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The Confirmation Number for the reservation that was used to
    					generate the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The Confirmation Number for the reservation that was used to
    					generate the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    					Description: The Record number for the passenger segment that was associated
    					to this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    					Description: The Record number for the passenger segment that was associated
    					to this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'ChargeNumber' element value. 
    					Description: The ResChargeID that is associated with this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getChargeNumber() {
        return chargeNumber;
    }

    /** 
     * Set the 'ChargeNumber' element value. 
    					Description: The ResChargeID that is associated with this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param chargeNumber
     */
    public void setChargeNumber(Integer chargeNumber) {
        this.chargeNumber = chargeNumber;
    }

    /** 
     * Get the 'Sponsor' element value. 
    					Description: The character expression that was entered as sponsor when the
    					voucher was created.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSponsor() {
        return sponsor;
    }

    /** 
     * Set the 'Sponsor' element value. 
    					Description: The character expression that was entered as sponsor when the
    					voucher was created.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param sponsor
     */
    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    /** 
     * Get the 'CreateDate' element value. 
    					Description: The date the voucher was created in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getCreateDate() {
        return createDate;
    }

    /** 
     * Set the 'CreateDate' element value. 
    					Description: The date the voucher was created in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param createDate
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /** 
     * Get the 'EffectiveDate' element value. 
    					Description: The effective date for the voucher in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. 
    					Description: The effective date for the voucher in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpirationDate' element value. 
    					Description: The date at with the voucher will expire in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. 
    					Description: The date at with the voucher will expire in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'OriginalAmount' element value. Description: The original amount for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. Description: The original amount for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'BalanceAmount' element value. 
    					Description: The amount left to be used on the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getBalanceAmount() {
        return balanceAmount;
    }

    /** 
     * Set the 'BalanceAmount' element value. 
    					Description: The amount left to be used on the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param balanceAmount
     */
    public void setBalanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    /** 
     * Get the 'UserId' element value. 
    					Description: The userID of the user or system that created the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserId() {
        return userId;
    }

    /** 
     * Set the 'UserId' element value. 
    					Description: The userID of the user or system that created the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userId
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /** 
     * Get the 'NonTransferable' element value. 
    					Description: Whether or not this voucher can be used by someone other than the
    					person specified in the PersonOrgID.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getNonTransferable() {
        return nonTransferable;
    }

    /** 
     * Set the 'NonTransferable' element value. 
    					Description: Whether or not this voucher can be used by someone other than the
    					person specified in the PersonOrgID.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nonTransferable
     */
    public void setNonTransferable(Integer nonTransferable) {
        this.nonTransferable = nonTransferable;
    }

    /** 
     * Get the 'BatchProcessStart' element value. 
    					Description: The date and time when the batch extract process started.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getBatchProcessStart() {
        return batchProcessStart;
    }

    /** 
     * Set the 'BatchProcessStart' element value. 
    					Description: The date and time when the batch extract process started.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param batchProcessStart
     */
    public void setBatchProcessStart(Date batchProcessStart) {
        this.batchProcessStart = batchProcessStart;
    }

    /** 
     * Get the 'BatchProcessExtracted' element value. 
    					Description: Whether or not this voucher was extracted.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBatchProcessExtracted() {
        return batchProcessExtracted;
    }

    /** 
     * Set the 'BatchProcessExtracted' element value. 
    					Description: Whether or not this voucher was extracted.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param batchProcessExtracted
     */
    public void setBatchProcessExtracted(Integer batchProcessExtracted) {
        this.batchProcessExtracted = batchProcessExtracted;
    }

    /** 
     * Get the 'VoucherType' element value. 
    					Description: Indicates whether this is a free flight or fixed amount voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getVoucherType() {
        return voucherType;
    }

    /** 
     * Set the 'VoucherType' element value. 
    					Description: Indicates whether this is a free flight or fixed amount voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherType
     */
    public void setVoucherType(Integer voucherType) {
        this.voucherType = voucherType;
    }

    /** 
     * Get the 'TripType' element value. 
    					Description: Whether or not this can be used to book a one way or round trip
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTripType() {
        return tripType;
    }

    /** 
     * Set the 'TripType' element value. 
    					Description: Whether or not this can be used to book a one way or round trip
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param tripType
     */
    public void setTripType(Integer tripType) {
        this.tripType = tripType;
    }

    /** 
     * Get the 'IncludeTaxes' element value. 
    					Description: Whether or not this voucher can be used to pay taxes.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIncludeTaxes() {
        return includeTaxes;
    }

    /** 
     * Set the 'IncludeTaxes' element value. 
    					Description: Whether or not this voucher can be used to pay taxes.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param includeTaxes
     */
    public void setIncludeTaxes(Integer includeTaxes) {
        this.includeTaxes = includeTaxes;
    }

    /** 
     * Get the 'IncludePenalty' element value. 
    					Description: Whether or not this voucher can be used to pay penalties.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIncludePenalty() {
        return includePenalty;
    }

    /** 
     * Set the 'IncludePenalty' element value. 
    					Description: Whether or not this voucher can be used to pay penalties.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param includePenalty
     */
    public void setIncludePenalty(Integer includePenalty) {
        this.includePenalty = includePenalty;
    }

    /** 
     * Get the 'IncludeSSR' element value. 
    					Description: Whether or not this voucher can be used to pay SSRs.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIncludeSSR() {
        return includeSSR;
    }

    /** 
     * Set the 'IncludeSSR' element value. 
    					Description: Whether or not this voucher can be used to pay SSRs.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param includeSSR
     */
    public void setIncludeSSR(Integer includeSSR) {
        this.includeSSR = includeSSR;
    }

    /** 
     * Get the 'IncludeAuto' element value. 
    					Description: Whether or not this voucher can be used to pay rental cars.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIncludeAuto() {
        return includeAuto;
    }

    /** 
     * Set the 'IncludeAuto' element value. 
    					Description: Whether or not this voucher can be used to pay rental cars.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param includeAuto
     */
    public void setIncludeAuto(Integer includeAuto) {
        this.includeAuto = includeAuto;
    }

    /** 
     * Get the 'IncludeHotel' element value. 
    					Description: Whether or not this voucher can be used to pay hotels.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getIncludeHotel() {
        return includeHotel;
    }

    /** 
     * Set the 'IncludeHotel' element value. 
    					Description: Whether or not this voucher can be used to pay hotels.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param includeHotel
     */
    public void setIncludeHotel(Integer includeHotel) {
        this.includeHotel = includeHotel;
    }

    /** 
     * Get the 'STimeRestrict' element value. 
    					Description: Start Time Restrictions for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getSTimeRestrict() {
        return STimeRestrict;
    }

    /** 
     * Set the 'STimeRestrict' element value. 
    					Description: Start Time Restrictions for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param STimeRestrict
     */
    public void setSTimeRestrict(Date STimeRestrict) {
        this.STimeRestrict = STimeRestrict;
    }

    /** 
     * Get the 'ETimeRestrict' element value. Description: End time Restriction for the
    					voucher.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getETimeRestrict() {
        return ETimeRestrict;
    }

    /** 
     * Set the 'ETimeRestrict' element value. Description: End time Restriction for the
    					voucher.Constraints: Optional (Not Required).
    				
     * 
     * @param ETimeRestrict
     */
    public void setETimeRestrict(Date ETimeRestrict) {
        this.ETimeRestrict = ETimeRestrict;
    }

    /** 
     * Get the 'SundayRestrict' element value. Description: Cannot use to book flights on
    					Sunday.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getSundayRestrict() {
        return sundayRestrict;
    }

    /** 
     * Set the 'SundayRestrict' element value. Description: Cannot use to book flights on
    					Sunday.Constraints: Optional (Not Required).
    				
     * 
     * @param sundayRestrict
     */
    public void setSundayRestrict(Integer sundayRestrict) {
        this.sundayRestrict = sundayRestrict;
    }

    /** 
     * Get the 'MondayRestrict' element value. Description: Cannot use to book flights on
    					Monday.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getMondayRestrict() {
        return mondayRestrict;
    }

    /** 
     * Set the 'MondayRestrict' element value. Description: Cannot use to book flights on
    					Monday.Constraints: Optional (Not Required).
    				
     * 
     * @param mondayRestrict
     */
    public void setMondayRestrict(Integer mondayRestrict) {
        this.mondayRestrict = mondayRestrict;
    }

    /** 
     * Get the 'TuesdayRestrict' element value. 
    					Description: Cannot use to book flights on Tuesday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTuesdayRestrict() {
        return tuesdayRestrict;
    }

    /** 
     * Set the 'TuesdayRestrict' element value. 
    					Description: Cannot use to book flights on Tuesday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param tuesdayRestrict
     */
    public void setTuesdayRestrict(Integer tuesdayRestrict) {
        this.tuesdayRestrict = tuesdayRestrict;
    }

    /** 
     * Get the 'WednesdayRestrict' element value. 
    					Description: Cannot use to book flights on Wednesday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getWednesdayRestrict() {
        return wednesdayRestrict;
    }

    /** 
     * Set the 'WednesdayRestrict' element value. 
    					Description: Cannot use to book flights on Wednesday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param wednesdayRestrict
     */
    public void setWednesdayRestrict(Integer wednesdayRestrict) {
        this.wednesdayRestrict = wednesdayRestrict;
    }

    /** 
     * Get the 'ThursdayRestrict' element value. 
    					Description: Cannot use to book flights on Thursday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getThursdayRestrict() {
        return thursdayRestrict;
    }

    /** 
     * Set the 'ThursdayRestrict' element value. 
    					Description: Cannot use to book flights on Thursday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param thursdayRestrict
     */
    public void setThursdayRestrict(Integer thursdayRestrict) {
        this.thursdayRestrict = thursdayRestrict;
    }

    /** 
     * Get the 'FridayRestrict' element value. Description: Cannot use to book flights on
    					Friday.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getFridayRestrict() {
        return fridayRestrict;
    }

    /** 
     * Set the 'FridayRestrict' element value. Description: Cannot use to book flights on
    					Friday.Constraints: Optional (Not Required).
    				
     * 
     * @param fridayRestrict
     */
    public void setFridayRestrict(Integer fridayRestrict) {
        this.fridayRestrict = fridayRestrict;
    }

    /** 
     * Get the 'SaturdayRestrict' element value. 
    					Description: Cannot use to book flights on Saturday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getSaturdayRestrict() {
        return saturdayRestrict;
    }

    /** 
     * Set the 'SaturdayRestrict' element value. 
    					Description: Cannot use to book flights on Saturday.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param saturdayRestrict
     */
    public void setSaturdayRestrict(Integer saturdayRestrict) {
        this.saturdayRestrict = saturdayRestrict;
    }

    /** 
     * Get the 'VoucherNumFull' element value. 
    					Description: The external voucher number that is given to a passeng.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getVoucherNumFull() {
        return voucherNumFull;
    }

    /** 
     * Set the 'VoucherNumFull' element value. 
    					Description: The external voucher number that is given to a passeng.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherNumFull
     */
    public void setVoucherNumFull(String voucherNumFull) {
        this.voucherNumFull = voucherNumFull;
    }

    /** 
     * Get the 'VoucherPW' element value. 
    					Description: The PIN code that a passenger must enter to redeem a voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getVoucherPW() {
        return voucherPW;
    }

    /** 
     * Set the 'VoucherPW' element value. 
    					Description: The PIN code that a passenger must enter to redeem a voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherPW
     */
    public void setVoucherPW(String voucherPW) {
        this.voucherPW = voucherPW;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The first name of the person issued the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The first name of the person issued the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The last name of the person issued the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The last name of the person issued the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'TravelEffectiveDate' element value. 
    					Description: The effect travels start date for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getTravelEffectiveDate() {
        return travelEffectiveDate;
    }

    /** 
     * Set the 'TravelEffectiveDate' element value. 
    					Description: The effect travels start date for the voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param travelEffectiveDate
     */
    public void setTravelEffectiveDate(Date travelEffectiveDate) {
        this.travelEffectiveDate = travelEffectiveDate;
    }

    /** 
     * Get the 'TravelExpirationDate' element value. 
    					Description: The effective travel end date for this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getTravelExpirationDate() {
        return travelExpirationDate;
    }

    /** 
     * Set the 'TravelExpirationDate' element value. 
    					Description: The effective travel end date for this voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param travelExpirationDate
     */
    public void setTravelExpirationDate(Date travelExpirationDate) {
        this.travelExpirationDate = travelExpirationDate;
    }

    /** 
     * Get the 'LogicalFlightsKey' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getLogicalFlightsKey() {
        return logicalFlightsKey;
    }

    /** 
     * Set the 'LogicalFlightsKey' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightsKey
     */
    public void setLogicalFlightsKey(String logicalFlightsKey) {
        this.logicalFlightsKey = logicalFlightsKey;
    }
}
