
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsAnswerTypes;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociateToReservation">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATA" minOccurs="0"/>
 *         &lt;xs:element type="ns1:Enumerations.AnswerTypes" name="Override" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociateToReservation extends TransactionInfo
{
    private String confirmationNumber;
    private String IATA;
    private EnumerationsAnswerTypes override;
    private String seriesNumber;

    /** 
     * Get the 'ConfirmationNumber' element value. Description: Confirmation Number.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. Description: Confirmation Number.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'IATA' element value. Description: IATA..Constraints: Required.
     * 
     * @return value
     */
    public String getIATA() {
        return IATA;
    }

    /** 
     * Set the 'IATA' element value. Description: IATA..Constraints: Required.
     * 
     * @param IATA
     */
    public void setIATA(String IATA) {
        this.IATA = IATA;
    }

    /** 
     * Get the 'Override' element value. Description: Override..Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsAnswerTypes getOverride() {
        return override;
    }

    /** 
     * Set the 'Override' element value. Description: Override..Constraints: Required.
     * 
     * @param override
     */
    public void setOverride(EnumerationsAnswerTypes override) {
        this.override = override;
    }

    /** 
     * Get the 'SeriesNumber' element value. Description: Series Number.Constraints: Required.Range: Length must be in the range 1 and 3.
    						
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. Description: Series Number.Constraints: Required.Range: Length must be in the range 1 and 3.
    						
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }
}
