
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreateAgency">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *     &lt;xs:element type="xs:boolean" name="ActionSuccessful"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AgencyName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AgencyStatus"/>
 *     &lt;xs:element type="ns:ExceptionInformation.Exceptions" nillable="true" name="Exceptions"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreateAgency1
{
    private String IATANumber;
    private boolean actionSuccessful;
    private String agencyName;
    private String agencyStatus;
    private ExceptionInformationExceptions exceptions;

    /** 
     * Get the 'IATANumber' element value. 
    					Description: The IATA Number for the travel agency.
    				Constraints: Required.Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    					Description: The IATA Number for the travel agency.
    				Constraints: Required.Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'ActionSuccessful' element value. Description: Transaction successful.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isActionSuccessful() {
        return actionSuccessful;
    }

    /** 
     * Set the 'ActionSuccessful' element value. Description: Transaction successful.
    				Constraints: Required.
     * 
     * @param actionSuccessful
     */
    public void setActionSuccessful(boolean actionSuccessful) {
        this.actionSuccessful = actionSuccessful;
    }

    /** 
     * Get the 'AgencyName' element value. Description: The Travel Agency Name.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyName() {
        return agencyName;
    }

    /** 
     * Set the 'AgencyName' element value. Description: The Travel Agency Name.
    				Constraints: Required.
     * 
     * @param agencyName
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    /** 
     * Get the 'AgencyStatus' element value. Description: The Travel Agency Status.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyStatus() {
        return agencyStatus;
    }

    /** 
     * Set the 'AgencyStatus' element value. Description: The Travel Agency Status.
    				Constraints: Required.
     * 
     * @param agencyStatus
     */
    public void setAgencyStatus(String agencyStatus) {
        this.agencyStatus = agencyStatus;
    }

    /** 
     * Get the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @return value
     */
    public ExceptionInformationExceptions getExceptions() {
        return exceptions;
    }

    /** 
     * Set the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @param exceptions
     */
    public void setExceptions(ExceptionInformationExceptions exceptions) {
        this.exceptions = exceptions;
    }
}
