
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreateAgent">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CreateAgent.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *         &lt;xs:element type="xs:int" name="Status"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentUsername"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentFirstName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentLastName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentAddress1"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentAddress2"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentCity"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentState"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentPostalCode"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCountry"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentEmail"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgentDefaultRole"/>
 *         &lt;xs:element type="ns:ArrayOfTAContactInfo" nillable="true" name="TaContactInfos"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LanguageCode"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreateAgent extends TransactionInfo
{
    private CreateAgentActionTypes actionType;
    private String IATANumber;
    private int status;
    private String agentUsername;
    private String agentFirstName;
    private String agentLastName;
    private String agentAddress1;
    private String agentAddress2;
    private String agentCity;
    private String agentState;
    private String agentPostalCode;
    private String agencyCountry;
    private String agentEmail;
    private String agentDefaultRole;
    private ArrayOfTAContactInfo taContactInfos;
    private String languageCode;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Action type indicating the option to add agent or modify.
    						Constraints: Required.
     * 
     * @return value
     */
    public CreateAgentActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Action type indicating the option to add agent or modify.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(CreateAgentActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agents agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agents agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'Status' element value. Description: Is the agent active.
    						Constraints: Required.
     * 
     * @return value
     */
    public int getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Description: Is the agent active.
    						Constraints: Required.
     * 
     * @param status
     */
    public void setStatus(int status) {
        this.status = status;
    }

    /** 
     * Get the 'AgentUsername' element value. Description: The Travel Agents username.
    						Constraints: Required.Range: Length must be in the range 1 and 15.
    						
     * 
     * @return value
     */
    public String getAgentUsername() {
        return agentUsername;
    }

    /** 
     * Set the 'AgentUsername' element value. Description: The Travel Agents username.
    						Constraints: Required.Range: Length must be in the range 1 and 15.
    						
     * 
     * @param agentUsername
     */
    public void setAgentUsername(String agentUsername) {
        this.agentUsername = agentUsername;
    }

    /** 
     * Get the 'AgentFirstName' element value. Description: The Travel Agents first name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAgentFirstName() {
        return agentFirstName;
    }

    /** 
     * Set the 'AgentFirstName' element value. Description: The Travel Agents first name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param agentFirstName
     */
    public void setAgentFirstName(String agentFirstName) {
        this.agentFirstName = agentFirstName;
    }

    /** 
     * Get the 'AgentLastName' element value. Description: The Travel Agents last name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAgentLastName() {
        return agentLastName;
    }

    /** 
     * Set the 'AgentLastName' element value. Description: The Travel Agents last name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param agentLastName
     */
    public void setAgentLastName(String agentLastName) {
        this.agentLastName = agentLastName;
    }

    /** 
     * Get the 'AgentAddress1' element value. Description: The Travel Agents address1.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @return value
     */
    public String getAgentAddress1() {
        return agentAddress1;
    }

    /** 
     * Set the 'AgentAddress1' element value. Description: The Travel Agents address1.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @param agentAddress1
     */
    public void setAgentAddress1(String agentAddress1) {
        this.agentAddress1 = agentAddress1;
    }

    /** 
     * Get the 'AgentAddress2' element value. Description: The Travel Agents address2.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @return value
     */
    public String getAgentAddress2() {
        return agentAddress2;
    }

    /** 
     * Set the 'AgentAddress2' element value. Description: The Travel Agents address2.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @param agentAddress2
     */
    public void setAgentAddress2(String agentAddress2) {
        this.agentAddress2 = agentAddress2;
    }

    /** 
     * Get the 'AgentCity' element value. Description: The Travel Agents city.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @return value
     */
    public String getAgentCity() {
        return agentCity;
    }

    /** 
     * Set the 'AgentCity' element value. Description: The Travel Agents city.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @param agentCity
     */
    public void setAgentCity(String agentCity) {
        this.agentCity = agentCity;
    }

    /** 
     * Get the 'AgentState' element value. Description: The Travel Agents state.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAgentState() {
        return agentState;
    }

    /** 
     * Set the 'AgentState' element value. Description: The Travel Agents state.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param agentState
     */
    public void setAgentState(String agentState) {
        this.agentState = agentState;
    }

    /** 
     * Get the 'AgentPostalCode' element value. Description: The Travel Agents post code.
    						Constraints: Required.Range: Length must be in the range 1 and 10.
    						
     * 
     * @return value
     */
    public String getAgentPostalCode() {
        return agentPostalCode;
    }

    /** 
     * Set the 'AgentPostalCode' element value. Description: The Travel Agents post code.
    						Constraints: Required.Range: Length must be in the range 1 and 10.
    						
     * 
     * @param agentPostalCode
     */
    public void setAgentPostalCode(String agentPostalCode) {
        this.agentPostalCode = agentPostalCode;
    }

    /** 
     * Get the 'AgencyCountry' element value. Description: The Travel Agency Country.
    						Constraints: Required.Range: Length must be in the range 1 and 30.
    						
     * 
     * @return value
     */
    public String getAgencyCountry() {
        return agencyCountry;
    }

    /** 
     * Set the 'AgencyCountry' element value. Description: The Travel Agency Country.
    						Constraints: Required.Range: Length must be in the range 1 and 30.
    						
     * 
     * @param agencyCountry
     */
    public void setAgencyCountry(String agencyCountry) {
        this.agencyCountry = agencyCountry;
    }

    /** 
     * Get the 'AgentEmail' element value. Description: The Travel Agents email.
    						Constraints: Required.Range: Length must be in the range 1 and 150.
    						
     * 
     * @return value
     */
    public String getAgentEmail() {
        return agentEmail;
    }

    /** 
     * Set the 'AgentEmail' element value. Description: The Travel Agents email.
    						Constraints: Required.Range: Length must be in the range 1 and 150.
    						
     * 
     * @param agentEmail
     */
    public void setAgentEmail(String agentEmail) {
        this.agentEmail = agentEmail;
    }

    /** 
     * Get the 'AgentDefaultRole' element value. Description: The Travel Agents default role.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getAgentDefaultRole() {
        return agentDefaultRole;
    }

    /** 
     * Set the 'AgentDefaultRole' element value. Description: The Travel Agents default role.
    						Constraints: Required.
     * 
     * @param agentDefaultRole
     */
    public void setAgentDefaultRole(String agentDefaultRole) {
        this.agentDefaultRole = agentDefaultRole;
    }

    /** 
     * Get the 'TaContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfTAContactInfo getTaContactInfos() {
        return taContactInfos;
    }

    /** 
     * Set the 'TaContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param taContactInfos
     */
    public void setTaContactInfos(ArrayOfTAContactInfo taContactInfos) {
        this.taContactInfos = taContactInfos;
    }

    /** 
     * Get the 'LanguageCode' element value. Description: The Travel Agency Name.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getLanguageCode() {
        return languageCode;
    }

    /** 
     * Set the 'LanguageCode' element value. Description: The Travel Agency Name.
    						Constraints: Required.
     * 
     * @param languageCode
     */
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }
}
