
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsStatusTypes;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyAgency">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyAdress1" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyAdress2" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCity" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyState" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCurrency" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LegalName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyPostalCode" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfTAContactInfo" nillable="true" name="TAContactInfos"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ContactName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountFirstName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountLastName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyWebSiteUrl" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="AgencyFetExempt" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrEmailReceipt" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="AgencyRegion" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrFaxReceipt" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrMailReceipt" minOccurs="0"/>
 *         &lt;xs:element type="ns1:Enumerations.StatusTypes" name="AgencyStatus"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyAgency extends TransactionInfo
{
    private String IATANumber;
    private String agencyName;
    private String agencyAdress1;
    private String agencyAdress2;
    private String agencyCity;
    private String agencyState;
    private String agencyCurrency;
    private String legalName;
    private String agencyPostalCode;
    private ArrayOfTAContactInfo TAContactInfos;
    private String contactName;
    private String accountFirstName;
    private String accountLastName;
    private String agencyWebSiteUrl;
    private Boolean agencyFetExempt;
    private Boolean preferrEmailReceipt;
    private Integer agencyRegion;
    private Boolean preferrFaxReceipt;
    private Boolean preferrMailReceipt;
    private EnumerationsStatusTypes agencyStatus;

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'AgencyName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 20.
    						
     * 
     * @return value
     */
    public String getAgencyName() {
        return agencyName;
    }

    /** 
     * Set the 'AgencyName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 20.
    						
     * 
     * @param agencyName
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    /** 
     * Get the 'AgencyAdress1' element value. Description: The Travel Agency Address1.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyAdress1() {
        return agencyAdress1;
    }

    /** 
     * Set the 'AgencyAdress1' element value. Description: The Travel Agency Address1.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyAdress1
     */
    public void setAgencyAdress1(String agencyAdress1) {
        this.agencyAdress1 = agencyAdress1;
    }

    /** 
     * Get the 'AgencyAdress2' element value. Description: The Travel Agency Address2.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyAdress2() {
        return agencyAdress2;
    }

    /** 
     * Set the 'AgencyAdress2' element value. Description: The Travel Agency Address2.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyAdress2
     */
    public void setAgencyAdress2(String agencyAdress2) {
        this.agencyAdress2 = agencyAdress2;
    }

    /** 
     * Get the 'AgencyCity' element value. Description: The Travel Agency City.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyCity() {
        return agencyCity;
    }

    /** 
     * Set the 'AgencyCity' element value. Description: The Travel Agency City.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyCity
     */
    public void setAgencyCity(String agencyCity) {
        this.agencyCity = agencyCity;
    }

    /** 
     * Get the 'AgencyState' element value. Description: The Travel Agency State.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyState() {
        return agencyState;
    }

    /** 
     * Set the 'AgencyState' element value. Description: The Travel Agency State.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyState
     */
    public void setAgencyState(String agencyState) {
        this.agencyState = agencyState;
    }

    /** 
     * Get the 'AgencyCurrency' element value. Description: The Travel Agency Currency.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyCurrency() {
        return agencyCurrency;
    }

    /** 
     * Set the 'AgencyCurrency' element value. Description: The Travel Agency Currency.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyCurrency
     */
    public void setAgencyCurrency(String agencyCurrency) {
        this.agencyCurrency = agencyCurrency;
    }

    /** 
     * Get the 'LegalName' element value. Description: The Travel Agency Lagel name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getLegalName() {
        return legalName;
    }

    /** 
     * Set the 'LegalName' element value. Description: The Travel Agency Lagel name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param legalName
     */
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    /** 
     * Get the 'AgencyPostalCode' element value. Description: The Travel Agency post code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyPostalCode() {
        return agencyPostalCode;
    }

    /** 
     * Set the 'AgencyPostalCode' element value. Description: The Travel Agency post code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyPostalCode
     */
    public void setAgencyPostalCode(String agencyPostalCode) {
        this.agencyPostalCode = agencyPostalCode;
    }

    /** 
     * Get the 'TAContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfTAContactInfo getTAContactInfos() {
        return TAContactInfos;
    }

    /** 
     * Set the 'TAContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param TAContactInfos
     */
    public void setTAContactInfos(ArrayOfTAContactInfo TAContactInfos) {
        this.TAContactInfos = TAContactInfos;
    }

    /** 
     * Get the 'ContactName' element value. Description: The Travel Agency contact name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. Description: The Travel Agency contact name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param contactName
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'AccountFirstName' element value. Description: The Travel Agency Name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAccountFirstName() {
        return accountFirstName;
    }

    /** 
     * Set the 'AccountFirstName' element value. Description: The Travel Agency Name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param accountFirstName
     */
    public void setAccountFirstName(String accountFirstName) {
        this.accountFirstName = accountFirstName;
    }

    /** 
     * Get the 'AccountLastName' element value. Description: The Travel Agency Name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAccountLastName() {
        return accountLastName;
    }

    /** 
     * Set the 'AccountLastName' element value. Description: The Travel Agency Name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param accountLastName
     */
    public void setAccountLastName(String accountLastName) {
        this.accountLastName = accountLastName;
    }

    /** 
     * Get the 'AgencyWebSiteUrl' element value. Description: The Travel Agency website url.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getAgencyWebSiteUrl() {
        return agencyWebSiteUrl;
    }

    /** 
     * Set the 'AgencyWebSiteUrl' element value. Description: The Travel Agency website url.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyWebSiteUrl
     */
    public void setAgencyWebSiteUrl(String agencyWebSiteUrl) {
        this.agencyWebSiteUrl = agencyWebSiteUrl;
    }

    /** 
     * Get the 'AgencyFetExempt' element value. Description: Travel Agency FetExempt.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getAgencyFetExempt() {
        return agencyFetExempt;
    }

    /** 
     * Set the 'AgencyFetExempt' element value. Description: Travel Agency FetExempt.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyFetExempt
     */
    public void setAgencyFetExempt(Boolean agencyFetExempt) {
        this.agencyFetExempt = agencyFetExempt;
    }

    /** 
     * Get the 'PreferrEmailReceipt' element value. Description: Travel Agency Preferr email
    							receipt.Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getPreferrEmailReceipt() {
        return preferrEmailReceipt;
    }

    /** 
     * Set the 'PreferrEmailReceipt' element value. Description: Travel Agency Preferr email
    							receipt.Constraints: Optional (Not Required).
    						
     * 
     * @param preferrEmailReceipt
     */
    public void setPreferrEmailReceipt(Boolean preferrEmailReceipt) {
        this.preferrEmailReceipt = preferrEmailReceipt;
    }

    /** 
     * Get the 'AgencyRegion' element value. Description: Travel Agency Region.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getAgencyRegion() {
        return agencyRegion;
    }

    /** 
     * Set the 'AgencyRegion' element value. Description: Travel Agency Region.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param agencyRegion
     */
    public void setAgencyRegion(Integer agencyRegion) {
        this.agencyRegion = agencyRegion;
    }

    /** 
     * Get the 'PreferrFaxReceipt' element value. Description: Travel Agency Preferr fax receipt.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getPreferrFaxReceipt() {
        return preferrFaxReceipt;
    }

    /** 
     * Set the 'PreferrFaxReceipt' element value. Description: Travel Agency Preferr fax receipt.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param preferrFaxReceipt
     */
    public void setPreferrFaxReceipt(Boolean preferrFaxReceipt) {
        this.preferrFaxReceipt = preferrFaxReceipt;
    }

    /** 
     * Get the 'PreferrMailReceipt' element value. Description: Travel Agency Preferr mail
    							receipt.Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getPreferrMailReceipt() {
        return preferrMailReceipt;
    }

    /** 
     * Set the 'PreferrMailReceipt' element value. Description: Travel Agency Preferr mail
    							receipt.Constraints: Optional (Not Required).
    						
     * 
     * @param preferrMailReceipt
     */
    public void setPreferrMailReceipt(Boolean preferrMailReceipt) {
        this.preferrMailReceipt = preferrMailReceipt;
    }

    /** 
     * Get the 'AgencyStatus' element value. Description: Agency status.Constraints: Required.Range: Value must be in the range 0 and 1.
    						Format: Number.
     * 
     * @return value
     */
    public EnumerationsStatusTypes getAgencyStatus() {
        return agencyStatus;
    }

    /** 
     * Set the 'AgencyStatus' element value. Description: Agency status.Constraints: Required.Range: Value must be in the range 0 and 1.
    						Format: Number.
     * 
     * @param agencyStatus
     */
    public void setAgencyStatus(EnumerationsStatusTypes agencyStatus) {
        this.agencyStatus = agencyStatus;
    }
}
