
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.ArrayOfEnumerationsSegmentStatus;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveAgencyIncentiveReport">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCode" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfChargeCode" nillable="true" name="ChargeCodes" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="DepartureEndDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="DepartureStartDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="EmailId" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="PaymentEndDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="PaymentStartDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ReportType" minOccurs="0"/>
 *         &lt;xs:element type="ns1:ArrayOfEnumerations.SegmentStatus" nillable="true" name="SegmentStatus" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveAgencyIncentiveReport extends TransactionInfo
{
    private String agencyCode;
    private ArrayOfChargeCode chargeCodes;
    private Date departureEndDate;
    private Date departureStartDate;
    private String emailId;
    private Date paymentEndDate;
    private Date paymentStartDate;
    private String reportType;
    private ArrayOfEnumerationsSegmentStatus segmentStatus;

    /** 
     * Get the 'AgencyCode' element value. Description: AgencyCode..Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyCode() {
        return agencyCode;
    }

    /** 
     * Set the 'AgencyCode' element value. Description: AgencyCode..Constraints: Required.
     * 
     * @param agencyCode
     */
    public void setAgencyCode(String agencyCode) {
        this.agencyCode = agencyCode;
    }

    /** 
     * Get the 'ChargeCodes' element value. Description: ChargeCodeType..
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfChargeCode getChargeCodes() {
        return chargeCodes;
    }

    /** 
     * Set the 'ChargeCodes' element value. Description: ChargeCodeType..
    						Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param chargeCodes
     */
    public void setChargeCodes(ArrayOfChargeCode chargeCodes) {
        this.chargeCodes = chargeCodes;
    }

    /** 
     * Get the 'DepartureEndDate' element value. Description: DepartureEndDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getDepartureEndDate() {
        return departureEndDate;
    }

    /** 
     * Set the 'DepartureEndDate' element value. Description: DepartureEndDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param departureEndDate
     */
    public void setDepartureEndDate(Date departureEndDate) {
        this.departureEndDate = departureEndDate;
    }

    /** 
     * Get the 'DepartureStartDate' element value. Description: DepartureStartDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getDepartureStartDate() {
        return departureStartDate;
    }

    /** 
     * Set the 'DepartureStartDate' element value. Description: DepartureStartDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param departureStartDate
     */
    public void setDepartureStartDate(Date departureStartDate) {
        this.departureStartDate = departureStartDate;
    }

    /** 
     * Get the 'EmailId' element value. Description: Email id..Constraints: Required.Range: Length must be in the range 1 and 100.
    						Format: Email.
     * 
     * @return value
     */
    public String getEmailId() {
        return emailId;
    }

    /** 
     * Set the 'EmailId' element value. Description: Email id..Constraints: Required.Range: Length must be in the range 1 and 100.
    						Format: Email.
     * 
     * @param emailId
     */
    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    /** 
     * Get the 'PaymentEndDate' element value. Description: PaymentEndDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getPaymentEndDate() {
        return paymentEndDate;
    }

    /** 
     * Set the 'PaymentEndDate' element value. Description: PaymentEndDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param paymentEndDate
     */
    public void setPaymentEndDate(Date paymentEndDate) {
        this.paymentEndDate = paymentEndDate;
    }

    /** 
     * Get the 'PaymentStartDate' element value. Description: PaymentStartDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getPaymentStartDate() {
        return paymentStartDate;
    }

    /** 
     * Set the 'PaymentStartDate' element value. Description: PaymentStartDate..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param paymentStartDate
     */
    public void setPaymentStartDate(Date paymentStartDate) {
        this.paymentStartDate = paymentStartDate;
    }

    /** 
     * Get the 'ReportType' element value. Description: ReportType..Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getReportType() {
        return reportType;
    }

    /** 
     * Set the 'ReportType' element value. Description: ReportType..Constraints: Optional (Not Required).
    						
     * 
     * @param reportType
     */
    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    /** 
     * Get the 'SegmentStatus' element value. Description: SegmentStatus..Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfEnumerationsSegmentStatus getSegmentStatus() {
        return segmentStatus;
    }

    /** 
     * Set the 'SegmentStatus' element value. Description: SegmentStatus..Constraints: Required.
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param segmentStatus
     */
    public void setSegmentStatus(ArrayOfEnumerationsSegmentStatus segmentStatus) {
        this.segmentStatus = segmentStatus;
    }
}
