
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveAgencyList">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="IncludeChildAgents" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveAgencyList extends TransactionInfo
{
    private String IATANumber;
    private Boolean includeChildAgents;

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'IncludeChildAgents' element value. 
    						Constraints: Required.
     * 
     * @return value
     */
    public Boolean getIncludeChildAgents() {
        return includeChildAgents;
    }

    /** 
     * Set the 'IncludeChildAgents' element value. 
    						Constraints: Required.
     * 
     * @param includeChildAgents
     */
    public void setIncludeChildAgents(Boolean includeChildAgents) {
        this.includeChildAgents = includeChildAgents;
    }
}
