
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveAgencyPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:RetrieveAgencyPNR.ActionTypes" name="ActionType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="BookingReferenceNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" nillable="true" name="DepartureDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="Email" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FirstName" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="IncludeChildAgencies" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LastName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="PaymentReferenceNumber" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveAgencyPNR extends TransactionInfo
{
    private RetrieveAgencyPNRActionTypes actionType;
    private String bookingReferenceNumber;
    private Date departureDate;
    private String email;
    private String firstName;
    private Boolean includeChildAgencies;
    private String lastName;
    private String paymentReferenceNumber;

    /** 
     * Get the 'ActionType' element value. Description: The action you want to perform.
    						Constraints: Required.
     * 
     * @return value
     */
    public RetrieveAgencyPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. Description: The action you want to perform.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(RetrieveAgencyPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'BookingReferenceNumber' element value. Description: Booking Reference Number.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 10.
    						
     * 
     * @return value
     */
    public String getBookingReferenceNumber() {
        return bookingReferenceNumber;
    }

    /** 
     * Set the 'BookingReferenceNumber' element value. Description: Booking Reference Number.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 10.
    						
     * 
     * @param bookingReferenceNumber
     */
    public void setBookingReferenceNumber(String bookingReferenceNumber) {
        this.bookingReferenceNumber = bookingReferenceNumber;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: Departure date.Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: Departure date.Constraints: Optional (Not Required).
    						
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Email' element value. Description: Email.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 255.
    						Format: Email.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. Description: Email.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 255.
    						Format: Email.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'FirstName' element value. Description: First Name.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: First Name.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 64.
    						
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'IncludeChildAgencies' element value. Description: Include child agencies.
    						Constraints: Required.
     * 
     * @return value
     */
    public Boolean getIncludeChildAgencies() {
        return includeChildAgencies;
    }

    /** 
     * Set the 'IncludeChildAgencies' element value. Description: Include child agencies.
    						Constraints: Required.
     * 
     * @param includeChildAgencies
     */
    public void setIncludeChildAgencies(Boolean includeChildAgencies) {
        this.includeChildAgencies = includeChildAgencies;
    }

    /** 
     * Get the 'LastName' element value. Description: Last Name.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: Last Name.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 64.
    						
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'PaymentReferenceNumber' element value. Description: Payment reference number.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 10.
    						
     * 
     * @return value
     */
    public String getPaymentReferenceNumber() {
        return paymentReferenceNumber;
    }

    /** 
     * Set the 'PaymentReferenceNumber' element value. Description: Payment reference number.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 10.
    						
     * 
     * @param paymentReferenceNumber
     */
    public void setPaymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
    }
}
