
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveAvailableCredit">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveAvailableCredit extends TransactionInfo
{
    private String IATANumber;

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency that originally created
    							the booking.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency that originally created
    							the booking.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }
}
