
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsAnswerTypes;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveCreditLimitHistory">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:decimal" nillable="true" name="Amount" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber" minOccurs="0"/>
 *         &lt;xs:element type="ns1:Enumerations.AnswerTypes" name="IncludeChildAgent" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="ReportDateFrom" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="ReportDateTo" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveCreditLimitHistory extends TransactionInfo
{
    private BigDecimal amount;
    private String IATANumber;
    private EnumerationsAnswerTypes includeChildAgent;
    private Date reportDateFrom;
    private Date reportDateTo;

    /** 
     * Get the 'Amount' element value. Description: Amount.Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: Amount.Constraints: Optional (Not Required).
    						
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'IATANumber' element value. Description: IATANumber.Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. Description: IATANumber.Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'IncludeChildAgent' element value. Description: Include child agents..
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsAnswerTypes getIncludeChildAgent() {
        return includeChildAgent;
    }

    /** 
     * Set the 'IncludeChildAgent' element value. Description: Include child agents..
    						Constraints: Required.
     * 
     * @param includeChildAgent
     */
    public void setIncludeChildAgent(EnumerationsAnswerTypes includeChildAgent) {
        this.includeChildAgent = includeChildAgent;
    }

    /** 
     * Get the 'ReportDateFrom' element value. Description: Date from..Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getReportDateFrom() {
        return reportDateFrom;
    }

    /** 
     * Set the 'ReportDateFrom' element value. Description: Date from..Constraints: Optional (Not Required).
    						
     * 
     * @param reportDateFrom
     */
    public void setReportDateFrom(Date reportDateFrom) {
        this.reportDateFrom = reportDateFrom;
    }

    /** 
     * Get the 'ReportDateTo' element value. Description: Date to..Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getReportDateTo() {
        return reportDateTo;
    }

    /** 
     * Set the 'ReportDateTo' element value. Description: Date to..Constraints: Optional (Not Required).
    						
     * 
     * @param reportDateTo
     */
    public void setReportDateTo(Date reportDateTo) {
        this.reportDateTo = reportDateTo;
    }
}
