
package org.datacontract.schemas.radixx.connectpoint.travelagents;

/** 
 * 
 <summary> Enumerated types indicating whether to search by all
 travel agency bookings or booking by a single travel agent </summary>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveTravelAgencyPNRList.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="RetrieveTravelAgentBookings"/>
 *     &lt;xs:enumeration value="RetrieveTravelAgencyBookings"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RetrieveTravelAgencyPNRListActionTypes {
    RETRIEVE_TRAVEL_AGENT_BOOKINGS("RetrieveTravelAgentBookings"), RETRIEVE_TRAVEL_AGENCY_BOOKINGS(
            "RetrieveTravelAgencyBookings");
    private final String value;

    private RetrieveTravelAgencyPNRListActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RetrieveTravelAgencyPNRListActionTypes convert(String value) {
        for (RetrieveTravelAgencyPNRListActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
