
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TopUpDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="Credit_Amt" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Credit_Currency" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Deposit_Nfn_Num" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATA" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TopUpDetails
{
    private BigDecimal creditAmt;
    private String creditCurrency;
    private String depositNfnNum;
    private String description;
    private String IATA;

    /** 
     * Get the 'Credit_Amt' element value. 
    				Constraints: Required.
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public BigDecimal getCreditAmt() {
        return creditAmt;
    }

    /** 
     * Set the 'Credit_Amt' element value. 
    				Constraints: Required.
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @param creditAmt
     */
    public void setCreditAmt(BigDecimal creditAmt) {
        this.creditAmt = creditAmt;
    }

    /** 
     * Get the 'Credit_Currency' element value. Description: Currency transaction.
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				
     * 
     * @return value
     */
    public String getCreditCurrency() {
        return creditCurrency;
    }

    /** 
     * Set the 'Credit_Currency' element value. Description: Currency transaction.
    				Constraints: Required.Range: Length must be in the range 1 and 3.
    				
     * 
     * @param creditCurrency
     */
    public void setCreditCurrency(String creditCurrency) {
        this.creditCurrency = creditCurrency;
    }

    /** 
     * Get the 'Deposit_Nfn_Num' element value. Description: Desposit number..Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getDepositNfnNum() {
        return depositNfnNum;
    }

    /** 
     * Set the 'Deposit_Nfn_Num' element value. Description: Desposit number..Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @param depositNfnNum
     */
    public void setDepositNfnNum(String depositNfnNum) {
        this.depositNfnNum = depositNfnNum;
    }

    /** 
     * Get the 'Description' element value. Description: Description.Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description: Description.Constraints: Required.Range: Length must be in the range 1 and 255.
    				
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'IATA' element value. Description: IATA..Constraints: Required.Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @return value
     */
    public String getIATA() {
        return IATA;
    }

    /** 
     * Set the 'IATA' element value. Description: IATA..Constraints: Required.Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @param IATA
     */
    public void setIATA(String IATA) {
        this.IATA = IATA;
    }
}
