
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPNRStatus;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewBookingHistory">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:int" name="PassengerCount"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RouteFrom"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RouteTo"/>
 *     &lt;xs:element type="xs:dateTime" name="BookDateGMT"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BookingAgent"/>
 *     &lt;xs:element type="ns:Enumerations.PNRStatus" name="BookingType"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewBookingHistory
{
    private String seriesNumber;
    private String confirmationNumber;
    private String firstName;
    private String lastName;
    private String title;
    private int passengerCount;
    private String routeFrom;
    private String routeTo;
    private Date bookDateGMT;
    private Date departureDate;
    private String bookingAgent;
    private EnumerationsPNRStatus bookingType;

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'Title' element value. Description: Title of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. Description: Title of the primary passenger.
    				Constraints: Required.
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'PassengerCount' element value. Description: Number of active Passengers in PNR.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getPassengerCount() {
        return passengerCount;
    }

    /** 
     * Set the 'PassengerCount' element value. Description: Number of active Passengers in PNR.
    				Constraints: Required.
     * 
     * @param passengerCount
     */
    public void setPassengerCount(int passengerCount) {
        this.passengerCount = passengerCount;
    }

    /** 
     * Get the 'RouteFrom' element value. 
    					Description: Route from for the booking, city code.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getRouteFrom() {
        return routeFrom;
    }

    /** 
     * Set the 'RouteFrom' element value. 
    					Description: Route from for the booking, city code.
    				Constraints: Required.
     * 
     * @param routeFrom
     */
    public void setRouteFrom(String routeFrom) {
        this.routeFrom = routeFrom;
    }

    /** 
     * Get the 'RouteTo' element value. Description: Route to for the booking, city code.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getRouteTo() {
        return routeTo;
    }

    /** 
     * Set the 'RouteTo' element value. Description: Route to for the booking, city code.
    				Constraints: Required.
     * 
     * @param routeTo
     */
    public void setRouteTo(String routeTo) {
        this.routeTo = routeTo;
    }

    /** 
     * Get the 'BookDateGMT' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getBookDateGMT() {
        return bookDateGMT;
    }

    /** 
     * Set the 'BookDateGMT' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @param bookDateGMT
     */
    public void setBookDateGMT(Date bookDateGMT) {
        this.bookDateGMT = bookDateGMT;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: Departure date.Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: Departure date.Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'BookingAgent' element value. Description: Booking creator Agent ID.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getBookingAgent() {
        return bookingAgent;
    }

    /** 
     * Set the 'BookingAgent' element value. Description: Booking creator Agent ID.
    				Constraints: Required.
     * 
     * @param bookingAgent
     */
    public void setBookingAgent(String bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    /** 
     * Get the 'BookingType' element value. Description: All Bookings, Confirmed,
    					Payment,....Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsPNRStatus getBookingType() {
        return bookingType;
    }

    /** 
     * Set the 'BookingType' element value. Description: All Bookings, Confirmed,
    					Payment,....Constraints: Optional (Not Required).
    				
     * 
     * @param bookingType
     */
    public void setBookingType(EnumerationsPNRStatus bookingType) {
        this.bookingType = bookingType;
    }
}
