/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CarrierCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CarrierFlightType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ConnectionCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FlightCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.IATAPayloadStandardAttributesType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.LocationCodeType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ObjectNameCodeType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PayloadRestrictionsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PrefLevelType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PreferenceFilterRE;
import https.www_mixvel_com.api.xsd.mixvel._1_01.SelectionsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingRequestCabinTypeType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.PaxType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.RequestType;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MixvelAirShoppingRQHelper {
    public static String getCabinTypeCode(ClassOfService classOfService) {
        if (classOfService == null) {
            return null;
        }
        switch (classOfService) {
            case ECONOMY: {
                return "Economy";
            }
            case PREMIUM: {
                return "Premium Economy";
            }
            case BUSINESS: 
            case PREMIUM_BUSINESS: {
                return "Business";
            }
            case FIRST: 
            case PREMIUM_FIRST: {
                return "First";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected class of service {0}", (Object[])new Object[]{classOfService});
    }

    public static ShoppingRequestCabinTypeType buildCabin(String cabinTypeCodeType, PreferenceFilterRE prefLevelCodeType) {
        ShoppingRequestCabinTypeType cabinType = new ShoppingRequestCabinTypeType();
        cabinType.setCabinTypeCode(cabinTypeCodeType);
        PrefLevelType prefLevel = new PrefLevelType();
        prefLevel.setPrefLevelCode(prefLevelCodeType);
        cabinType.setPrefLevel(prefLevel);
        return cabinType;
    }

    private static boolean isTchCode(String value) {
        char c = value.charAt(0);
        return c >= '\u0410' && c <= '\u042f' || c >= '\u0430' && c <= '\u044f';
    }

    public static LocationCodeType buildLocationCodeType(DictionaryReference<GeoLocation> locationRef) {
        LocationCodeType locationCodeType = new LocationCodeType();
        locationCodeType.setValue(MixvelHelper.getNativeCode(locationRef));
        if (MixvelAirShoppingRQHelper.isTchCode(locationCodeType.getValue())) {
            locationCodeType.setStandart("TCH");
        }
        return locationCodeType;
    }

    public static PaxType buildPax(DictionaryReference<PassengerType> passengerTypeRef, int id) {
        PaxType pax = new PaxType();
        pax.setPaxID("Pax-".concat(String.valueOf(id)));
        String ptc = passengerTypeRef.getCode();
        if (MixvelHelper.isChildWithAge(passengerTypeRef)) {
            pax.setAgeMeasure(new BigInteger(ptc.substring(ptc.length() - 2)));
        } else if (ptc.equals("CHILD")) {
            pax.setAgeMeasure(new BigInteger("3"));
        }
        pax.setPTC(MixvelHelper.getPassengerTypeCode(passengerTypeRef));
        return pax;
    }

    public static FlightCriteriaType buildFlightCriteria() {
        FlightCriteriaType flightCriteria = new FlightCriteriaType();
        flightCriteria.setMixRBDInd(Boolean.TRUE.booleanValue());
        return flightCriteria;
    }

    public static void addPayloadRestrictions(RequestType request, MixvelGdsAccount gdsAccount, Integer limit) {
        Integer numberOfIterations = gdsAccount.getNumberOfIterations();
        if (limit != null || numberOfIterations != null) {
            PayloadRestrictionsType prt = new PayloadRestrictionsType();
            if (limit != null) {
                prt.setLimit(Long.valueOf(limit.intValue()));
            }
            if (numberOfIterations != null) {
                prt.setObjectName(ObjectNameCodeType.OFFER);
                SelectionsType selections = new SelectionsType();
                selections.setSet(numberOfIterations);
                prt.setSelections(selections);
            }
            request.getPayloadRestrictions().add(prt);
        }
    }

    public static IATAPayloadStandardAttributesType buildPayloadAttributes(MixvelGdsAccount gdsAccount) {
        Integer responseAfterTimeout = gdsAccount.getResponseAfterTimeout();
        if (responseAfterTimeout == null) {
            return null;
        }
        IATAPayloadStandardAttributesType payloadAttributes = new IATAPayloadStandardAttributesType();
        payloadAttributes.setResponseAfterTimeout(BigInteger.valueOf(responseAfterTimeout.intValue()));
        return payloadAttributes;
    }

    public static class CriteriaAccumulator {
        private final ShoppingCriteriaType shoppingCriteria;
        private final Map<CarrierCriteria, Integer> carrierPrefs;
        private final Map<ConnectionCriteria, Integer> connectionPrefs;

        public CriteriaAccumulator(ShoppingCriteriaType shoppingCriteria) {
            this.shoppingCriteria = shoppingCriteria;
            this.carrierPrefs = new HashMap<CarrierCriteria, Integer>();
            this.connectionPrefs = new HashMap<ConnectionCriteria, Integer>();
        }

        public String accumulateConnectionCriteria(boolean skipConnected) {
            ConnectionCriteria pref = new ConnectionCriteria(skipConnected);
            Integer idx = this.connectionPrefs.get(pref);
            if (idx == null) {
                idx = this.connectionPrefs.size() + 1;
                this.connectionPrefs.put(pref, idx);
                ConnectionCriteriaType connectionCriteria = pref.toConnectionCriteriaType(idx);
                this.shoppingCriteria.getConnectionCriteria().add(connectionCriteria);
            }
            return pref.getPrefId(idx);
        }

        public String accumulateCarrierCriteria(Collection<String> airlines, String flightNumber) {
            CarrierCriteria pref = new CarrierCriteria(airlines, flightNumber);
            Integer idx = this.carrierPrefs.get(pref);
            if (idx == null) {
                idx = this.carrierPrefs.size() + 1;
                this.carrierPrefs.put(pref, idx);
                CarrierCriteriaType carrierCriteria = pref.toCarrierCriteriaType(idx);
                this.shoppingCriteria.getCarrierCriteria().add(carrierCriteria);
            }
            return pref.getPrefId(idx);
        }
    }

    private static class ConnectionCriteria {
        private static final String ID_PREFIX = "Connection-";
        private final boolean skipConnected;

        public ConnectionCriteria(boolean skipConnected) {
            this.skipConnected = skipConnected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionCriteria that = (ConnectionCriteria)o;
            return this.skipConnected == that.skipConnected;
        }

        public int hashCode() {
            return Objects.hash(this.skipConnected);
        }

        public ConnectionCriteriaType toConnectionCriteriaType(int idx) {
            ConnectionCriteriaType result = new ConnectionCriteriaType();
            result.setConnectionPrefID(this.getPrefId(idx));
            result.setAllowAirportChangeInd(Boolean.TRUE);
            if (this.skipConnected) {
                result.setMaximumConnectionQty(BigInteger.ZERO);
            }
            return result;
        }

        public String getPrefId(int idx) {
            return ID_PREFIX.concat(Integer.toString(idx));
        }
    }

    private static class CarrierCriteria {
        private static final String ID_PREFIX = "Carrier-";
        private final Set<String> airlines;
        private final String flightNumber;

        public CarrierCriteria(Collection<String> airlines, String flightNumber) {
            this.airlines = new HashSet<String>(airlines);
            this.flightNumber = flightNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CarrierCriteria that = (CarrierCriteria)o;
            return Objects.equals(this.airlines, that.airlines) && Objects.equals(this.flightNumber, that.flightNumber);
        }

        public int hashCode() {
            return Objects.hash(this.airlines, this.flightNumber);
        }

        public CarrierCriteriaType toCarrierCriteriaType(int idx) {
            CarrierCriteriaType result = new CarrierCriteriaType();
            result.setCarrierPrefID(this.getPrefId(idx));
            if (this.flightNumber != null) {
                CarrierFlightType carrier = CarrierCriteria.toCarrierFlightType((String)CollectionUtil.single(this.airlines));
                carrier.getMarketingCarrierFlightNumberText().add(this.flightNumber);
                result.getCarrier().add(carrier);
            } else {
                this.airlines.stream().map(CarrierCriteria::toCarrierFlightType).forEach(result.getCarrier()::add);
            }
            return result;
        }

        private static CarrierFlightType toCarrierFlightType(String airline) {
            CarrierFlightType carrier = new CarrierFlightType();
            carrier.setAirlineDesigCode(airline);
            return carrier;
        }

        public String getPrefId(int idx) {
            return ID_PREFIX.concat(Integer.toString(idx));
        }
    }
}

