/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelRemarksSearchContext;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.mixvel.DataListsIndex;
import com.gridnine.xtrip.server.gds.mixvel.MixvelCustomPropertiesHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.AllowedType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.AmountType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggageAllowanceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggageAssociationsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggageTypeCodeType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CabinTypeType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DatedOperatingLegType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DimensionAllowanceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareComponentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareDetailType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.GenderCodeType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.MeasureType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OfferItemType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OfferType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PieceAllowanceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PriceClassType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PriceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.RBDAvailType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.RefundStatusEnum;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ServiceOfferAssociationsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ServiceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TaxType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ValidatingPartyType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.WeightAllowanceType;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;

public class MixvelHelper {
    public static final String TAX_SUM_TAX_CODE = "XT";
    public static final String PAX_ID_PREFIX = "Pax-";
    public static final String SIRENA_CODE_1H = "1H";
    public static final String SIRENA_CODE_15 = "15";
    public static final List<String> SIRENA_CODES = Arrays.asList("1H", "15");
    private static final long MAX_HOURS_TIME_ZONE_DIFFERENCE = 26L;
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});
    private static final CodeTranslator MIXVEL_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.MIXVEL.name()});
    private static final Map<PassportType, String> PASSPORT_TYPES = new HashMap<PassportType, String>();

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref, false);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static Money parseAmount(AmountType amount) {
        return MixvelHelper.parseAmount(amount, false);
    }

    public static Money parseAmount(AmountType amount, boolean negate) {
        BigDecimal value = amount.getValue();
        if (negate) {
            value = value.negate();
        }
        return MoneyHelper.buildMoney((BigDecimal)value, (String)amount.getCurCode());
    }

    public static FlightTax createFlightTax(String taxCode, BigDecimal equivalentAmount, DictionaryReference<PassengerType> passengerType, FlightSegmentTariff flightSegmentTariff) {
        FlightTax ft = new FlightTax();
        ft.setCode(taxCode);
        ft.setEquivalentAmount(equivalentAmount);
        ft.setPassengerType(passengerType);
        ft.setSegmentTariff(flightSegmentTariff);
        return ft;
    }

    public static Map<String, Map<String, FareComponentType>> buildFareComponentsMap(OfferType offer) {
        HashMap<String, Map<String, FareComponentType>> result = new HashMap<String, Map<String, FareComponentType>>();
        for (OfferItemType offerItem : offer.getOfferItem()) {
            FareDetailType fareDetail = (FareDetailType)CollectionUtil.single((Collection)offerItem.getFareDetail());
            Set paxRefIDs = offerItem.getService().stream().flatMap(st -> st.getPaxRefID().stream()).collect(Collectors.toSet());
            for (FareComponentType fareComponent : fareDetail.getFareComponent()) {
                for (String paxSegmentRefId : fareComponent.getPaxSegmentRefID()) {
                    Map subMap = result.computeIfAbsent(paxSegmentRefId, k -> new HashMap());
                    for (String paxRefId : paxRefIDs) {
                        subMap.put(paxRefId, fareComponent);
                    }
                }
            }
        }
        return result;
    }

    public static ClassOfService getClassOfService(String cabinTypeCode) {
        switch (cabinTypeCode) {
            case "Economy": {
                return ClassOfService.ECONOMY;
            }
            case "Premium Economy": {
                return ClassOfService.PREMIUM;
            }
            case "Business": {
                return ClassOfService.BUSINESS;
            }
            case "First": {
                return ClassOfService.FIRST;
            }
        }
        throw Xeption.forDeveloper((String)"unsupported cabin type code {0}", (Object[])new Object[]{cabinTypeCode});
    }

    public static Map<String, Map<String, Set<String>>> buildBaggageAssociationsTypeMap(DataListsIndex index, OfferType offer) {
        HashMap<String, Map<String, Set<String>>> baggageAllowanceMap = new HashMap<String, Map<String, Set<String>>>();
        Set paxSegmentRefIDs = offer.getBaggageAllowance().stream().flatMap(bat -> bat.getBaggageFlightAssociations().getPaxSegmentRef().getPaxSegmentRefID().stream()).collect(Collectors.toSet());
        for (String paxSegmentRefID : paxSegmentRefIDs) {
            HashMap subMap = new HashMap();
            for (BaggageAssociationsType baggageAssociationsType : offer.getBaggageAllowance()) {
                if (!baggageAssociationsType.getBaggageFlightAssociations().getPaxSegmentRef().getPaxSegmentRefID().contains(paxSegmentRefID)) continue;
                for (String pax : baggageAssociationsType.getPaxRefID()) {
                    HashSet<String> baggageAllowanceRefIDs = subMap.containsKey(index.getPax(pax).getPTC()) ? (Set)subMap.get(index.getPax(pax).getPTC()) : new HashSet<String>();
                    baggageAllowanceRefIDs.add(baggageAssociationsType.getBaggageAllowanceRefID());
                    subMap.put(index.getPax(pax).getPTC(), baggageAllowanceRefIDs);
                }
            }
            if (subMap.isEmpty()) continue;
            baggageAllowanceMap.put(paxSegmentRefID, subMap);
        }
        return baggageAllowanceMap;
    }

    private static WeightAllowanceType getWeightAllowance(BaggageAllowanceType baggageAllowance) {
        if (baggageAllowance.getAllowed().size() == 1) {
            return MixvelHelper.getWeightAllowance(((AllowedType)CollectionUtil.single((Collection)baggageAllowance.getAllowed())).getWeightAllowance());
        }
        return null;
    }

    private static WeightAllowanceType getWeightAllowance(List<WeightAllowanceType> weightAllowances) {
        WeightAllowanceType kgWeightAllowance = (WeightAllowanceType)Streams.singleOrNull(weightAllowances.stream().filter(wa -> "Kilogram".equalsIgnoreCase(Optional.ofNullable(wa.getMaximumWeightMeasure()).map(MeasureType::getUnitCode).orElse(null))));
        if (kgWeightAllowance != null) {
            return kgWeightAllowance;
        }
        return weightAllowances.isEmpty() ? null : weightAllowances.get(0);
    }

    public static LuggageInfo buildLuggageInfo(DataListsIndex index, Set<String> baggageAllowanceRefIds) {
        for (String baggageAllowanceRefId : baggageAllowanceRefIds) {
            BaggageAllowanceType baggageAllowance = index.getBaggageAllowance(baggageAllowanceRefId);
            if (baggageAllowance.getTypeCode() != BaggageTypeCodeType.CHECKED) continue;
            WeightAllowanceType weightAllowance = MixvelHelper.getWeightAllowance(baggageAllowance);
            if (!baggageAllowance.getPieceAllowance().isEmpty()) {
                int totalQty = ((PieceAllowanceType)CollectionUtil.single((Collection)baggageAllowance.getPieceAllowance())).getTotalQty();
                if (totalQty == 0) {
                    LuggageInfo result = new LuggageInfo();
                    result.setNil(true);
                    return result;
                }
                if (totalQty > 1 || weightAllowance == null) {
                    LuggageInfo result = new LuggageInfo();
                    result.setQuantity(Integer.valueOf(totalQty));
                    result.setUnit((DictionaryReference)DictHelper.getPcLuggageUnit().toReference());
                    return result;
                }
                MeasureType measure = weightAllowance.getMaximumWeightMeasure();
                String unitCode = measure.getUnitCode();
                BigDecimal value = measure.getValue();
                if (value.compareTo(BigDecimal.ZERO) != 0) {
                    return AirProductHelper.buildLuggageInfo((Integer)value.intValue(), (String)unitCode);
                }
            } else if (weightAllowance != null && weightAllowance.getMaximumWeightMeasure().getValue().compareTo(BigDecimal.ZERO) != 0) {
                MeasureType measure = weightAllowance.getMaximumWeightMeasure();
                String unitCode = measure.getUnitCode();
                BigDecimal value = measure.getValue();
                return AirProductHelper.buildLuggageInfo((Integer)value.intValue(), (String)unitCode);
            }
            return null;
        }
        return AirProductHelper.buildNilLuggageInfo();
    }

    public static FareDetails buildFareDetails(DataListsIndex index, Set<String> baggageAllowanceRefIds, FareComponentType fareComponent) {
        FareDetails fd = new FareDetails();
        fd.setCabinLuggageInfo(MixvelHelper.buildExtendedLuggageInfo(index, baggageAllowanceRefIds, BaggageTypeCodeType.CARRY_ON));
        fd.setLuggageInfo(MixvelHelper.buildExtendedLuggageInfo(index, baggageAllowanceRefIds, BaggageTypeCodeType.CHECKED));
        if (fareComponent.getPriceClassRefID() != null) {
            PriceClassType priceClass = index.getPriceClass(fareComponent.getPriceClassRefID());
            String brandName = priceClass.getName();
            L10nStringHelper.setValue((L10nString)fd.getBrandName(), (String)brandName, (Locale)Locale.ROOT);
            FarePricingParameters fpp = new FarePricingParameters();
            fpp.setBrandId(priceClass.getCode());
            fd.setPricingParameters(fpp);
        }
        return fd;
    }

    private static void populateDimensions(ExtendedLuggageInfo info, BaggageAllowanceType baggageAllowance) {
        if (baggageAllowance.getAllowed().size() == 1) {
            MixvelHelper.populateDimensions(info, ((AllowedType)CollectionUtil.single((Collection)baggageAllowance.getAllowed())).getDimensionAllowance());
            return;
        }
    }

    private static void populateDimensions(ExtendedLuggageInfo info, List<DimensionAllowanceType> dimensionAllowances) {
        try {
            for (String unitCode : Arrays.asList("Centimetre", "Inch")) {
                dimensionAllowances.stream().filter(dimensionAllowance -> unitCode.equals(dimensionAllowance.getMaxMeasure().getUnitCode())).forEach(dimensionAllowance -> {
                    String baggageDimensionCategory = dimensionAllowance.getBaggageDimensionCategory();
                    int value = dimensionAllowance.getMaxMeasure().getValue().intValue();
                    switch (baggageDimensionCategory) {
                        case "Length": {
                            info.setLength(Integer.valueOf(value));
                            break;
                        }
                        case "Width": {
                            info.setWidth(Integer.valueOf(value));
                            break;
                        }
                        case "Height": {
                            info.setHeight(Integer.valueOf(value));
                            break;
                        }
                        case "Total": {
                            info.setDimensionsSum(Integer.valueOf(value));
                            break;
                        }
                        default: {
                            throw Xeption.forDeveloper((String)"unexpected BaggageDimensionCategory {0}", (Object[])new Object[]{baggageDimensionCategory});
                        }
                    }
                });
                if (info.getDimensionsSum() == null && info.getLength() != null && info.getWidth() != null && info.getHeight() != null) {
                    info.setDimensionsSum(Integer.valueOf(info.getLength() + info.getWidth() + info.getHeight()));
                }
                if (info.getDimensionsSum() == null) {
                    info.setLength(null);
                    info.setWidth(null);
                    info.setHeight(null);
                    continue;
                }
                switch (unitCode) {
                    case "Centimetre": {
                        info.setDimensionUnit(LuggageDimensionUnit.CENTIMETER);
                        break;
                    }
                    case "Inch": {
                        info.setDimensionUnit(LuggageDimensionUnit.INCH);
                        break;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)"unexpected UnitCode {0}", (Object[])new Object[]{unitCode});
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)"populateDimensions failed", (Throwable)e);
            info.setLength(null);
            info.setWidth(null);
            info.setHeight(null);
            info.setDimensionsSum(null);
            info.setDimensionUnit(null);
        }
    }

    private static ExtendedLuggageInfo buildExtendedLuggageInfo(BaggageAllowanceType baggageAllowance) {
        WeightAllowanceType weightAllowance;
        ExtendedLuggageInfo result = new ExtendedLuggageInfo();
        if (!baggageAllowance.getPieceAllowance().isEmpty()) {
            int totalQty = ((PieceAllowanceType)CollectionUtil.single((Collection)baggageAllowance.getPieceAllowance())).getTotalQty();
            result.setPieces(Integer.valueOf(totalQty));
        }
        if ((weightAllowance = MixvelHelper.getWeightAllowance(baggageAllowance)) != null) {
            MeasureType maximumWeightMeasure = weightAllowance.getMaximumWeightMeasure();
            BigDecimal value = maximumWeightMeasure.getValue();
            result.setWeight(Integer.valueOf(value.intValue()));
            result.setWeightUnit((DictionaryReference)DictHelper.findLuggageUnitBySpellVariant((String)maximumWeightMeasure.getUnitCode()).toReference());
            return result;
        }
        return null;
    }

    public static ExtendedLuggageInfo buildExtendedLuggageInfo(DataListsIndex index, Set<String> baggageAllowanceRefIds, BaggageTypeCodeType typeCode) {
        for (String baggageAllowanceRefId : baggageAllowanceRefIds) {
            ExtendedLuggageInfo result;
            BaggageAllowanceType baggageAllowance = index.getBaggageAllowance(baggageAllowanceRefId);
            if (baggageAllowance.getTypeCode() != typeCode) continue;
            switch (typeCode) {
                case CHECKED: {
                    result = MixvelHelper.buildExtendedLuggageInfo(baggageAllowance);
                    break;
                }
                case CARRY_ON: {
                    result = MixvelHelper.buildExtendedLuggageInfo(baggageAllowance);
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected type code {0}", (Object[])new Object[]{typeCode.name()});
                }
            }
            if (result != null) {
                MixvelHelper.populateDimensions(result, baggageAllowance);
            }
            return result;
        }
        return null;
    }

    public static Flight convertOfferTypeToFlight(OfferType offer, DataListsIndex index, List<SeatPreferences> seats) throws Exception {
        Set<Object> startingIds;
        MixvelHelper.validateOffer(offer, index);
        Flight flight = new Flight();
        flight.setSalesOriginContent(SalesOriginContent.SIRENA);
        flight.setSalesOriginProvider(SalesOriginProvider.SIRENA);
        flight.setAccountCodeApplied(true);
        Set accountCodes = offer.getOfferItem().stream().map(OfferItemType::getFareDetail).map(CollectionUtil::single).filter(fd -> fd.getFareCalculationInfo() != null).map(FareDetailType::getAccountCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!accountCodes.isEmpty()) {
            flight.setAccountCode((String)CollectionUtil.single(accountCodes));
            if (flight.getTripartiteContractDetails() == null) {
                flight.setTripartiteContractDetails(new TripartiteContractDetails());
            }
            flight.getTripartiteContractDetails().setIssuedUnder3d(true);
        }
        String validatingPartyCode = offer.getOfferItem().stream().map(OfferItemType::getService).flatMap(st -> st.stream().map(ServiceType::getValidatingPartyRefID).distinct()).map(index::getValidatingParty).map(ValidatingPartyType::getValidatingPartyCode).distinct().findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"no validating carrier", (Object[])new Object[0]));
        flight.setCarrier(MixvelHelper.resolveNativeCode(Airline.class, validatingPartyCode));
        flight.setPqTimeLimit(MixvelHelper.calculateTimeLimit(offer));
        flight.setGdsCurrencyCode(offer.getTotalPrice().getBaseAmount().getCurCode());
        if (offer.getReservationGuideline() != null && offer.getReservationGuideline().getReservationLang() != null) {
            flight.setLatinRegistration(!"RU".equals(offer.getReservationGuideline().getReservationLang()));
        }
        List services = offer.getOfferItem().stream().flatMap(oi -> oi.getService().stream()).collect(Collectors.toList());
        List paxJourneyRefIDs = services.stream().map(ServiceType::getServiceAssociations).map(ServiceOfferAssociationsType::getPaxJourneyRef).filter(Objects::nonNull).flatMap(pjref -> pjref.getPaxJourneyRefID().stream().distinct()).collect(Collectors.toList());
        List paxJourneys = paxJourneyRefIDs.stream().map(index::getPaxJourney).collect(Collectors.toList());
        Map<String, Map<String, FareComponentType>> fareComponentsMap = MixvelHelper.buildFareComponentsMap(offer);
        Map<String, Map<String, Set<String>>> baggageAssociationsTypeMap = MixvelHelper.buildBaggageAssociationsTypeMap(index, offer);
        List<List<String>> segmentTariffs = offer.getOfferItem().stream().flatMap(oi -> oi.getFareDetail().stream()).flatMap(fd -> fd.getFareComponent().stream()).map(FareComponentType::getPaxSegmentRefID).distinct().collect(Collectors.toList());
        if (MixvelHelper.isSeveralOfferItemsFoxPaxInOffer(offer)) {
            segmentTariffs = MixvelHelper.ensureSegmentsOrder(segmentTariffs, index);
        }
        if (paxJourneys.isEmpty()) {
            startingIds = new HashSet();
            segmentTariffs.forEach(st -> startingIds.add(st.get(0)));
        } else {
            startingIds = paxJourneys.stream().map(pj -> (String)pj.getPaxSegmentRefID().get(0)).collect(Collectors.toSet());
        }
        int idx = 0;
        for (List<String> segmentTariff : segmentTariffs) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            for (String paxSegmentRefId : segmentTariff) {
                Map<String, FareComponentType> fareComponentByPtc = fareComponentsMap.get(paxSegmentRefId);
                PaxSegmentType paxSegment = index.getPaxSegment(paxSegmentRefId);
                FlightSegment fs = new FlightSegment();
                fs.setGdsId(paxSegmentRefId);
                fs.setAirline(MixvelHelper.resolveNativeCode(Airline.class, paxSegment.getMarketingCarrierInfo().getCarrierDesigCode()));
                fs.setFlightNumber(GDSHelper.stripZeroesInFlightNumber((String)paxSegment.getMarketingCarrierInfo().getMarketingCarrierFlightNumberText()));
                if (paxSegment.getOperatingCarrierInfo() != null) {
                    fs.setOperatingAirline(MixvelHelper.resolveNativeCode(Airline.class, paxSegment.getOperatingCarrierInfo().getCarrierDesigCode()));
                    if (paxSegment.getOperatingCarrierInfo().getOperatingCarrierFlightNumberText() != null) {
                        fs.setOperatingFlightNumber(GDSHelper.stripZeroesInFlightNumber((String)paxSegment.getOperatingCarrierInfo().getOperatingCarrierFlightNumberText()));
                    }
                } else {
                    fs.setOperatingAirline(fs.getAirline());
                    fs.setOperatingFlightNumber(fs.getFlightNumber());
                }
                fs.setLocationBegin(MixvelHelper.resolveNativeCode(GeoLocation.class, paxSegment.getDep().getIATALocationCode().getValue()));
                fs.setLocationEnd(MixvelHelper.resolveNativeCode(GeoLocation.class, paxSegment.getArrival().getIATALocationCode().getValue()));
                fs.setDateBegin(paxSegment.getDep().getScheduledDateTime().toGregorianCalendar().getTime());
                fs.setDateEnd(paxSegment.getArrival().getScheduledDateTime().toGregorianCalendar().getTime());
                fs.setTerminalBegin(paxSegment.getDep().getTerminalName());
                fs.setTerminalEnd(paxSegment.getArrival().getTerminalName());
                fs.setBoard(MixvelHelper.resolveNativeCode(Aircraft.class, ((DatedOperatingLegType)paxSegment.getDatedOperatingLeg().get(0)).getCarrierType().getCarrierTypeCode()));
                fs.setTravelDuration(paxSegment.getDuration().getHours() * 60 + paxSegment.getDuration().getMinutes());
                fs.setStops(paxSegment.getDatedOperatingLeg().size() - 1);
                fs.setStarting(startingIds.contains(paxSegmentRefId));
                fs.setBookingClass((String)Streams.single(fareComponentByPtc.values().stream().map(FareComponentType::getRBD).map(RBDAvailType::getRBDCode).distinct()));
                OptionalInt availableSeatsOptional = fareComponentByPtc.values().stream().map(FareComponentType::getRBD).map(RBDAvailType::getAvailability).filter(Objects::nonNull).mapToInt(Integer::intValue).min();
                if (availableSeatsOptional.isPresent()) {
                    fs.setAvailableSeats(Integer.valueOf(availableSeatsOptional.getAsInt()));
                }
                fs.setServiceClass(MixvelHelper.getClassOfService((String)Streams.single(fareComponentByPtc.values().stream().map(FareComponentType::getCabinType).map(CabinTypeType::getCabinTypeCode).distinct())));
                List offers = offer.getOfferItem().stream().filter(oi -> MixvelHelper.findAllPaxSegIDs(oi).contains(paxSegmentRefId)).collect(Collectors.toList());
                for (OfferItemType offerItem : offers) {
                    FareDetailType fareDetail = (FareDetailType)CollectionUtil.single((Collection)offerItem.getFareDetail());
                    FareComponentType fareComponent = (FareComponentType)Streams.single(fareDetail.getFareComponent().stream().filter(fc -> fc.getPaxSegmentRefID().contains(paxSegmentRefId)));
                    Set paxRefIDs = offerItem.getService().stream().flatMap(st -> st.getPaxRefID().stream()).collect(Collectors.toSet());
                    for (String ptc : paxRefIDs.stream().map(index::getPax).map(PaxType::getPTC).collect(Collectors.toSet())) {
                        FareInfo fi = new FareInfo();
                        MixvelCustomPropertiesHelper.setOfferItemId(fi, offerItem.getOfferItemID());
                        MixvelCustomPropertiesHelper.setValidatingPartyCode(fi, (String)Streams.single(offerItem.getService().stream().map(ServiceType::getValidatingPartyRefID).distinct().map(index::getValidatingParty).map(ValidatingPartyType::getValidatingPartyCode).distinct()));
                        Map<String, Set<String>> pax2baggageAllowance = baggageAssociationsTypeMap.get(paxSegmentRefId);
                        DictionaryReference<PassengerType> passengerTypeRef = MixvelHelper.resolvePassengerTypeCode(ptc);
                        fi.setPassengerType(passengerTypeRef);
                        fi.setFareBasis(fareComponent.getFareBasisCode());
                        MixvelRemarksSearchContext mrsc = new MixvelRemarksSearchContext();
                        mrsc.setOfferId(offer.getOfferID());
                        mrsc.setOfferItemId(offerItem.getOfferItemID());
                        mrsc.setSegmentIndex(idx);
                        fi.setRemarksSearchContext(XSUtil.toString((XSSerializable)mrsc));
                        if (pax2baggageAllowance != null && pax2baggageAllowance.containsKey(ptc)) {
                            fi.setLuggageInfo(MixvelHelper.buildLuggageInfo(index, pax2baggageAllowance.get(ptc)));
                            fi.setFareDetails(MixvelHelper.buildFareDetails(index, pax2baggageAllowance.get(ptc), fareComponent));
                        }
                        fs.getFareInfos().add(fi);
                    }
                }
                fs.getTechStopInfos().addAll(MixvelHelper.parseTechStopInfos(paxSegment.getDatedOperatingLeg()));
                fst.getSegments().add(fs);
                ++idx;
            }
            flight.getSegmentTariffs().add(fst);
            for (FlightSegment seg : fst.getSegments()) {
                for (DictionaryReference passengerType : seg.getFareInfos().stream().map(FareInfo::getPassengerType).collect(Collectors.toList())) {
                    String ptc = MixvelHelper.getPassengerTypeCode((DictionaryReference<PassengerType>)passengerType);
                    List fareDetails = offer.getOfferItem().stream().map(OfferItemType::getFareDetail).filter(list -> list.stream().filter(fd -> fd.getPaxRefID().stream().anyMatch(paxId -> {
                        PaxType pax = index.getPax((String)paxId);
                        return pax.getPTC().equals(ptc);
                    })).flatMap(fd -> fd.getFareComponent().stream()).flatMap(fc -> fc.getPaxSegmentRefID().stream()).collect(Collectors.toList()).contains(seg.getGdsId())).findAny().get();
                    FareComponentType fareComponent = (FareComponentType)Streams.single(fareDetails.stream().flatMap(fd -> fd.getFareComponent().stream()).filter(fc -> fc.getPaxSegmentRefID().contains(seg.getGdsId())));
                    FlightFare ff = new FlightFare();
                    ff.setSegmentTariff(fst);
                    ff.setPassengerType(passengerType);
                    ff.setBaseAmount(MixvelHelper.parseAmount(fareComponent.getPrice().getBaseAmount()));
                    if (fareComponent.getPrice().getEquivAmount() != null) {
                        ff.setEquivalentAmount(fareComponent.getPrice().getEquivAmount().getValue());
                    } else {
                        ff.setEquivalentAmount(ff.getBaseAmount().getValue());
                    }
                    String fareCurrency = ff.getBaseAmount().getCurrency();
                    BigDecimal addFareBaseAmount = BigDecimal.ZERO;
                    boolean differentCurrencies = false;
                    if (fareComponent.getPrice().getTaxSummary() != null) {
                        if (fareComponent.getPrice().getTaxSummary().getTax() != null) {
                            for (TaxType tax : fareComponent.getPrice().getTaxSummary().getTax()) {
                                if (!TextUtil.isBlank((String)tax.getQualifierCode())) continue;
                                if (tax.getTaxCode().length() == 1) {
                                    BigDecimal amount = tax.getAmount().getValue();
                                    ff.setEquivalentAmount(ff.getEquivalentAmount().add(amount));
                                    if (fareCurrency.equals(tax.getAmount().getCurCode())) {
                                        addFareBaseAmount = addFareBaseAmount.add(amount);
                                        continue;
                                    }
                                    differentCurrencies = true;
                                    continue;
                                }
                                FlightTax flightTax = MixvelHelper.createFlightTax(tax.getTaxCode(), tax.getAmount().getValue(), (DictionaryReference<PassengerType>)passengerType, fst);
                                flight.getTaxes().add(flightTax);
                            }
                        } else {
                            FlightTax flightTax = MixvelHelper.createFlightTax(TAX_SUM_TAX_CODE, fareComponent.getPrice().getTaxSummary().getTotalTaxAmount().getValue(), (DictionaryReference<PassengerType>)passengerType, fst);
                            flight.getTaxes().add(flightTax);
                        }
                    }
                    if (differentCurrencies) {
                        ff.setBaseAmount(null);
                    } else {
                        ff.getBaseAmount().setValue(ff.getBaseAmount().getValue().add(addFareBaseAmount));
                    }
                    flight.getFares().add(ff);
                }
            }
        }
        flight.getSeats().addAll(seats);
        FlightHelper.fillMultiTicketBreakdown((Flight)flight, MixvelHelper::getTicketKey, MixvelHelper::getValidatingPartyCode);
        return flight;
    }

    private static Map<DictionaryReference<PassengerType>, String> getTicketKey(FlightSegmentTariff fst) {
        return (Map)Streams.single(fst.getSegments().stream().map(fs -> fs.getFareInfos().stream().collect(Collectors.toMap(FareInfo::getPassengerType, MixvelCustomPropertiesHelper::getOfferItemId))).distinct());
    }

    private static DictionaryReference<Airline> getValidatingPartyCode(FlightSegmentTariff fst) {
        return MixvelHelper.resolveNativeCode(Airline.class, (String)Streams.single(fst.getSegments().stream().map(FlightSegment::getFareInfos).flatMap(Collection::stream).map(MixvelCustomPropertiesHelper::getValidatingPartyCode).distinct()));
    }

    private static void validateOffer(OfferType offer, DataListsIndex index) {
        ArrayList segmentPassengerTypes = new ArrayList();
        offer.getOfferItem().stream().map(OfferItemType::getFareDetail).flatMap(Collection::stream).forEach(fd -> {
            List passengerTypeCodes = fd.getPaxRefID().stream().map(index::getPax).map(PaxType::getPTC).map(MixvelHelper::resolvePassengerTypeCode).filter(Objects::nonNull).map(DictionaryReference::getCode).distinct().collect(Collectors.toList());
            List segmentRefs = fd.getFareComponent().stream().map(FareComponentType::getPaxSegmentRefID).flatMap(Collection::stream).collect(Collectors.toList());
            for (String passengerTypeCode : passengerTypeCodes) {
                for (String segmentRef : segmentRefs) {
                    String key = passengerTypeCode + "|" + segmentRef;
                    if (segmentPassengerTypes.contains(key)) {
                        throw Xeption.forDeveloper((String)("duplicate passengerType in segment: " + key), (Object[])new Object[0]);
                    }
                    segmentPassengerTypes.add(key);
                }
            }
        });
    }

    private static boolean isSeveralOfferItemsFoxPaxInOffer(OfferType offer) {
        String firstPax = (String)((OfferItemType)offer.getOfferItem().get(0)).getService().stream().flatMap(st -> st.getPaxRefID().stream()).collect(Collectors.toList()).get(0);
        int oiCount = 0;
        for (OfferItemType oi : offer.getOfferItem()) {
            if (!oi.getFareDetail().stream().anyMatch(fd -> fd.getPaxRefID().contains(firstPax))) continue;
            ++oiCount;
        }
        return oiCount > 1;
    }

    private static List<List<String>> ensureSegmentsOrder(List<List<String>> segmentTariffs, DataListsIndex index) {
        Map<String, PaxSegmentType> paxSegMap = segmentTariffs.stream().flatMap(Collection::stream).collect(Collectors.toMap(id -> id, index::getPaxSegment));
        List<List<String>> segmentTariffsOriginal = segmentTariffs.stream().map(ArrayList::new).collect(Collectors.toList());
        try {
            final Comparator comparator = (st1, st2) -> {
                LocalDateTime dateTime2;
                PaxSegmentType ps1 = (PaxSegmentType)paxSegMap.get(st1);
                PaxSegmentType ps2 = (PaxSegmentType)paxSegMap.get(st2);
                LocalDateTime dateTime1 = MiscUtil.toLocalDateTime((Date)ps1.getDep().getScheduledDateTime().toGregorianCalendar().getTime());
                Duration duration = Duration.between(dateTime1, dateTime2 = MiscUtil.toLocalDateTime((Date)ps2.getDep().getScheduledDateTime().toGregorianCalendar().getTime()));
                if (Math.abs(duration.toHours()) > 26L) {
                    return MiscUtil.compare((Date)ps1.getDep().getScheduledDateTime().toGregorianCalendar().getTime(), (Date)ps2.getDep().getScheduledDateTime().toGregorianCalendar().getTime());
                }
                ZonedDateTime zonedDateTime1 = DictHelper.getZonedDateTime((LocalDateTime)dateTime1, MixvelHelper.resolveNativeCode(GeoLocation.class, ps1.getDep().getIATALocationCode().getValue()));
                ZonedDateTime zonedDateTime2 = DictHelper.getZonedDateTime((LocalDateTime)dateTime2, MixvelHelper.resolveNativeCode(GeoLocation.class, ps2.getDep().getIATALocationCode().getValue()));
                if (zonedDateTime1 == null || zonedDateTime2 == null) {
                    throw Xeption.forDeveloper((String)"Geo location has no Zone ID: {0}", (Object[])new Object[]{zonedDateTime1 == null ? ps1.getDep().getIATALocationCode().getValue() : ps2.getDep().getIATALocationCode().getValue()});
                }
                return MiscUtil.compare((Comparable)zonedDateTime1, (Comparable)zonedDateTime2);
            };
            segmentTariffs.forEach(sts -> sts.sort(comparator));
            segmentTariffs.sort(new Comparator<List<String>>(){

                @Override
                public int compare(List<String> o1, List<String> o2) {
                    return comparator.compare(o1.get(0), o2.get(0));
                }
            });
            return segmentTariffs;
        }
        catch (Exception e) {
            return segmentTariffsOriginal;
        }
    }

    private static List<String> findAllPaxSegIDs(OfferItemType oi) {
        return oi.getFareDetail().stream().flatMap(fdt -> fdt.getFareComponent().stream()).flatMap(fct -> fct.getPaxSegmentRefID().stream()).collect(Collectors.toList());
    }

    public static List<TechStopInfo> parseTechStopInfos(List<DatedOperatingLegType> datedOperatingLeg) {
        if (datedOperatingLeg.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<TechStopInfo> result = new ArrayList<TechStopInfo>(datedOperatingLeg.size() - 1);
        for (int i = 0; i < datedOperatingLeg.size() - 1; ++i) {
            DatedOperatingLegType arrivalLeg = datedOperatingLeg.get(i);
            DatedOperatingLegType departureLeg = datedOperatingLeg.get(i + 1);
            TechStopInfo techStopInfo = new TechStopInfo();
            techStopInfo.setLocation(MixvelHelper.resolveNativeCode(GeoLocation.class, (String)Streams.single(Stream.of(arrivalLeg.getArrival().getIATALocationCode().getValue(), departureLeg.getDep().getIATALocationCode().getValue()).distinct())));
            techStopInfo.setArrivalDateTime(arrivalLeg.getArrival().getScheduledDateTime().toGregorianCalendar().toZonedDateTime().toLocalDateTime());
            techStopInfo.setDepartureDateTime(departureLeg.getDep().getScheduledDateTime().toGregorianCalendar().toZonedDateTime().toLocalDateTime());
            techStopInfo.setDuration(Optional.ofNullable(GdsDictHelper.getTravelDuration((DictionaryReference)techStopInfo.getLocation(), (DictionaryReference)techStopInfo.getLocation(), (LocalDateTime)techStopInfo.getArrivalDateTime(), (LocalDateTime)techStopInfo.getDepartureDateTime())).orElse(0).intValue());
            result.add(techStopInfo);
        }
        return result;
    }

    public static GenderCodeType mapGender(Gender gender) {
        switch (gender) {
            case MALE: {
                return GenderCodeType.M;
            }
            case FEMALE: {
                return GenderCodeType.F;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected gender {0}", (Object[])new Object[]{gender.name()});
    }

    public static String mapPassportType(PassportType passportType) {
        String result = PASSPORT_TYPES.get(passportType);
        if (result == null) {
            throw Xeption.forDeveloper((String)"unexpected passport type {0}", (Object[])new Object[]{passportType});
        }
        return result;
    }

    public static boolean isChildWithAge(DictionaryReference<PassengerType> passengerType) {
        return passengerType.getCode().startsWith("CHILD_") && !"CHILD_RF".equals(passengerType.getCode());
    }

    public static String getPassengerTypeCode(DictionaryReference<PassengerType> passengerType) {
        if (MixvelHelper.isChildWithAge(passengerType)) {
            return MIXVEL_TRANSLATOR.getNativeCode(DictHelper.getChildPassengerType());
        }
        return MIXVEL_TRANSLATOR.getNativeCode(passengerType);
    }

    public static DictionaryReference<PassengerType> resolvePassengerTypeCode(String code) {
        return MIXVEL_TRANSLATOR.resolveNativeCode(PassengerType.class, code);
    }

    private static Date calculateTimeLimit(OfferType offer) {
        return Stream.concat(offer.getOfferItem().stream().map(OfferItemType::getFareDetail).flatMap(Collection::stream).map(FareDetailType::getPrice).map(PriceType::getBaseAmountGuaranteeTimeLimitDateTime).map(XMLGregorianCalendar::toGregorianCalendar).map(Calendar::getTime), Stream.of(offer.getOfferExpirationTimeLimitDateTime().toGregorianCalendar().getTime())).min(Comparator.naturalOrder()).orElse(null);
    }

    public static String buildFullPhoneNumber(Communication phone) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)phone.getCountryCode())) {
            sb.append('+');
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getCountryCode()));
        }
        if (!TextUtil.isBlank((String)phone.getCityCode())) {
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getCityCode()));
        }
        if (!TextUtil.isBlank((String)phone.getSense())) {
            sb.append(ProfileHelper.normalizeCommunicationPart((String)phone.getSense()));
        }
        return sb.toString();
    }

    public static PenaltiesInfo createPenaltiesInfo(RefundStatusEnum refundStatus) {
        PenaltiesInfo penaltiesInfo = new PenaltiesInfo();
        if (refundStatus == RefundStatusEnum.REFUNDABLE) {
            penaltiesInfo.setRefundableBeforeDeparture(Boolean.valueOf(true));
            return penaltiesInfo;
        }
        if (refundStatus == RefundStatusEnum.UNREFUNDABLE) {
            penaltiesInfo.setRefundableBeforeDeparture(Boolean.valueOf(false));
            return penaltiesInfo;
        }
        return null;
    }

    public static String fixNameForPNR(String str) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u0401') {
                result.append('\u0415');
                continue;
            }
            if (ch == '\u0451') {
                result.append('\u0435');
                continue;
            }
            if (ch == '\u042a') {
                result.append('\u042c');
                continue;
            }
            if (ch == '\u044a') {
                result.append('\u044c');
                continue;
            }
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (ch < '\u0410' || ch > '\u0451')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static String getMixOrderId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.MIXVEL_MIX_ORDER_ID);
    }

    public static String getOrderId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.MIXVEL_ORDER_ID);
    }

    static {
        PASSPORT_TYPES.put(PassportType.INTERNAL, "PS");
        PASSPORT_TYPES.put(PassportType.FOREIGN, "PSP");
        PASSPORT_TYPES.put(PassportType.DIPLOMATIC, "DP");
        PASSPORT_TYPES.put(PassportType.BIRTHDAY_NOTIFICATION, "SR");
        PASSPORT_TYPES.put(PassportType.CERTIFICATEOFRELEASE, "SPO");
        PASSPORT_TYPES.put(PassportType.SEAMANSID, "PM");
        PASSPORT_TYPES.put(PassportType.MILITARYID, "VB");
        PASSPORT_TYPES.put(PassportType.PASSPORT, "NP");
        PASSPORT_TYPES.put(PassportType.PASSPORTLOSSCERTIFICATE, "SPU");
        PASSPORT_TYPES.put(PassportType.INTERIMCERTIFICATE, "VUL");
        PASSPORT_TYPES.put(PassportType.MILITARYCERTIFICATE, "UDL");
        PASSPORT_TYPES.put(PassportType.BACKTOUSSRCERTIFICATE, "CVV");
        PASSPORT_TYPES.put(PassportType.SERVICE_PASSPORT, "SP");
        PASSPORT_TYPES.put(PassportType.RESIDENCEPERMIT, "VV");
        PASSPORT_TYPES.put(PassportType.IDENTITYCARD, "NP");
        PASSPORT_TYPES.put(PassportType.FOREIGN_NATIONAL_PASSPORT, "ZA");
    }
}

