/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.NoSegmentsInBookingException;
import com.gridnine.xtrip.common.gds.exceptions.ReservationChangedInGdsException;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderDataListsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxListType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentListType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.ResponseType;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class MixvelOrderViewRSCheckModificationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation;
        MixvelOrderViewRS response = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        if (!this.check(response, reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION))) {
            throw new ReservationChangedInGdsException();
        }
    }

    private boolean check(MixvelOrderViewRS rs, Reservation reservation) {
        Set momTravellerGdsIds;
        ResponseType response = rs.getResponse();
        OrderDataListsType dataLists = response.getDataLists();
        PaxListType paxList = dataLists.getPaxList();
        if (paxList == null || paxList.getPax().isEmpty()) {
            return false;
        }
        Set gdsPaxIds = paxList.getPax().stream().map(PaxType::getPaxID).collect(Collectors.toSet());
        if (!gdsPaxIds.equals(momTravellerGdsIds = AirProductHelper.getAirProductsList((Reservation)reservation).stream().map(Product::getTravellerGdsId).collect(Collectors.toSet()))) {
            return false;
        }
        OrderType order = (OrderType)CollectionUtil.single((Collection)response.getMixOrder().getOrder());
        if (order.getOrderItem().isEmpty()) {
            return false;
        }
        if (order.getOrderItem().size() != AirProductHelper.getAirProductsList((Reservation)reservation).size()) {
            return false;
        }
        PaxSegmentListType paxSegmentList = dataLists.getPaxSegmentList();
        if (paxSegmentList == null || paxSegmentList.getPaxSegment().isEmpty()) {
            throw new NoSegmentsInBookingException();
        }
        Set gdsSegmentIds = paxSegmentList.getPaxSegment().stream().map(PaxSegmentType::getPaxSegmentID).collect(Collectors.toSet());
        Set momSegmentIds = AirProductHelper.getAirProductsList((Reservation)reservation).stream().map(Product::getSegmentTariffs).flatMap(sts -> AirProductHelper.getSegments((Collection)sts).stream()).map(Segment::getGdsId).collect(Collectors.toSet());
        return gdsSegmentIds.equals(momSegmentIds);
    }
}

