/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.gds.mixvel.BestPricingOptionText;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelAirShoppingRQHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BestPricingOptionTextType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DestArrivalCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FlightRequestOriginDestinationsCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OriginDepCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OriginDestCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PreferenceFilterRE;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PricingMethodCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingRequestCabinTypeType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.FlightRequestType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.MixvelAirShoppingRQ;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.PaxsType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class MixvelAfsAirShoppingRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        Product anyProduct = (Product)products.iterator().next();
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        MixvelAirShoppingRQ rq = new MixvelAirShoppingRQ();
        RequestType request = new RequestType();
        ShoppingCriteriaType shoppingCriteria = new ShoppingCriteriaType();
        MixvelAirShoppingRQHelper.CriteriaAccumulator criteriaAccumulator = new MixvelAirShoppingRQHelper.CriteriaAccumulator(shoppingCriteria);
        FlightRequestType flightRequest = new FlightRequestType();
        FlightRequestOriginDestinationsCriteriaType criterias = new FlightRequestOriginDestinationsCriteriaType();
        for (Segment seg : AirProductHelper.getProductSegmentsList((Product)anyProduct)) {
            OriginDestCriteriaType criteria = new OriginDestCriteriaType();
            criteria.getCabinType().addAll(MixvelAfsAirShoppingRQBuilder.buildCabinTypes(seg.getServiceClass()));
            criteria.setConnectionPrefRefID(criteriaAccumulator.accumulateConnectionCriteria(true));
            DestArrivalCriteriaType destArrivalCriteria = new DestArrivalCriteriaType();
            destArrivalCriteria.setIATALocationCode(MixvelAirShoppingRQHelper.buildLocationCodeType((DictionaryReference<GeoLocation>)seg.getArriveLocation()));
            criteria.setDestArrivalCriteria(destArrivalCriteria);
            OriginDepCriteriaType originDepCriteria = new OriginDepCriteriaType();
            originDepCriteria.setDate(JaxWsHelper.toGregorianLocalDate((Date)seg.getStartDate()));
            originDepCriteria.setIATALocationCode(MixvelAirShoppingRQHelper.buildLocationCodeType((DictionaryReference<GeoLocation>)seg.getDepartureLocation()));
            criteria.setOriginDepCriteria(originDepCriteria);
            criteria.getCarrierPrefRefID().add(criteriaAccumulator.accumulateCarrierCriteria(Collections.singleton(MixvelHelper.getNativeCode(seg.getAirline())), seg.getFlightNo()));
            criterias.getOriginDestCriteria().add(criteria);
        }
        flightRequest.setFlightRequestOriginDestinationsCriteria(criterias);
        request.setFlightRequest(flightRequest);
        PaxsType paxs = new PaxsType();
        int id = 1;
        for (Product product : products) {
            paxs.getPax().add(MixvelAirShoppingRQHelper.buildPax((DictionaryReference<PassengerType>)product.getPassengerType(), id++));
        }
        request.setPaxs(paxs);
        PricingMethodCriteriaType pricingMethodCriteria = new PricingMethodCriteriaType();
        if (((MixvelGdsAccount)gdsAccountCtr.getEntity()).getBestPricingOptionText() == BestPricingOptionText.EXTENDED) {
            pricingMethodCriteria.setBestPricingOptionText(BestPricingOptionTextType.EXTENDED);
        }
        pricingMethodCriteria.setCarrierMixInd(Boolean.valueOf(true));
        shoppingCriteria.setPricingMethodCriteria(pricingMethodCriteria);
        shoppingCriteria.setFlightCriteria(MixvelAirShoppingRQHelper.buildFlightCriteria());
        request.setShoppingCriteria(shoppingCriteria);
        MixvelAirShoppingRQHelper.addPayloadRestrictions(request, (MixvelGdsAccount)gdsAccountCtr.getEntity(), null);
        rq.setRequest(request);
        rq.setPayloadAttributes(MixvelAirShoppingRQHelper.buildPayloadAttributes((MixvelGdsAccount)gdsAccountCtr.getEntity()));
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)rq);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/airshopping");
    }

    private static List<ShoppingRequestCabinTypeType> buildCabinTypes(ClassOfService classOfService) {
        ArrayList<ShoppingRequestCabinTypeType> cabinTypesPrefLevel = new ArrayList<ShoppingRequestCabinTypeType>();
        cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin(MixvelAirShoppingRQHelper.getCabinTypeCode(classOfService), PreferenceFilterRE.REQUIRED));
        return cabinTypesPrefLevel;
    }
}

