/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.AfsHelper;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class MixvelAfsProductsFallbackProcessor
extends BaseProcessor {
    private boolean includeTaxes;
    private String message;

    public void configure(Map<String, String> parameters) {
        this.includeTaxes = Boolean.parseBoolean(parameters.get("include-taxes"));
        this.message = parameters.get("message");
    }

    public void process(MessageContext ctx) throws Exception {
        Boolean isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING);
        if (this.message != null) {
            EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"afs-".concat(isTicketing != false ? "tkt" : "bkg"), (MessageType)MessageType.WARNING, (String[])new String[]{this.message});
        }
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        for (Product product : products) {
            BigDecimal value = AfsHelper.getProductPrice((Product)product, (boolean)this.includeTaxes);
            StatisticsHelper.smartSetPricingAfsValue((Product)product, (AFSType)afsType, (boolean)isTicketing, (Double)value.doubleValue());
        }
    }
}

