/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelAirShoppingRQHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MixvelAfsReservationProductBatchesProvider
extends BaseTargetsProvider<List<Product>> {
    public Collection<List<Product>> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUids = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE);
        return reservation.getProducts().stream().filter(bp -> productUids.contains(bp.getUid())).map(bp -> (Product)bp).filter(prod -> prod.getProductCategory() == ProductCategory.AIR).collect(Collectors.groupingBy(this::buildProductKey)).values();
    }

    private Object buildProductKey(Product prod) {
        ArrayList keys = new ArrayList();
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                ArrayList<Object> segKeys = new ArrayList<Object>();
                segKeys.add(MixvelHelper.getNativeCode(seg.getDepartureLocation()));
                segKeys.add(MixvelHelper.getNativeCode(seg.getArriveLocation()));
                segKeys.add(JaxWsHelper.toGregorianLocalDate((Date)seg.getStartDate()));
                segKeys.add(MixvelAirShoppingRQHelper.getCabinTypeCode(DictHelper.findClassOfService((Segment)seg, (Date)prod.getIssueDate())));
                segKeys.add(MixvelHelper.getNativeCode(seg.getAirline()));
                segKeys.add(seg.getFlightNo());
                segKeys.add(Optional.ofNullable(seg.getFareDetails()).map(FareDetails::getPricingParameters).map(FarePricingParameters::getBrandId).orElse(null));
                keys.add(segKeys);
            }
        }
        return keys;
    }
}

