/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.cancelReservation;

import com.gridnine.xtrip.common.gds.exceptions.CannotCancelIssuedException;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CouponType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TicketDocInfoType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TicketType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.WarningType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.util.regex.Pattern;

public class OrderViewRSCheckTicketingProcessor
extends BaseProcessor {
    private static final Pattern P_TICKETS_ISSUED_WARNING = Pattern.compile(".*\u0431\u0438\u043b\u0435\u0442\u044b \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u044b.*", 2);

    public void process(MessageContext ctx) {
        WarningType warning;
        MixvelOrderViewRS orderViewRS = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        if (orderViewRS.getResponse().getTicketDocInfo() != null) {
            for (TicketDocInfoType ticketDocInfo : orderViewRS.getResponse().getTicketDocInfo()) {
                if (ticketDocInfo.getTicket() == null) continue;
                for (TicketType ticket : ticketDocInfo.getTicket()) {
                    if (ticket.getCoupon() == null) continue;
                    for (CouponType coupon : ticket.getCoupon()) {
                        if ("VOID".equals(coupon.getCouponStatusCode())) continue;
                        throw new CannotCancelIssuedException("\u041d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0437\u0430\u043a\u0430\u0437 \u0431\u044b\u043b \u0443\u0436\u0435 \u0432\u044b\u043f\u0438\u0441\u0430\u043d \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442 {1}", new Object[]{orderViewRS.getResponse().getMixOrder().getMixOrderID(), ticket.getTicketNumber()});
                    }
                }
            }
        }
        if (orderViewRS.getResponse().getWarning() != null && (warning = (WarningType)orderViewRS.getResponse().getWarning().stream().filter(w -> w.getDescText() != null && P_TICKETS_ISSUED_WARNING.matcher(w.getDescText()).matches()).findFirst().orElse(null)) != null) {
            throw new CannotCancelIssuedException("\u041d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442 \u043e\u0442\u043c\u0435\u043d\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0437\u0430\u043a\u0430\u0437 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0431\u044b\u043b \u0443\u0436\u0435 \u0432\u044b\u043f\u0438\u0441\u0430\u043d \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 {1}", new Object[]{orderViewRS.getResponse().getMixOrder().getMixOrderID(), warning.getDescText()});
        }
    }
}

