/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelCustomPropertiesHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.gds.mixvel.createReservation.MixvelOrderCreateRQHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CarrierType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ContactInfoListType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ContactInfoType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ContactTypeEnum;
import https.www_mixvel_com.api.xsd.mixvel._1_01.EmailAddressType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.IdentityDocType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.IndividualType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.LoyaltyProgramType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxListType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PhoneType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.SelectedOfferItemType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.SelectedOfferType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.CreateOrderType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.LoyaltyProgramAccountCreateListType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.LoyaltyProgramAccountCreateType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.MixvelOrderCreateRQ;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.PaxSegmentRemarkCreateListType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.PaxSegmentRemarkCreateType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MixvelOrderCreateRQBuilder
extends BaseProcessor {
    private static final String CONTACT_INFO_PREFIX = "ContactInfo-";
    private static final String CONTACT_TYPE_PERSONAL = "personal";
    private static final String CONTACT_TYPE_AGENCY = "agency";

    public void process(MessageContext ctx) {
        String remarkText;
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        String offerId = MixvelCustomPropertiesHelper.getOfferId(flight);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        MixvelOrderCreateRQ mixvelOrderCreateRQ = new MixvelOrderCreateRQ();
        HashMap ptcToPaxRefIds = new HashMap();
        RequestType request = new RequestType();
        DataListsType dataLists = new DataListsType();
        dataLists.setPaxList(new PaxListType());
        dataLists.setContactInfoList(new ContactInfoListType());
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List gdsTravellers = parameters.getGdsTravellers();
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        int idx = 1;
        List<String> paxSegmentRefIDs = FlightHelper.getFlightSegmentsStream((Flight)flight).map(FlightSegment::getGdsId).filter(TextUtil::nonBlank).collect(Collectors.toList());
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
            String id = String.valueOf(idx);
            PaxType pax = new PaxType();
            pax.setCitizenshipCountryCode(MixvelHelper.getNativeCode(traveller.getPassport().getCitizenship()));
            pax.setPaxID("Pax-".concat(id));
            String paxID = pax.getPaxID();
            gdsTraveller.setGdsId(paxID);
            pax.setPTC(MixvelHelper.getPassengerTypeCode((DictionaryReference<PassengerType>)gdsTraveller.getPassengerType()));
            if (!ptcToPaxRefIds.containsKey(pax.getPTC())) {
                ptcToPaxRefIds.put(pax.getPTC(), new HashSet());
            }
            ((Set)ptcToPaxRefIds.get(pax.getPTC())).add(paxID);
            IdentityDocType identityDoc = new IdentityDocType();
            if (traveller.getPassport().getExpired() != null) {
                identityDoc.setExpiryDate(JaxWsHelper.toGregorianLocalDate((Date)traveller.getPassport().getExpired()));
            }
            if (traveller.getPassport().getIssued() != null) {
                identityDoc.setIssueDate(JaxWsHelper.toGregorianLocalDate((Date)traveller.getPassport().getIssued()));
            }
            identityDoc.setIdentityDocID(traveller.getPassport().getNumber());
            identityDoc.setIdentityDocTypeCode(MixvelHelper.mapPassportType(traveller.getPassport().getType()));
            identityDoc.setSurname(flight.isLatinRegistration() ? traveller.getPassport().getLastName() : MixvelHelper.fixNameForPNR(traveller.getPassport().getLastName()));
            pax.getIdentityDoc().add(identityDoc);
            IndividualType individual = new IndividualType();
            individual.setBirthdate(JaxWsHelper.toGregorianLocalDate((Date)traveller.getPassport().getBirthday()));
            individual.setGenderCode(MixvelHelper.mapGender(traveller.getPassport().getGender()));
            individual.getGivenName().add(flight.isLatinRegistration() ? traveller.getPassport().getFirstName() : MixvelHelper.fixNameForPNR(traveller.getPassport().getFirstName()));
            if (traveller.getPassport().getMiddleName() != null) {
                individual.getMiddleName().add(flight.isLatinRegistration() ? traveller.getPassport().getMiddleName() : MixvelHelper.fixNameForPNR(traveller.getPassport().getMiddleName()));
            }
            individual.setSurname(flight.isLatinRegistration() ? traveller.getPassport().getLastName() : MixvelHelper.fixNameForPNR(traveller.getPassport().getLastName()));
            pax.setIndividual(individual);
            pax.setContactInfoRefID(CONTACT_INFO_PREFIX.concat(id));
            if (!traveller.getAirlineBonusCards().isEmpty()) {
                if (dataLists.getLoyaltyProgramAccountList() == null) {
                    dataLists.setLoyaltyProgramAccountList(new LoyaltyProgramAccountCreateListType());
                }
                dataLists.getLoyaltyProgramAccountList().getLoyaltyProgramAccount().addAll(traveller.getAirlineBonusCards().stream().map(card -> MixvelOrderCreateRQBuilder.buildLoyaltyProgramAccount((AirlineBonusCard)card, paxSegmentRefIDs, offerId, paxID)).collect(Collectors.toList()));
            }
            if (!DictHelper.isInfantPassengerTypeCategory((DictionaryReference)gdsTraveller.getPassengerType())) {
                MixvelOrderCreateRQBuilder.maybeAddOrganizationAirlineBonusCard(dataLists, flight, customer, salesContext, paxSegmentRefIDs, offerId, paxID);
            }
            dataLists.getPaxList().getPax().add(pax);
            ArrayList<PaxSegmentRemarkCreateType> remarks = new ArrayList<PaxSegmentRemarkCreateType>();
            if (!DictHelper.isInfantPassengerTypeCategory((DictionaryReference)gdsTraveller.getPassengerType())) {
                traveller.getDocoInformations().stream().map(doco -> MixvelOrderCreateRQHelper.buildDocoText(doco, false)).map(text -> MixvelOrderCreateRQBuilder.buildPaxSegmentRemark(offerId, paxID, "doco", text)).forEach(remarks::add);
                traveller.getDocaInformations().stream().map(doca -> MixvelOrderCreateRQHelper.buildDocaText(doca, false)).map(text -> MixvelOrderCreateRQBuilder.buildPaxSegmentRemark(offerId, paxID, "doca", text)).forEach(remarks::add);
                String tourCode = flight.getTourCode();
                if (TextUtil.nonBlank((String)tourCode)) {
                    remarks.add(MixvelOrderCreateRQBuilder.buildPaxSegmentRemark(offerId, paxID, "tourcode", tourCode));
                }
                EntityReference clientRef = salesContext.getClient();
                EntityContainer clientEtc = EntityStorage.get().resolve(clientRef);
                Organization client = (Organization)clientEtc.getEntity();
                String code = client.getCode();
                if (TextUtil.nonBlank((String)code)) {
                    remarks.add(MixvelOrderCreateRQBuilder.buildPaxSegmentRemark(offerId, paxID, "other", "\u0420\u041c\u0420\u041a\u041d\u041a" + code));
                }
                if (flight.getTripartiteContractDetails() != null) {
                    for (String ssr : flight.getTripartiteContractDetails().getSsrs()) {
                        remarks.add(MixvelOrderCreateRQBuilder.buildPaxSegmentRemark(offerId, paxID, "other", MixvelOrderCreateRQBuilder.getTripartiteSsrText(ssr)));
                    }
                }
            }
            if (!remarks.isEmpty()) {
                if (dataLists.getPaxSegmentRemarkList() == null) {
                    dataLists.setPaxSegmentRemarkList(new PaxSegmentRemarkCreateListType());
                }
                dataLists.getPaxSegmentRemarkList().getPaxSegmentRemark().addAll(remarks);
            }
            ++idx;
        }
        this.addContacts(dataLists, salesContext, gdsTravellers, travellers, customer);
        request.setDataLists(dataLists);
        CreateOrderType createOrder = new CreateOrderType();
        SelectedOfferType selectedOffer = new SelectedOfferType();
        selectedOffer.setOfferRefID(offerId);
        for (Map.Entry<String, Set<String>> entry : MixvelOrderCreateRQBuilder.getOfferItemIdsFromCustomProperties(flight).entrySet()) {
            for (String offerItemId : entry.getValue()) {
                SelectedOfferItemType selectedOfferItemType = new SelectedOfferItemType();
                selectedOfferItemType.setOfferItemRefID(offerItemId);
                selectedOfferItemType.getPaxRefID().addAll((Collection)ptcToPaxRefIds.get(entry.getKey()));
                selectedOffer.getSelectedOfferItem().add(selectedOfferItemType);
            }
        }
        createOrder.getSelectedOffer().add(selectedOffer);
        request.setCreateOrder(createOrder);
        TripartiteContractDetails details3d = flight.getTripartiteContractDetails();
        if (details3d != null && TextUtil.nonBlank((String)(remarkText = details3d.getTripartiteContractRemark()))) {
            MixvelOrderCreateRQHelper.addOtherServiceInfo(request, remarkText);
        }
        mixvelOrderCreateRQ.setRequest(request);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)mixvelOrderCreateRQ);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/create");
    }

    private static String getTripartiteSsrText(String ssr) {
        return (ssr.indexOf(59) >= 0 ? ssr.substring(ssr.lastIndexOf(59) + 1) : ssr).trim();
    }

    private static void maybeAddOrganizationAirlineBonusCard(DataListsType dataLists, Flight flight, Customer customer, SalesContext salesContext, List<String> paxSegmentRefIDs, String offerRefId, String paxRefId) {
        if (flight.getOrganizationAirlineBonusCardsParameters() == null) {
            return;
        }
        if (flight.getOrganizationAirlineBonusCardsParameters().getFqtvFormat() == null) {
            return;
        }
        AirlineBonusCard card = GDSHelper.getOrganizationAirlineBonusCard((Customer)customer, (EntityReference)salesContext.getAgent(), (SalesChain)flight.getSalesChain(), (DictionaryReference)flight.getOrganizationAirlineBonusCardsParameters().getAirline());
        if (card == null) {
            return;
        }
        if (dataLists.getLoyaltyProgramAccountList() == null) {
            dataLists.setLoyaltyProgramAccountList(new LoyaltyProgramAccountCreateListType());
        }
        dataLists.getLoyaltyProgramAccountList().getLoyaltyProgramAccount().add(MixvelOrderCreateRQBuilder.buildLoyaltyProgramAccount(card, paxSegmentRefIDs, offerRefId, paxRefId));
    }

    private static PaxSegmentRemarkCreateType buildPaxSegmentRemark(String offerRefID, String paxID, String type, String text) {
        PaxSegmentRemarkCreateType paxSegmentRemark = new PaxSegmentRemarkCreateType();
        paxSegmentRemark.setOfferRefID(offerRefID);
        paxSegmentRemark.setPaxRefID(paxID);
        paxSegmentRemark.setType(type);
        paxSegmentRemark.setText(text);
        return paxSegmentRemark;
    }

    private static LoyaltyProgramAccountCreateType buildLoyaltyProgramAccount(AirlineBonusCard card, List<String> paxSegmentRefIDs, String offerRefId, String paxRefId) {
        String airlineCode = MixvelHelper.getNativeCode(card.getAirline());
        LoyaltyProgramAccountCreateType account = new LoyaltyProgramAccountCreateType();
        account.setAccountNumber(card.getNumber());
        LoyaltyProgramType program = new LoyaltyProgramType();
        CarrierType carrier = new CarrierType();
        carrier.setAirlineDesigCode(airlineCode);
        program.setCarrier(carrier);
        account.setLoyaltyProgram(program);
        if (!"SU".equalsIgnoreCase(airlineCode)) {
            account.getPaxSegmentRefID().addAll(paxSegmentRefIDs);
        }
        account.setOfferRefID(offerRefId);
        account.setPaxRefID(paxRefId);
        return account;
    }

    private static Map<String, Set<String>> getOfferItemIdsFromCustomProperties(Flight flight) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            for (FareInfo fi : fs.getFareInfos()) {
                String ptc = MixvelHelper.getPassengerTypeCode((DictionaryReference<PassengerType>)fi.getPassengerType());
                if (!result.containsKey(ptc)) {
                    result.put(ptc, new HashSet());
                }
                ((Set)result.get(ptc)).add(MixvelCustomPropertiesHelper.getOfferItemId(fi));
            }
        }
        return result;
    }

    private void addContacts(DataListsType dataLists, SalesContext salesContext, Collection<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, Customer customer) {
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            String index = gdsTraveller.getGdsId().replaceAll("\\D+", "");
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            ContactInfoType contactsTraveller = new ContactInfoType();
            dataLists.getContactInfoList().getContactInfo().add(contactsTraveller);
            contactsTraveller.setContactInfoID(CONTACT_INFO_PREFIX.concat(index));
            traveller.getCommunications().forEach(comm -> this.addContact(contactsTraveller, (Communication)comm, CONTACT_TYPE_PERSONAL));
            if (customer == null) continue;
            for (Communication communication : customer.getCommunications()) {
                boolean isPhoneFromCustomerAddedNeeded;
                boolean isEmailFromCustomerAddedNeeded;
                if (communication.getType() == CommunicationType.EMAIL && (isEmailFromCustomerAddedNeeded = contactsTraveller.getEmailAddress().stream().noneMatch(email -> email.getEmailAddressText().equals(ProfileHelper.normalizeCommunicationPart((String)communication.getSense()))))) {
                    this.addContact(contactsTraveller, communication, CONTACT_TYPE_PERSONAL);
                }
                if (communication.getType() != CommunicationType.MOBILE || !(isPhoneFromCustomerAddedNeeded = contactsTraveller.getPhone().stream().noneMatch(phone -> phone.getPhoneNumber().equals(MixvelHelper.buildFullPhoneNumber(communication))))) continue;
                this.addContact(contactsTraveller, communication, CONTACT_TYPE_PERSONAL);
            }
        }
        ContactInfoType contactsAgency = new ContactInfoType();
        dataLists.getContactInfoList().getContactInfo().add(contactsAgency);
        contactsAgency.setContactInfoID(CONTACT_INFO_PREFIX.concat(CONTACT_TYPE_AGENCY));
        EntityReference agencyRef = salesContext.getAgency();
        EntityContainer agencyContainer = EntityStorage.get().resolve(agencyRef);
        Organization agency = (Organization)agencyContainer.getEntity();
        List comms = agency.getCommunications();
        CommunicationType agencyPhoneType = comms.stream().anyMatch(comm -> comm.getType() == CommunicationType.AGENCY) ? CommunicationType.AGENCY : CommunicationType.WORK_PHONE;
        for (Communication comm2 : comms) {
            if (comm2.getType() != agencyPhoneType && comm2.getType() != CommunicationType.EMAIL) continue;
            this.addContact(contactsAgency, comm2, CONTACT_TYPE_AGENCY);
        }
    }

    private void addContact(ContactInfoType contacts, Communication communication, String typeText) {
        CommunicationType type = communication.getType();
        switch (type) {
            case EMAIL: {
                EmailAddressType email = new EmailAddressType();
                email.setContactTypeCode(ContactTypeEnum.EMAIL);
                email.setContactTypeText(typeText);
                email.setEmailAddressText(ProfileHelper.normalizeCommunicationPart((String)communication.getSense()));
                contacts.getEmailAddress().add(email);
                break;
            }
            case MOBILE: {
                PhoneType phone = new PhoneType();
                phone.setContactTypeCode(ContactTypeEnum.MOBILE);
                phone.setContactTypeText(typeText);
                phone.setPhoneNumber(MixvelHelper.buildFullPhoneNumber(communication));
                contacts.getPhone().add(phone);
                break;
            }
            case AGENCY: 
            case WORK_PHONE: {
                PhoneType agency = new PhoneType();
                agency.setContactTypeCode(ContactTypeEnum.AGENCY);
                agency.setContactTypeText(typeText);
                agency.setPhoneNumber(MixvelHelper.buildFullPhoneNumber(communication));
                contacts.getPhone().add(agency);
                break;
            }
        }
    }
}

