/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.createReservation;

import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.SelectedOfferType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.OtherServiceInfoCreateListType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.OtherServiceInfoCreateType;
import https.www_mixvel_com.api.xsd.mixvel_ordercreaterq._1_01.RequestType;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang.time.FastDateFormat;

public class MixvelOrderCreateRQHelper {
    private static final FastDateFormat SSR_IATA_DF = FastDateFormat.getInstance((String)"ddMMMyy", (Locale)Locale.ENGLISH);

    public static String buildDocoText(DocoInformation docoInfo, boolean isInfant) {
        StringBuilder sb = new StringBuilder();
        if (isInfant) {
            sb.insert(0, 'I');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaApplicableCountry() != null) {
            sb.insert(0, MixvelHelper.getNativeCode(docoInfo.getVisaApplicableCountry()));
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaIssueDate() != null) {
            sb.insert(0, SSR_IATA_DF.format(docoInfo.getVisaIssueDate()).toUpperCase());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaIssuePlace() != null) {
            sb.insert(0, docoInfo.getVisaIssuePlace());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docoInfo.getVisaNumber())) {
            sb.insert(0, docoInfo.getVisaNumber());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.isVisa()) {
            sb.insert(0, 'V');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        StringBuilder sbPlaceOfBirth = new StringBuilder();
        if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthCity())) {
            sbPlaceOfBirth.append(docoInfo.getPlaceOfBirthCity());
            if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthState())) {
                sbPlaceOfBirth.append(' ');
                sbPlaceOfBirth.append(docoInfo.getPlaceOfBirthState());
            }
        }
        if (docoInfo.getPlaceOfBirthCountry() != null) {
            if (sbPlaceOfBirth.length() > 0) {
                sbPlaceOfBirth.append(' ');
            }
            sbPlaceOfBirth.append(MixvelHelper.getNativeCode(docoInfo.getPlaceOfBirthCountry()));
        }
        if (sbPlaceOfBirth.length() > 0) {
            sb.insert(0, TextUtil.first((String)sbPlaceOfBirth.toString(), (int)32));
        }
        return sb.toString();
    }

    public static String buildDocaText(DocaInformation docaInfo, boolean isInfant) {
        StringBuilder sb = new StringBuilder();
        if (isInfant) {
            sb.insert(0, 'I');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getZipPostalCode())) {
            sb.insert(0, docaInfo.getZipPostalCode());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getStateProvince())) {
            sb.insert(0, docaInfo.getStateProvince());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getCity())) {
            sb.insert(0, docaInfo.getCity());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getStreet())) {
            sb.insert(0, docaInfo.getStreet());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        sb.insert(0, MixvelHelper.getNativeCode(docaInfo.getCountry()));
        sb.insert(0, '/');
        switch (docaInfo.getType()) {
            case DESTINATION: {
                sb.insert(0, 'D');
                break;
            }
            case RESIDENCE: {
                sb.insert(0, 'R');
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unexpected doca address type", (Object[])new Object[]{docaInfo.getType()});
            }
        }
        return sb.toString();
    }

    public static void addOtherServiceInfo(RequestType request, String text) {
        DataListsType dataLists = request.getDataLists();
        String offerRefID = ((SelectedOfferType)CollectionUtil.single((Collection)request.getCreateOrder().getSelectedOffer())).getOfferRefID();
        if (dataLists.getOtherServiceInfoList() == null) {
            dataLists.setOtherServiceInfoList(new OtherServiceInfoCreateListType());
        }
        OtherServiceInfoCreateType otherServiceInfo = new OtherServiceInfoCreateType();
        otherServiceInfo.setOfferRefID(offerRefID);
        otherServiceInfo.setText(text);
        dataLists.getOtherServiceInfoList().getOtherServiceInfo().add(otherServiceInfo);
    }
}

