/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelRemarksSearchContext;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.mixvel.DataListsIndex;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BookingRefType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DatedOperatingLegType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareComponentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareDetailType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.MixOrderType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OfferRemarkType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderItemType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderServiceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PriceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.UnitCodeType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class MixvelOrderViewRSParser
extends BaseProcessor {
    private static final ZoneId MIXVEL_TIME_ZONE = ZoneId.of("Europe/Moscow");

    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        MixvelOrderViewRS mixvelOrderViewRS = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        List gdsTravellers = parameters.getGdsTravellers();
        DataListsIndex index = new DataListsIndex(mixvelOrderViewRS.getResponse().getDataLists());
        MixOrderType mixOrder = mixvelOrderViewRS.getResponse().getMixOrder();
        OrderType order = (OrderType)CollectionUtil.single((Collection)mixOrder.getOrder());
        Reservation reservation = new Reservation();
        reservation.setAccountCode(parameters.getFlight().getAccountCode());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.MIXVEL, (RecordLocatorType)RecordLocatorType.MIXVEL_MIX_ORDER_ID, (String)mixOrder.getMixOrderID());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.MIXVEL, (RecordLocatorType)RecordLocatorType.MIXVEL_ORDER_ID, (String)order.getOrderID());
        HashMap<String, String> airlineLocators = new HashMap<String, String>();
        boolean sirenaLocatorFound = false;
        String recordLocator = null;
        for (BookingRefType bookingRef : order.getBookingRef()) {
            if (!Objects.nonNull(bookingRef.getBookingEntity())) continue;
            if (MixvelHelper.SIRENA_CODES.contains(bookingRef.getBookingEntity().getCarrier().getAirlineDesigCode())) {
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN, (String)bookingRef.getBookingID());
                recordLocator = bookingRef.getBookingID();
                sirenaLocatorFound = true;
                continue;
            }
            airlineLocators.put(bookingRef.getBookingEntity().getCarrier().getAirlineDesigCode(), bookingRef.getBookingID());
        }
        if (!sirenaLocatorFound) {
            throw Xeption.forDeveloper((String)"1H locator not found", (Object[])new Object[0]);
        }
        Date now = new Date();
        reservation.setPricingDate(now);
        reservation.setPqTimeLimit(MixvelOrderViewRSParser.calculateTimeLimit(order, (MixvelGdsAccount)gdsAccountCtr.getEntity()));
        Set startingPaxSegmentRefIds = mixvelOrderViewRS.getResponse().getDataLists().getPaxJourneyList().getPaxJourney().stream().map(paxJourney -> (String)paxJourney.getPaxSegmentRefID().get(0)).collect(Collectors.toSet());
        for (OrderItemType orderItem : order.getOrderItem()) {
            FareDetailType fareDetail = (FareDetailType)CollectionUtil.single((Collection)orderItem.getFareDetail());
            for (String paxRefID : fareDetail.getPaxRefID()) {
                GdsTraveller gdsTraveller = gdsTravellers.stream().filter(traveller -> paxRefID.equals(traveller.getGdsId())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"gds traveller with id {0} not found", (Object[])new Object[]{paxRefID}));
                Traveller traveller2 = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
                Product product = new Product();
                product.setSalesOriginContent(SalesOriginContent.SIRENA);
                product.setSalesOriginProvider(SalesOriginProvider.SIRENA);
                product.setReservation(reservation);
                product.setTravellerGdsId(paxRefID);
                product.setGdsCurrency(order.getTotalPrice().getTotalAmount().getCurCode());
                product.setTraveller(traveller2);
                product.setProductCategory(ProductCategory.AIR);
                product.setPassengerType(MixvelHelper.resolvePassengerTypeCode(index.getPax(gdsTraveller.getGdsId()).getPTC()));
                String validatingPartyRefId = (String)Streams.single(orderItem.getService().stream().filter(service -> paxRefID.equals(service.getPaxRefID().getValue())).map(OrderServiceType::getValidatingPartyRefID).distinct());
                product.setCarrier(MixvelHelper.resolveNativeCode(Airline.class, index.getValidatingParty(validatingPartyRefId).getValidatingPartyCode()));
                product.setTariffType(TariffType.REGULAR);
                product.setTourCode(MixvelOrderViewRSParser.findTourCode(orderItem.getRemark(), paxRefID));
                int idx = 0;
                for (FareComponentType fareComponent : fareDetail.getFareComponent()) {
                    SegmentTariff st = new SegmentTariff();
                    for (String paxSegmentRefId : fareComponent.getPaxSegmentRefID()) {
                        PaxSegmentType paxSegment = index.getPaxSegment(paxSegmentRefId);
                        Segment seg = new Segment();
                        seg.setGdsId(paxSegmentRefId);
                        seg.setAirlineLocator((String)airlineLocators.get(paxSegment.getMarketingCarrierInfo().getCarrierDesigCode()));
                        seg.setStarting(startingPaxSegmentRefIds.contains(paxSegmentRefId));
                        seg.setAirline(MixvelHelper.resolveNativeCode(Airline.class, paxSegment.getMarketingCarrierInfo().getCarrierDesigCode()));
                        seg.setFlightNo(GDSHelper.stripZeroesInFlightNumber((String)paxSegment.getMarketingCarrierInfo().getMarketingCarrierFlightNumberText()));
                        if (paxSegment.getOperatingCarrierInfo() != null) {
                            seg.setCodeShareCarrier(MixvelHelper.resolveNativeCode(Airline.class, paxSegment.getOperatingCarrierInfo().getCarrierDesigCode()));
                            seg.setCodeShare(!seg.getAirline().equals((Object)seg.getCodeShareCarrier()));
                        } else {
                            seg.setCodeShareCarrier(seg.getAirline());
                        }
                        seg.setDepartureLocation(MixvelHelper.resolveNativeCode(GeoLocation.class, paxSegment.getDep().getIATALocationCode().getValue()));
                        seg.setArriveLocation(MixvelHelper.resolveNativeCode(GeoLocation.class, paxSegment.getArrival().getIATALocationCode().getValue()));
                        seg.setStartDate(paxSegment.getDep().getScheduledDateTime().toGregorianCalendar().getTime());
                        seg.setEndDate(paxSegment.getArrival().getScheduledDateTime().toGregorianCalendar().getTime());
                        seg.setDepartTerminal(paxSegment.getDep().getTerminalName());
                        seg.setArriveTerminal(paxSegment.getArrival().getTerminalName());
                        seg.setBoard(MixvelHelper.resolveNativeCode(Aircraft.class, ((DatedOperatingLegType)paxSegment.getDatedOperatingLeg().get(0)).getCarrierType().getCarrierTypeCode()));
                        seg.setFlightDuration(Integer.valueOf(paxSegment.getDuration().getHours() * 60 + paxSegment.getDuration().getMinutes()));
                        seg.setNoOfStops(Integer.valueOf(paxSegment.getDatedOperatingLeg().size() - 1));
                        seg.setClassOfSvcCode(fareComponent.getRBD().getRBDCode());
                        seg.getTechStopInfos().addAll(MixvelHelper.parseTechStopInfos(paxSegment.getDatedOperatingLeg()));
                        MixvelRemarksSearchContext mrsc = new MixvelRemarksSearchContext();
                        mrsc.setOrderId(order.getOrderID());
                        mrsc.setOrderItemId(orderItem.getOrderItemID());
                        mrsc.setSegmentIndex(idx);
                        seg.setRemarksSearchContext(XSUtil.toString((XSSerializable)mrsc));
                        if (paxSegment.getDistance() != null) {
                            if (UnitCodeType.MILEAGE == paxSegment.getDistance().getUnitCode()) {
                                seg.setFlightDistanceMiles(Integer.valueOf(paxSegment.getDistance().getValue()));
                            } else {
                                IncidentsLog.reportStackTrace((String)("unexpected distance unit code in reservation " + recordLocator + ": " + paxSegment.getDistance().getUnitCode()));
                            }
                        }
                        st.getSegments().add(seg);
                        ++idx;
                    }
                    product.getSegmentTariffs().add(st);
                }
                if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
                    product.getTripartiteContractDetails().setIssuedUnder3d(true);
                }
                reservation.getProducts().add(product);
            }
        }
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private static Date calculateTimeLimit(OrderType order, MixvelGdsAccount gdsAccount) {
        return Stream.concat(order.getOrderItem().stream().map(OrderItemType::getPaymentTimeLimitDateTime).filter(Objects::nonNull).map(cal -> cal.toGregorianCalendar().getTime()), order.getOrderItem().stream().map(OrderItemType::getFareDetail).filter(Objects::nonNull).flatMap(Collection::stream).map(FareDetailType::getFareComponent).filter(Objects::nonNull).flatMap(Collection::stream).map(FareComponentType::getPrice).filter(Objects::nonNull).map(PriceType::getBaseAmountGuaranteeTimeLimitDateTime).filter(Objects::nonNull).map(XMLGregorianCalendar::toGregorianCalendar).map(GregorianCalendar::toZonedDateTime).map(ZonedDateTime::toLocalDateTime).map(ldt -> Date.from(ldt.atZone(MIXVEL_TIME_ZONE).toInstant()))).min(Comparator.naturalOrder()).orElse(null);
    }

    private static String findTourCode(List<OfferRemarkType> remarks, String paxRefID) {
        return (String)Streams.singleOrNull(remarks.stream().filter(remark -> paxRefID.equals(remark.getPaxRefID())).filter(remark -> "tourcode".equals(remark.getType())).map(OfferRemarkType::getText).distinct());
    }
}

