/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.createReservation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;

public class MixvelOrderViewRSParserTest
extends ModelTestBase {
    @Test
    public void test() throws Exception {
        MixvelOrderViewRS mixvelOrderViewRS = this.readResponseFromFile(MixvelOrderViewRS.class, "OrderViewRS.xml");
        OrderType order = (OrderType)CollectionUtil.single((Collection)mixvelOrderViewRS.getResponse().getMixOrder().getOrder());
        EntityReference gdsAccountRef = EntityContainer.create((BaseEntity)new MixvelGdsAccount()).toReference();
        Reservation reservation = new Reservation();
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountRef);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.MIXVEL, (RecordLocatorType)RecordLocatorType.MIXVEL_MIX_ORDER_ID, (String)"01138-220804-MET1644");
        order.getBookingRef().stream().filter(bookingRefType -> Objects.nonNull(bookingRefType.getBookingEntity())).filter(bookingRefType -> "1H".equals(bookingRefType.getBookingEntity().getCarrier().getAirlineDesigCode())).findAny().ifPresent(pnr -> CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN, (String)pnr.getBookingID()));
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        Assert.assertEquals((Object)"1Z9ZZ8", (Object)((RecordLocatorInfo)Streams.single(((ReservationSystemInfo)Streams.single(gdsNameInfo.getSystemInfos().stream().filter(si -> si.getGdsName() == GdsName.SIRENA))).getRecordLocators().stream().filter(rli -> rli.getType() == RecordLocatorType.SIRENA_LATIN))).getRecordLocator());
    }

    private <T> MixvelOrderViewRS readResponseFromFile(Class<T> responseClass, String fileName) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)responseClass.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        InputStreamReader rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        return (MixvelOrderViewRS)unmarshaller.unmarshal((Reader)rdr);
    }
}

